-- do not edit; automatically generated by UU.AG
module Transform where

import qualified UU.DData.Map as Map
import UU.Util.Utils
import UU.Pretty
import UU.DData.Set as Set
import UU.DData.Seq as Seq
import UU.DData.Map (Map)
import ConcreteSyntax
import AbstractSyntax
import Patterns
import ErrorMessages
import List (partition)
import Maybe
import UU.Scanner.Position(noPos)
import Options
import qualified SemRules  
import SemRules(DefinedAttrs, FieldMap, checkDef, hasAttr)  

import CommonTypes
import Patterns
import Rules
import UU.Pretty
import UU.Scanner.Position(Pos)
import Expression

checkDuplicate :: (Identifier -> Identifier -> Error) 
               -> Identifier -> val -> Map Identifier val -> (Map Identifier val,Seq Error) 
checkDuplicate dupError key val m
  = case Map.lookupIndex key m of
     Just ix -> let (key',_) = Map.elemAt ix m
                in  (m,Seq.single (dupError key key'))
     Nothing -> (Map.insert key val m,Seq.empty)  

checkDuplicates :: (Identifier -> Identifier -> Error) 
                -> [(Identifier, val)] -> Map Identifier val -> (Map Identifier val,Seq Error)
checkDuplicates dupError new m = foldErrors check m new
 where  check = uncurry (checkDuplicate dupError) 
         
foldErrors f e xs = foldl g (e,Seq.empty) xs 
  where g ~(e,es) x = let (e',es') = f x e
                      in (e', es <> es')  

type DataTypes = Map.Map Nonterminal DataAlts
type DataAlts  = Map.Map Constructor FieldMap

type DefinedSets = Map Name (Set Nonterminal)

flattenDatas :: DataTypes -> Map Nonterminal (Set Nonterminal)
flattenDatas ds = Map.map flatten ds
  where flatten cs =  Set.fromList [ nt | (_,NT nt) <- concatMap snd (Map.toList cs)]

reachableFrom :: Map Nonterminal (Set Nonterminal) -> Set Nonterminal -> Set Nonterminal
reachableFrom table nts = reach nts
  where reach nts = let nts' = Set.unions (nts : [ ns  | nt <- Set.toList nts
                                                 , let ns = Map.findWithDefault Set.empty nt table ]) 
                    in if Set.size nts' > Set.size nts
                          then reach nts'
                          else nts
invert :: Map Nonterminal (Set Nonterminal) -> Map Nonterminal (Set Nonterminal)
invert m = foldr inv Map.empty (Map.toList m)
  where inv (x,ns) m = fold (\n m -> Map.insertWith Set.union n (Set.single x) m) m ns

path :: Map Nonterminal (Set Nonterminal) -> Nonterminal -> Nonterminal -> Set Nonterminal
path table from to = let children = Map.findWithDefault Set.empty from table                                      
                         forward  = reachableFrom table children
                         backward = reachableFrom (invert table) 
                                                  (Set.single to)
                     in  Set.intersection forward backward

mergeDerivings m1 m2 = foldr (\(n,cs) m -> Map.insertWith Set.union n cs m) m2 (Map.toList m1)

merge x y = foldr f y (Map.toList x) 
 where f ~(k,v) m = Map.insertWith (Map.union) k v m

checkAttrs datatypes nts inherited synthesized decls = foldErrors check decls nts where
  check nt decls | not (nt `Map.member` datatypes) = (decls,Seq.single(UndefNont nt))
                 | otherwise = let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt decls
                                   (inh',einh) = checkDuplicates (DupInhAttr nt) inherited   inh
                                   (syn',esyn) = checkDuplicates (DupSynAttr nt) synthesized syn 
                               in (Map.insert nt (inh',syn') decls,einh <> esyn)

type RuleMap    = Map Nonterminal RuleMapAlt
type RuleMapAlt = Map Constructor (Rules,DefinedAttrs)

checkUndef err key m errs | Map.member key m = errs
                          | otherwise        = Seq.single (err key)

addSelf name atMap = let (eInh,eSyn) = Map.findWithDefault(Map.empty,Map.empty) name atMap
                     in  Map.insert name (eInh, Map.insert (Ident "self" noPos) (NT _SELF) eSyn)atMap

makeType :: Set Nonterminal -> Type -> Type
makeType nts tp@(NT x) | x == _SELF       = tp
                       | Set.member x nts = tp
                       | otherwise        = Haskell (getName x)
makeType _   tp                           = tp                       

constructGrammar nts gram attrs uses derivings wrappers rules tsyns = 
   let gr = [ (nt,Map.toList alts) | (nt,alts) <- Map.toList gram] 
       prods = map prod gr
       prod (nt,alts) =  let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt attrs
                             rmap      = Map.findWithDefault Map.empty             nt rules
                             alt (con,flds) =
                                   let rules = maybe [] fst (Map.lookup con rmap)                                       
                                       child (nm, tp) =
                                          let (inh,syn) = case tp of 
                                                 NT nt -> Map.findWithDefault (Map.empty,Map.empty) nt attrs
                                                 _     -> (Map.empty,Map.empty)
                                          in Child nm tp inh syn 
                                   in Alternative con (map child flds) rules 
                            in Production nt inh syn (map alt alts)
   in Grammar tsyns uses derivings wrappers prods
 

type Blocks = Map.Map Name [String]
-- AG ----------------------------------------------------------
{-
   inherited attributes:
      options              : Options

   chained attributes:

   synthesised attributes:
      blocks               : Blocks
      errors               : Seq Error
      trans                : Grammar

-}
{-
   local variables for AG.AG:
      nonterminals

-}
-- semantic domain
newtype T_AG = T_AG ((Options) ->
                     ( (Blocks),(Seq Error),(Grammar)))
-- cata
sem_AG :: (AG) ->
          (T_AG)
sem_AG ((AG (_elems))) =
    (sem_AG_AG ((sem_Elems (_elems))))
data Inh_AG = Inh_AG {options_Inh_AG :: Options}
data Syn_AG = Syn_AG {blocks_Syn_AG :: Blocks,errors_Syn_AG :: Seq Error,trans_Syn_AG :: Grammar}
wrap_AG :: (T_AG) ->
           (Inh_AG) ->
           (Syn_AG)
wrap_AG ((T_AG (sem))) ((Inh_AG (i1))) =
    let ( s1,s2,s3) =
            (sem (i1))
    in  (Syn_AG (s1) (s2) (s3))
sem_AG_AG :: (T_Elems) ->
             (T_AG)
sem_AG_AG ((T_Elems (elems_))) =
    (T_AG (\ _lhsIoptions ->
               let _lhsOblocks :: (Blocks)
                   _lhsOerrors :: (Seq Error)
                   _lhsOtrans :: (Grammar)
                   _elemsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                   _elemsIblocks :: (Blocks)
                   _elemsIdatas :: (DataTypes)
                   _elemsIdefSets :: (Map Name (Set Nonterminal,Set Name))
                   _elemsIdefined_nts :: (Set Nonterminal)
                   _elemsIderivings :: (Derivings)
                   _elemsIerrors :: (Seq Error)
                   _elemsIruleMap :: (RuleMap)
                   _elemsItypeSyns :: (TypeSyns)
                   _elemsIuseMap :: (Map Nonterminal (Map Name (String,String)))
                   _elemsIwrappers :: (Set Nonterminal)
                   _elemsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                   _elemsOattributes :: (Map Nonterminal (Attributes, Attributes))
                   _elemsOdatas :: (DataTypes)
                   _elemsOdatatypes :: (DataTypes)
                   _elemsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                   _elemsOdefinedSets :: (DefinedSets)
                   _elemsOnonterminals :: (Set Nonterminal)
                   _elemsOruleMap :: (RuleMap)
                   _elemsOwithSelf :: (Bool)
                   ( _elemsIattrDecls,_elemsIblocks,_elemsIdatas,_elemsIdefSets,_elemsIdefined_nts,_elemsIderivings,_elemsIerrors,_elemsIruleMap,_elemsItypeSyns,_elemsIuseMap,_elemsIwrappers) =
                       (elems_ (_elemsOattrDecls) (_elemsOattributes) (_elemsOdatas) (_elemsOdatatypes) (_elemsOdefSets) (_elemsOdefinedSets) (_elemsOnonterminals) (_elemsOruleMap) (_elemsOwithSelf))
                   -- "Transform.ag"(line 31, column 8)
                   (_elemsOwithSelf@_) =
                       withSelf _lhsIoptions
                   -- "Transform.ag"(line 131, column 8)
                   (_nonterminals@_) =
                       _elemsIdefined_nts
                   -- "Transform.ag"(line 130, column 8)
                   (_elemsOattributes@_) =
                       _elemsIattrDecls
                   -- "Transform.ag"(line 129, column 8)
                   (_elemsOdatatypes@_) =
                       _elemsIdatas
                   -- "Transform.ag"(line 128, column 8)
                   (_elemsOdatas@_) =
                       Map.empty
                   -- "Transform.ag"(line 194, column 8)
                   (_elemsOdefinedSets@_) =
                       Map.map fst _elemsIdefSets
                   -- "Transform.ag"(line 194, column 8)
                   (_elemsOdefSets@_) =
                       Map.mapWithKey (\key _ -> (Set.single key, Set.empty)) _elemsIdatas
                   -- "Transform.ag"(line 322, column 8)
                   (_elemsOattrDecls@_) =
                       Map.empty
                   -- "Transform.ag"(line 378, column 8)
                   (_elemsOruleMap@_) =
                       Map.empty
                   -- "Transform.ag"(line 434, column 8)
                   (_lhsOtrans@_) =
                       let ws = if wrappers _lhsIoptions
                                   then _nonterminals
                                   else  _elemsIwrappers
                       in constructGrammar _nonterminals     _elemsIdatas _elemsIattrDecls _elemsIuseMap
                                        _elemsIderivings ws _elemsIruleMap _elemsItypeSyns
                   -- use rule
                   (_lhsOerrors@_) =
                       _elemsIerrors
                   -- copy rule (up)
                   (_lhsOblocks@_) =
                       _elemsIblocks
                   -- copy rule (from local)
                   (_elemsOnonterminals@_) =
                       _nonterminals
               in  ( _lhsOblocks,_lhsOerrors,_lhsOtrans)))
-- Alt ---------------------------------------------------------
{-
   inherited attributes:
      nonterminals         : Set Nonterminal
      nt                   : Nonterminal

   chained attributes:

   synthesised attributes:
      dataAlt              : (Constructor,FieldMap )
      errors               : Seq Error

-}
{-
   local variables for Alt.Alt:
      fieldMap
      errors

-}
-- semantic domain
newtype T_Alt = T_Alt ((Set Nonterminal) ->
                       (Nonterminal) ->
                       ( ((Constructor,FieldMap )),(Seq Error)))
-- cata
sem_Alt :: (Alt) ->
           (T_Alt)
sem_Alt ((Alt (_pos) (_name) (_fields))) =
    (sem_Alt_Alt (_pos) (_name) (_fields))
data Inh_Alt = Inh_Alt {nonterminals_Inh_Alt :: Set Nonterminal,nt_Inh_Alt :: Nonterminal}
data Syn_Alt = Syn_Alt {dataAlt_Syn_Alt :: (Constructor,FieldMap ),errors_Syn_Alt :: Seq Error}
wrap_Alt :: (T_Alt) ->
            (Inh_Alt) ->
            (Syn_Alt)
wrap_Alt ((T_Alt (sem))) ((Inh_Alt (i1) (i2))) =
    let ( s1,s2) =
            (sem (i1) (i2))
    in  (Syn_Alt (s1) (s2))
sem_Alt_Alt :: (Pos) ->
               (Constructor) ->
               (Fields) ->
               (T_Alt)
sem_Alt_Alt (pos_) (name_) (fields_) =
    (T_Alt (\ _lhsInonterminals
              _lhsInt ->
                let _lhsOdataAlt :: ((Constructor,FieldMap ))
                    _lhsOerrors :: (Seq Error)
                    -- "Transform.ag"(line 109, column 9)
                    (_lhsOdataAlt@_) =
                        (name_, _fieldMap)
                    -- "Transform.ag"(line 106, column 13)
                    ((_fieldMap@_,_errors@_)) =
                        let fields   = [ (n,makeType _lhsInonterminals t) | (n,t) <- fields_ ]
                            (_,errs) = checkDuplicates (DupChild _lhsInt name_) fields Map.empty
                        in (fields,errs)
                    -- use rule
                    (_lhsOerrors@_) =
                        _errors
                in  ( _lhsOdataAlt,_lhsOerrors)))
-- Alts --------------------------------------------------------
{-
   inherited attributes:
      nonterminals         : Set Nonterminal
      nt                   : Nonterminal

   chained attributes:

   synthesised attributes:
      dataAlts             : [(Constructor,FieldMap )]
      errors               : Seq Error

-}
{-
   local variables for Alts.Cons:

-}
{-
   local variables for Alts.Nil:

-}
-- semantic domain
newtype T_Alts = T_Alts ((Set Nonterminal) ->
                         (Nonterminal) ->
                         ( ([(Constructor,FieldMap )]),(Seq Error)))
-- cata
sem_Alts :: (Alts) ->
            (T_Alts)
sem_Alts (list) =
    (Prelude.foldr (sem_Alts_Cons) (sem_Alts_Nil) ((Prelude.map sem_Alt list)))
data Inh_Alts = Inh_Alts {nonterminals_Inh_Alts :: Set Nonterminal,nt_Inh_Alts :: Nonterminal}
data Syn_Alts = Syn_Alts {dataAlts_Syn_Alts :: [(Constructor,FieldMap )],errors_Syn_Alts :: Seq Error}
wrap_Alts :: (T_Alts) ->
             (Inh_Alts) ->
             (Syn_Alts)
wrap_Alts ((T_Alts (sem))) ((Inh_Alts (i1) (i2))) =
    let ( s1,s2) =
            (sem (i1) (i2))
    in  (Syn_Alts (s1) (s2))
sem_Alts_Cons :: (T_Alt) ->
                 (T_Alts) ->
                 (T_Alts)
sem_Alts_Cons ((T_Alt (hd_))) ((T_Alts (tl_))) =
    (T_Alts (\ _lhsInonterminals
               _lhsInt ->
                 let _lhsOdataAlts :: ([(Constructor,FieldMap )])
                     _lhsOerrors :: (Seq Error)
                     _hdIdataAlt :: ((Constructor,FieldMap ))
                     _hdIerrors :: (Seq Error)
                     _hdOnonterminals :: (Set Nonterminal)
                     _hdOnt :: (Nonterminal)
                     _tlIdataAlts :: ([(Constructor,FieldMap )])
                     _tlIerrors :: (Seq Error)
                     _tlOnonterminals :: (Set Nonterminal)
                     _tlOnt :: (Nonterminal)
                     ( _hdIdataAlt,_hdIerrors) =
                         (hd_ (_hdOnonterminals) (_hdOnt))
                     ( _tlIdataAlts,_tlIerrors) =
                         (tl_ (_tlOnonterminals) (_tlOnt))
                     -- "Transform.ag"(line 112, column 10)
                     (_lhsOdataAlts@_) =
                         _hdIdataAlt : _tlIdataAlts
                     -- use rule
                     (_lhsOerrors@_) =
                         _hdIerrors Seq.<> _tlIerrors
                     -- copy rule (down)
                     (_hdOnonterminals@_) =
                         _lhsInonterminals
                     -- copy rule (down)
                     (_hdOnt@_) =
                         _lhsInt
                     -- copy rule (down)
                     (_tlOnonterminals@_) =
                         _lhsInonterminals
                     -- copy rule (down)
                     (_tlOnt@_) =
                         _lhsInt
                 in  ( _lhsOdataAlts,_lhsOerrors)))
sem_Alts_Nil :: (T_Alts)
sem_Alts_Nil  =
    (T_Alts (\ _lhsInonterminals
               _lhsInt ->
                 let _lhsOdataAlts :: ([(Constructor,FieldMap )])
                     _lhsOerrors :: (Seq Error)
                     -- "Transform.ag"(line 113, column 10)
                     (_lhsOdataAlts@_) =
                         []
                     -- use rule
                     (_lhsOerrors@_) =
                         Seq.empty
                 in  ( _lhsOdataAlts,_lhsOerrors)))
-- Attrs -------------------------------------------------------
{-
   inherited attributes:
      datatypes            : DataTypes
      nonterminals         : Set Nonterminal
      nts                  : Set Nonterminal

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)

   synthesised attributes:
      errors               : Seq Error
      useMap               : Map Nonterminal (Map Name (String,String))

-}
{-
   local variables for Attrs.Attrs:
      inherited
      synthesized
      useMap
      attrDecls
      errors

-}
-- semantic domain
newtype T_Attrs = T_Attrs ((Map Nonterminal (Attributes, Attributes)) ->
                           (DataTypes) ->
                           (Set Nonterminal) ->
                           (Set Nonterminal) ->
                           ( (Map Nonterminal (Attributes, Attributes)),(Seq Error),(Map Nonterminal (Map Name (String,String)))))
-- cata
sem_Attrs :: (Attrs) ->
             (T_Attrs)
sem_Attrs ((Attrs (_pos) (_inh) (_chn) (_syn))) =
    (sem_Attrs_Attrs (_pos) (_inh) (_chn) (_syn))
data Inh_Attrs = Inh_Attrs {attrDecls_Inh_Attrs :: Map Nonterminal (Attributes, Attributes),datatypes_Inh_Attrs :: DataTypes,nonterminals_Inh_Attrs :: Set Nonterminal,nts_Inh_Attrs :: Set Nonterminal}
data Syn_Attrs = Syn_Attrs {attrDecls_Syn_Attrs :: Map Nonterminal (Attributes, Attributes),errors_Syn_Attrs :: Seq Error,useMap_Syn_Attrs :: Map Nonterminal (Map Name (String,String))}
wrap_Attrs :: (T_Attrs) ->
              (Inh_Attrs) ->
              (Syn_Attrs)
wrap_Attrs ((T_Attrs (sem))) ((Inh_Attrs (i1) (i2) (i3) (i4))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2) (i3) (i4))
    in  (Syn_Attrs (s1) (s2) (s3))
sem_Attrs_Attrs :: (Pos) ->
                   (AttrNames) ->
                   (AttrNames) ->
                   (AttrNames) ->
                   (T_Attrs)
sem_Attrs_Attrs (pos_) (inh_) (chn_) (syn_) =
    (T_Attrs (\ _lhsIattrDecls
                _lhsIdatatypes
                _lhsInonterminals
                _lhsInts ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOerrors :: (Seq Error)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                      -- "Transform.ag"(line 339, column 11)
                      (_lhsOuseMap@_) =
                          Map.fromList (zip (Set.toList _lhsInts) (repeat _useMap))
                      -- "Transform.ag"(line 332, column 15)
                      ((_inherited@_,_synthesized@_,_useMap@_)) =
                          let splitAttrs xs = unzip [ ((n,makeType _lhsInonterminals t),(n,(c,d)))
                                                    | (n,t,(c,d)) <- xs ]
                              (inh,_)     = splitAttrs inh_
                              (chn,uses1) = splitAttrs chn_
                              (syn,uses2) = splitAttrs syn_
                              isUse (n,(e1,e2)) = not (null e1 || null e2)
                          in (inh++chn,chn++syn, Map.fromList (Prelude.filter isUse (uses1++uses2)))
                      -- "Transform.ag"(line 330, column 15)
                      ((_attrDecls@_,_errors@_)) =
                          checkAttrs _lhsIdatatypes (Set.toList _lhsInts) _inherited _synthesized _lhsIattrDecls
                      -- use rule
                      (_lhsOerrors@_) =
                          _errors
                      -- copy rule (from local)
                      (_lhsOattrDecls@_) =
                          _attrDecls
                  in  ( _lhsOattrDecls,_lhsOerrors,_lhsOuseMap)))
-- ConstructorSet ----------------------------------------------
{-
   inherited attributes:
      definedConstructors  : Set.Set Constructor
      nt                   : Nonterminal

   chained attributes:

   synthesised attributes:
      constructors         : Set.Set Constructor
      errors               : Seq Error

-}
{-
   local variables for ConstructorSet.CAll:

-}
{-
   local variables for ConstructorSet.CDifference:

-}
{-
   local variables for ConstructorSet.CName:

-}
{-
   local variables for ConstructorSet.CUnion:

-}
-- semantic domain
newtype T_ConstructorSet = T_ConstructorSet ((Set.Set Constructor) ->
                                             (Nonterminal) ->
                                             ( (Set.Set Constructor),(Seq Error)))
-- cata
sem_ConstructorSet :: (ConstructorSet) ->
                      (T_ConstructorSet)
sem_ConstructorSet ((CAll )) =
    (sem_ConstructorSet_CAll )
sem_ConstructorSet ((CDifference (_set1) (_set2))) =
    (sem_ConstructorSet_CDifference ((sem_ConstructorSet (_set1))) ((sem_ConstructorSet (_set2))))
sem_ConstructorSet ((CName (_name))) =
    (sem_ConstructorSet_CName (_name))
sem_ConstructorSet ((CUnion (_set1) (_set2))) =
    (sem_ConstructorSet_CUnion ((sem_ConstructorSet (_set1))) ((sem_ConstructorSet (_set2))))
data Inh_ConstructorSet = Inh_ConstructorSet {definedConstructors_Inh_ConstructorSet :: Set.Set Constructor,nt_Inh_ConstructorSet :: Nonterminal}
data Syn_ConstructorSet = Syn_ConstructorSet {constructors_Syn_ConstructorSet :: Set.Set Constructor,errors_Syn_ConstructorSet :: Seq Error}
wrap_ConstructorSet :: (T_ConstructorSet) ->
                       (Inh_ConstructorSet) ->
                       (Syn_ConstructorSet)
wrap_ConstructorSet ((T_ConstructorSet (sem))) ((Inh_ConstructorSet (i1) (i2))) =
    let ( s1,s2) =
            (sem (i1) (i2))
    in  (Syn_ConstructorSet (s1) (s2))
sem_ConstructorSet_CAll :: (T_ConstructorSet)
sem_ConstructorSet_CAll  =
    (T_ConstructorSet (\ _lhsIdefinedConstructors
                         _lhsInt ->
                           let _lhsOconstructors :: (Set.Set Constructor)
                               _lhsOerrors :: (Seq Error)
                               -- "Transform.ag"(line 282, column 17)
                               (_lhsOconstructors@_) =
                                   _lhsIdefinedConstructors
                               -- use rule
                               (_lhsOerrors@_) =
                                   Seq.empty
                           in  ( _lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CDifference :: (T_ConstructorSet) ->
                                  (T_ConstructorSet) ->
                                  (T_ConstructorSet)
sem_ConstructorSet_CDifference ((T_ConstructorSet (set1_))) ((T_ConstructorSet (set2_))) =
    (T_ConstructorSet (\ _lhsIdefinedConstructors
                         _lhsInt ->
                           let _lhsOconstructors :: (Set.Set Constructor)
                               _lhsOerrors :: (Seq Error)
                               _set1Iconstructors :: (Set.Set Constructor)
                               _set1Ierrors :: (Seq Error)
                               _set1OdefinedConstructors :: (Set.Set Constructor)
                               _set1Ont :: (Nonterminal)
                               _set2Iconstructors :: (Set.Set Constructor)
                               _set2Ierrors :: (Seq Error)
                               _set2OdefinedConstructors :: (Set.Set Constructor)
                               _set2Ont :: (Nonterminal)
                               ( _set1Iconstructors,_set1Ierrors) =
                                   (set1_ (_set1OdefinedConstructors) (_set1Ont))
                               ( _set2Iconstructors,_set2Ierrors) =
                                   (set2_ (_set2OdefinedConstructors) (_set2Ont))
                               -- "Transform.ag"(line 281, column 17)
                               (_lhsOconstructors@_) =
                                   _set1Iconstructors `Set.difference` _set2Iconstructors
                               -- use rule
                               (_lhsOerrors@_) =
                                   _set1Ierrors Seq.<> _set2Ierrors
                               -- copy rule (down)
                               (_set1OdefinedConstructors@_) =
                                   _lhsIdefinedConstructors
                               -- copy rule (down)
                               (_set1Ont@_) =
                                   _lhsInt
                               -- copy rule (down)
                               (_set2OdefinedConstructors@_) =
                                   _lhsIdefinedConstructors
                               -- copy rule (down)
                               (_set2Ont@_) =
                                   _lhsInt
                           in  ( _lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CName :: (Constructor) ->
                            (T_ConstructorSet)
sem_ConstructorSet_CName (name_) =
    (T_ConstructorSet (\ _lhsIdefinedConstructors
                         _lhsInt ->
                           let _lhsOconstructors :: (Set.Set Constructor)
                               _lhsOerrors :: (Seq Error)
                               -- "Transform.ag"(line 275, column 15)
                               ((_lhsOerrors@_,_lhsOconstructors@_)) =
                                   if name_ `Set.member` _lhsIdefinedConstructors
                                      then (Seq.empty, Set.single name_)
                                      else (Seq.single (UndefAlt _lhsInt name_)
                                           , Set.empty
                                           )
                           in  ( _lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CUnion :: (T_ConstructorSet) ->
                             (T_ConstructorSet) ->
                             (T_ConstructorSet)
sem_ConstructorSet_CUnion ((T_ConstructorSet (set1_))) ((T_ConstructorSet (set2_))) =
    (T_ConstructorSet (\ _lhsIdefinedConstructors
                         _lhsInt ->
                           let _lhsOconstructors :: (Set.Set Constructor)
                               _lhsOerrors :: (Seq Error)
                               _set1Iconstructors :: (Set.Set Constructor)
                               _set1Ierrors :: (Seq Error)
                               _set1OdefinedConstructors :: (Set.Set Constructor)
                               _set1Ont :: (Nonterminal)
                               _set2Iconstructors :: (Set.Set Constructor)
                               _set2Ierrors :: (Seq Error)
                               _set2OdefinedConstructors :: (Set.Set Constructor)
                               _set2Ont :: (Nonterminal)
                               ( _set1Iconstructors,_set1Ierrors) =
                                   (set1_ (_set1OdefinedConstructors) (_set1Ont))
                               ( _set2Iconstructors,_set2Ierrors) =
                                   (set2_ (_set2OdefinedConstructors) (_set2Ont))
                               -- "Transform.ag"(line 280, column 12)
                               (_lhsOconstructors@_) =
                                   _set1Iconstructors `Set.union` _set2Iconstructors
                               -- use rule
                               (_lhsOerrors@_) =
                                   _set1Ierrors Seq.<> _set2Ierrors
                               -- copy rule (down)
                               (_set1OdefinedConstructors@_) =
                                   _lhsIdefinedConstructors
                               -- copy rule (down)
                               (_set1Ont@_) =
                                   _lhsInt
                               -- copy rule (down)
                               (_set2OdefinedConstructors@_) =
                                   _lhsIdefinedConstructors
                               -- copy rule (down)
                               (_set2Ont@_) =
                                   _lhsInt
                           in  ( _lhsOconstructors,_lhsOerrors)))
-- Elem --------------------------------------------------------
{-
   inherited attributes:
      attributes           : Map Nonterminal (Attributes, Attributes)
      datatypes            : DataTypes
      definedSets          : DefinedSets
      nonterminals         : Set Nonterminal
      withSelf             : Bool

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)
      blocks               : Blocks
      datas                : DataTypes
      defSets              : Map Name (Set Nonterminal,Set Name)
      ruleMap              : RuleMap

   synthesised attributes:
      defined_nts          : Set Nonterminal
      derivings            : Derivings
      errors               : Seq Error
      typeSyns             : TypeSyns
      useMap               : Map Nonterminal (Map Name (String,String))
      wrappers             : Set Nonterminal

-}
{-
   local variables for Elem.Attr:

-}
{-
   local variables for Elem.Data:
      alternatives
      alternatives2
      errs

-}
{-
   local variables for Elem.Deriving:

-}
{-
   local variables for Elem.Sem:

-}
{-
   local variables for Elem.Set:
      defSets'
      errs

-}
{-
   local variables for Elem.Txt:

-}
{-
   local variables for Elem.Type:
      argType
      datas
      errors

-}
{-
   local variables for Elem.Wrapper:

-}
-- semantic domain
newtype T_Elem = T_Elem ((Map Nonterminal (Attributes, Attributes)) ->
                         (Map Nonterminal (Attributes, Attributes)) ->
                         (Blocks) ->
                         (DataTypes) ->
                         (DataTypes) ->
                         (Map Name (Set Nonterminal,Set Name)) ->
                         (DefinedSets) ->
                         (Set Nonterminal) ->
                         (RuleMap) ->
                         (Bool) ->
                         ( (Map Nonterminal (Attributes, Attributes)),(Blocks),(DataTypes),(Map Name (Set Nonterminal,Set Name)),(Set Nonterminal),(Derivings),(Seq Error),(RuleMap),(TypeSyns),(Map Nonterminal (Map Name (String,String))),(Set Nonterminal)))
-- cata
sem_Elem :: (Elem) ->
            (T_Elem)
sem_Elem ((Attr (_pos) (_names) (_attrs))) =
    (sem_Elem_Attr (_pos) ((sem_NontSet (_names))) ((sem_Attrs (_attrs))))
sem_Elem ((Data (_pos) (_name) (_attrs) (_alts) (_ext))) =
    (sem_Elem_Data (_pos) (_name) ((sem_Attrs (_attrs))) ((sem_Alts (_alts))) (_ext))
sem_Elem ((Deriving (_pos) (_set) (_classes))) =
    (sem_Elem_Deriving (_pos) ((sem_NontSet (_set))) (_classes))
sem_Elem ((Sem (_pos) (_name) (_attrs) (_alts))) =
    (sem_Elem_Sem (_pos) (_name) ((sem_Attrs (_attrs))) ((sem_SemAlts (_alts))))
sem_Elem ((Set (_pos) (_name) (_set))) =
    (sem_Elem_Set (_pos) (_name) ((sem_NontSet (_set))))
sem_Elem ((Txt (_pos) (_name) (_lines))) =
    (sem_Elem_Txt (_pos) (_name) (_lines))
sem_Elem ((Type (_pos) (_name) (_type))) =
    (sem_Elem_Type (_pos) (_name) (_type))
sem_Elem ((Wrapper (_pos) (_set))) =
    (sem_Elem_Wrapper (_pos) ((sem_NontSet (_set))))
data Inh_Elem = Inh_Elem {attrDecls_Inh_Elem :: Map Nonterminal (Attributes, Attributes),attributes_Inh_Elem :: Map Nonterminal (Attributes, Attributes),blocks_Inh_Elem :: Blocks,datas_Inh_Elem :: DataTypes,datatypes_Inh_Elem :: DataTypes,defSets_Inh_Elem :: Map Name (Set Nonterminal,Set Name),definedSets_Inh_Elem :: DefinedSets,nonterminals_Inh_Elem :: Set Nonterminal,ruleMap_Inh_Elem :: RuleMap,withSelf_Inh_Elem :: Bool}
data Syn_Elem = Syn_Elem {attrDecls_Syn_Elem :: Map Nonterminal (Attributes, Attributes)
                         ,blocks_Syn_Elem :: Blocks
                         ,datas_Syn_Elem :: DataTypes
                         ,defSets_Syn_Elem :: Map Name (Set Nonterminal,Set Name)
                         ,defined_nts_Syn_Elem :: Set Nonterminal
                         ,derivings_Syn_Elem :: Derivings
                         ,errors_Syn_Elem :: Seq Error
                         ,ruleMap_Syn_Elem :: RuleMap
                         ,typeSyns_Syn_Elem :: TypeSyns
                         ,useMap_Syn_Elem :: Map Nonterminal (Map Name (String,String))
                         ,wrappers_Syn_Elem :: Set Nonterminal
                         }
wrap_Elem :: (T_Elem) ->
             (Inh_Elem) ->
             (Syn_Elem)
wrap_Elem ((T_Elem (sem))) ((Inh_Elem (i1) (i2) (i3) (i4) (i5) (i6) (i7) (i8) (i9) (i10))) =
    let ( s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6) (i7) (i8) (i9) (i10))
    in  (Syn_Elem (s1) (s2) (s3) (s4) (s5) (s6) (s7) (s8) (s9) (s10) (s11))
sem_Elem_Attr :: (Pos) ->
                 (T_NontSet) ->
                 (T_Attrs) ->
                 (T_Elem)
sem_Elem_Attr (pos_) ((T_NontSet (names_))) ((T_Attrs (attrs_))) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _namesIerrors :: (Seq Error)
                     _namesInontSet :: (Set Nonterminal)
                     _namesIusedNames :: (Set Name)
                     _namesOdatatypes :: (DataTypes)
                     _namesOdefinedSets :: (DefinedSets)
                     _namesOnonterminals :: (Set Nonterminal)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOdatatypes :: (DataTypes)
                     _attrsOnonterminals :: (Set Nonterminal)
                     _attrsOnts :: (Set Nonterminal)
                     ( _namesIerrors,_namesInontSet,_namesIusedNames) =
                         (names_ (_namesOdatatypes) (_namesOdefinedSets) (_namesOnonterminals))
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOattrDecls) (_attrsOdatatypes) (_attrsOnonterminals) (_attrsOnts))
                     -- "Transform.ag"(line 326, column 10)
                     (_attrsOnts@_) =
                         _namesInontSet
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _namesIerrors Seq.<> _attrsIerrors
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                     -- copy rule (down)
                     (_namesOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_namesOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_namesOnonterminals@_) =
                         _lhsInonterminals
                     -- copy rule (down)
                     (_attrsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (down)
                     (_attrsOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_attrsOnonterminals@_) =
                         _lhsInonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Data :: (Pos) ->
                 (Nonterminal) ->
                 (T_Attrs) ->
                 (T_Alts) ->
                 (Bool) ->
                 (T_Elem)
sem_Elem_Data (pos_) (name_) ((T_Attrs (attrs_))) ((T_Alts (alts_))) (ext_) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOdatatypes :: (DataTypes)
                     _attrsOnonterminals :: (Set Nonterminal)
                     _attrsOnts :: (Set Nonterminal)
                     _altsIdataAlts :: ([(Constructor,FieldMap )])
                     _altsIerrors :: (Seq Error)
                     _altsOnonterminals :: (Set Nonterminal)
                     _altsOnt :: (Nonterminal)
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOattrDecls) (_attrsOdatatypes) (_attrsOnonterminals) (_attrsOnts))
                     ( _altsIdataAlts,_altsIerrors) =
                         (alts_ (_altsOnonterminals) (_altsOnt))
                     -- "Transform.ag"(line 43, column 10)
                     (_altsOnt@_) =
                         name_
                     -- "Transform.ag"(line 124, column 10)
                     (_lhsOdefined_nts@_) =
                         Set.single name_
                     -- "Transform.ag"(line 136, column 10)
                     (_lhsOerrors@_) =
                         _attrsIerrors <> _errs <> _altsIerrors
                     -- "Transform.ag"(line 135, column 10)
                     (_lhsOdatas@_) =
                         Map.insert name_ _alternatives2 _lhsIdatas
                     -- "Transform.ag"(line 133, column 10)
                     (_alternatives@_) =
                         Map.findWithDefault Map.empty name_ _lhsIdatas
                     -- "Transform.ag"(line 133, column 14)
                     ((_alternatives2@_,_errs@_)) =
                         checkDuplicates (DupAlt name_) _altsIdataAlts _alternatives
                     -- "Transform.ag"(line 325, column 10)
                     (_attrsOnts@_) =
                         Set.single name_
                     -- "Transform.ag"(line 426, column 10)
                     (_attrsOattrDecls@_) =
                         if _lhsIwithSelf then addSelf name_ _lhsIattrDecls else _lhsIattrDecls
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                     -- copy rule (down)
                     (_attrsOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_attrsOnonterminals@_) =
                         _lhsInonterminals
                     -- copy rule (down)
                     (_altsOnonterminals@_) =
                         _lhsInonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Deriving :: (Pos) ->
                     (T_NontSet) ->
                     ([Name]) ->
                     (T_Elem)
sem_Elem_Deriving (pos_) ((T_NontSet (set_))) (classes_) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setIusedNames :: (Set Name)
                     _setOdatatypes :: (DataTypes)
                     _setOdefinedSets :: (DefinedSets)
                     _setOnonterminals :: (Set Nonterminal)
                     ( _setIerrors,_setInontSet,_setIusedNames) =
                         (set_ (_setOdatatypes) (_setOdefinedSets) (_setOnonterminals))
                     -- "Transform.ag"(line 304, column 14)
                     (_lhsOderivings@_) =
                         Map.fromList [(nt,Set.fromList classes_) | nt <- Set.toList _setInontSet]
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _setIerrors
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                     -- copy rule (down)
                     (_setOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_setOnonterminals@_) =
                         _lhsInonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Sem :: (Pos) ->
                (Nonterminal) ->
                (T_Attrs) ->
                (T_SemAlts) ->
                (T_Elem)
sem_Elem_Sem (pos_) (name_) ((T_Attrs (attrs_))) ((T_SemAlts (alts_))) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOdatatypes :: (DataTypes)
                     _attrsOnonterminals :: (Set Nonterminal)
                     _attrsOnts :: (Set Nonterminal)
                     _altsIerrors :: (Seq Error)
                     _altsIruleMapAlt :: (RuleMapAlt)
                     _altsOalternatives :: (DataAlts)
                     _altsOattributes :: (Map Nonterminal (Attributes, Attributes))
                     _altsOnt :: (Nonterminal)
                     _altsOruleMapAlt :: (RuleMapAlt)
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOattrDecls) (_attrsOdatatypes) (_attrsOnonterminals) (_attrsOnts))
                     ( _altsIerrors,_altsIruleMapAlt) =
                         (alts_ (_altsOalternatives) (_altsOattributes) (_altsOnt) (_altsOruleMapAlt))
                     -- "Transform.ag"(line 44, column 10)
                     (_altsOnt@_) =
                         name_
                     -- "Transform.ag"(line 327, column 10)
                     (_attrsOnts@_) =
                         Set.single name_
                     -- "Transform.ag"(line 385, column 9)
                     (_lhsOruleMap@_) =
                         Map.insert name_ _altsIruleMapAlt _lhsIruleMap
                     -- "Transform.ag"(line 383, column 9)
                     (_lhsOerrors@_) =
                         let es = checkUndef UndefNont name_ _lhsIdatatypes _altsIerrors
                         in if null (Seq.toList es) then _attrsIerrors else es
                     -- "Transform.ag"(line 381, column 9)
                     (_altsOalternatives@_) =
                         Map.findWithDefault Map.empty name_ _lhsIdatatypes
                     -- "Transform.ag"(line 381, column 9)
                     (_altsOruleMapAlt@_) =
                         Map.findWithDefault Map.empty name_ _lhsIruleMap
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_attrsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (down)
                     (_attrsOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_attrsOnonterminals@_) =
                         _lhsInonterminals
                     -- copy rule (down)
                     (_altsOattributes@_) =
                         _lhsIattributes
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Set :: (Pos) ->
                (Name) ->
                (T_NontSet) ->
                (T_Elem)
sem_Elem_Set (pos_) (name_) ((T_NontSet (set_))) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setIusedNames :: (Set Name)
                     _setOdatatypes :: (DataTypes)
                     _setOdefinedSets :: (DefinedSets)
                     _setOnonterminals :: (Set Nonterminal)
                     ( _setIerrors,_setInontSet,_setIusedNames) =
                         (set_ (_setOdatatypes) (_setOdefinedSets) (_setOnonterminals))
                     -- "Transform.ag"(line 209, column 9)
                     (_lhsOerrors@_) =
                         _errs Seq.<> _setIerrors
                     -- "Transform.ag"(line 209, column 9)
                     (_lhsOdefSets@_) =
                         _defSets'
                     -- "Transform.ag"(line 199, column 13)
                     ((_defSets'@_,_errs@_)) =
                         let allUsedNames = Set.unions [ ns
                                                       | n <- Set.toList _setIusedNames
                                                       , let ns = maybe (Set.single n) snd
                                                                        (Map.lookup n _lhsIdefSets)
                                                       ]
                             (nontSet,e1) | Set.member name_ allUsedNames
                                                      = (Set.empty, Seq.single(CyclicSet name_))
                                          | otherwise = (_setInontSet, Seq.empty)
                             (res, e2) = checkDuplicate DupSet  name_ (nontSet,Set.insert name_ allUsedNames) _lhsIdefSets
                         in (res, e1 Seq.<> e2)
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                     -- copy rule (down)
                     (_setOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_setOnonterminals@_) =
                         _lhsInonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Txt :: (Pos) ->
                (Name) ->
                ([String]) ->
                (T_Elem)
sem_Elem_Txt (pos_) (name_) (lines_) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     -- "Transform.ag"(line 71, column 11)
                     (_lhsOblocks@_) =
                         Map.insertWith (++) name_ lines_ _lhsIblocks
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         Seq.empty
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Type :: (Pos) ->
                 (Nonterminal) ->
                 (ComplexType) ->
                 (T_Elem)
sem_Elem_Type (pos_) (name_) (type_) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     -- "Transform.ag"(line 125, column 10)
                     (_lhsOdefined_nts@_) =
                         Set.single name_
                     -- "Transform.ag"(line 181, column 11)
                     (_lhsOtypeSyns@_) =
                         if Map.member name_ _lhsIdatas
                            then []
                            else [(name_,_argType)]
                     -- "Transform.ag"(line 177, column 11)
                     (_argType@_) =
                         case type_ of
                          Maybe tp  -> Maybe (makeType _lhsInonterminals tp)
                          List tp  -> List (makeType _lhsInonterminals tp)
                          Tuple xs -> Tuple [(f,makeType _lhsInonterminals tp) | (f,tp) <- xs]
                     -- "Transform.ag"(line 162, column 15)
                     ((_datas@_,_errors@_)) =
                         let expanded
                              = case _argType of
                                 List tp -> [(Ident "Cons" pos_, [(Ident "hd" pos_, tp)
                                                                 ,(Ident "tl" pos_, NT name_)
                                                                 ]
                                             )
                                            ,(Ident "Nil" pos_,  [])
                                            ]
                                 Maybe tp -> [(Ident "Just" pos_, [(Ident "just" pos_, tp)
                                                                 ]
                                             )
                                            ,(Ident "Nothing" pos_,  [])
                                            ]
                                 Tuple xs -> [(Ident "Tuple" pos_, xs)]
                         in checkDuplicate DupSynonym name_ (Map.fromList expanded) _lhsIdatas
                     -- "Transform.ag"(line 427, column 10)
                     (_lhsOattrDecls@_) =
                         if _lhsIwithSelf then addSelf name_ _lhsIattrDecls else _lhsIattrDecls
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _errors
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (from local)
                     (_lhsOdatas@_) =
                         _datas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Wrapper :: (Pos) ->
                    (T_NontSet) ->
                    (T_Elem)
sem_Elem_Wrapper (pos_) ((T_NontSet (set_))) =
    (T_Elem (\ _lhsIattrDecls
               _lhsIattributes
               _lhsIblocks
               _lhsIdatas
               _lhsIdatatypes
               _lhsIdefSets
               _lhsIdefinedSets
               _lhsInonterminals
               _lhsIruleMap
               _lhsIwithSelf ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOdatas :: (DataTypes)
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOdefined_nts :: (Set Nonterminal)
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOruleMap :: (RuleMap)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setIusedNames :: (Set Name)
                     _setOdatatypes :: (DataTypes)
                     _setOdefinedSets :: (DefinedSets)
                     _setOnonterminals :: (Set Nonterminal)
                     ( _setIerrors,_setInontSet,_setIusedNames) =
                         (set_ (_setOdatatypes) (_setOdefinedSets) (_setOnonterminals))
                     -- "Transform.ag"(line 291, column 13)
                     (_lhsOwrappers@_) =
                         _setInontSet
                     -- use rule
                     (_lhsOdefined_nts@_) =
                         Set.empty
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _setIerrors
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOblocks@_) =
                         _lhsIblocks
                     -- copy rule (chain)
                     (_lhsOdatas@_) =
                         _lhsIdatas
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (chain)
                     (_lhsOruleMap@_) =
                         _lhsIruleMap
                     -- copy rule (down)
                     (_setOdatatypes@_) =
                         _lhsIdatatypes
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_setOnonterminals@_) =
                         _lhsInonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
-- Elems -------------------------------------------------------
{-
   inherited attributes:
      attributes           : Map Nonterminal (Attributes, Attributes)
      datatypes            : DataTypes
      definedSets          : DefinedSets
      nonterminals         : Set Nonterminal
      withSelf             : Bool

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)
      datas                : DataTypes
      defSets              : Map Name (Set Nonterminal,Set Name)
      ruleMap              : RuleMap

   synthesised attributes:
      blocks               : Blocks
      defined_nts          : Set Nonterminal
      derivings            : Derivings
      errors               : Seq Error
      typeSyns             : TypeSyns
      useMap               : Map Nonterminal (Map Name (String,String))
      wrappers             : Set Nonterminal

-}
{-
   local variables for Elems.Cons:

-}
{-
   local variables for Elems.Nil:

-}
-- semantic domain
newtype T_Elems = T_Elems ((Map Nonterminal (Attributes, Attributes)) ->
                           (Map Nonterminal (Attributes, Attributes)) ->
                           (DataTypes) ->
                           (DataTypes) ->
                           (Map Name (Set Nonterminal,Set Name)) ->
                           (DefinedSets) ->
                           (Set Nonterminal) ->
                           (RuleMap) ->
                           (Bool) ->
                           ( (Map Nonterminal (Attributes, Attributes)),(Blocks),(DataTypes),(Map Name (Set Nonterminal,Set Name)),(Set Nonterminal),(Derivings),(Seq Error),(RuleMap),(TypeSyns),(Map Nonterminal (Map Name (String,String))),(Set Nonterminal)))
-- cata
sem_Elems :: (Elems) ->
             (T_Elems)
sem_Elems (list) =
    (Prelude.foldr (sem_Elems_Cons) (sem_Elems_Nil) ((Prelude.map sem_Elem list)))
data Inh_Elems = Inh_Elems {attrDecls_Inh_Elems :: Map Nonterminal (Attributes, Attributes),attributes_Inh_Elems :: Map Nonterminal (Attributes, Attributes),datas_Inh_Elems :: DataTypes,datatypes_Inh_Elems :: DataTypes,defSets_Inh_Elems :: Map Name (Set Nonterminal,Set Name),definedSets_Inh_Elems :: DefinedSets,nonterminals_Inh_Elems :: Set Nonterminal,ruleMap_Inh_Elems :: RuleMap,withSelf_Inh_Elems :: Bool}
data Syn_Elems = Syn_Elems {attrDecls_Syn_Elems :: Map Nonterminal (Attributes, Attributes)
                           ,blocks_Syn_Elems :: Blocks
                           ,datas_Syn_Elems :: DataTypes
                           ,defSets_Syn_Elems :: Map Name (Set Nonterminal,Set Name)
                           ,defined_nts_Syn_Elems :: Set Nonterminal
                           ,derivings_Syn_Elems :: Derivings
                           ,errors_Syn_Elems :: Seq Error
                           ,ruleMap_Syn_Elems :: RuleMap
                           ,typeSyns_Syn_Elems :: TypeSyns
                           ,useMap_Syn_Elems :: Map Nonterminal (Map Name (String,String))
                           ,wrappers_Syn_Elems :: Set Nonterminal
                           }
wrap_Elems :: (T_Elems) ->
              (Inh_Elems) ->
              (Syn_Elems)
wrap_Elems ((T_Elems (sem))) ((Inh_Elems (i1) (i2) (i3) (i4) (i5) (i6) (i7) (i8) (i9))) =
    let ( s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6) (i7) (i8) (i9))
    in  (Syn_Elems (s1) (s2) (s3) (s4) (s5) (s6) (s7) (s8) (s9) (s10) (s11))
sem_Elems_Cons :: (T_Elem) ->
                  (T_Elems) ->
                  (T_Elems)
sem_Elems_Cons ((T_Elem (hd_))) ((T_Elems (tl_))) =
    (T_Elems (\ _lhsIattrDecls
                _lhsIattributes
                _lhsIdatas
                _lhsIdatatypes
                _lhsIdefSets
                _lhsIdefinedSets
                _lhsInonterminals
                _lhsIruleMap
                _lhsIwithSelf ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOblocks :: (Blocks)
                      _lhsOdatas :: (DataTypes)
                      _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _lhsOdefined_nts :: (Set Nonterminal)
                      _lhsOderivings :: (Derivings)
                      _lhsOerrors :: (Seq Error)
                      _lhsOruleMap :: (RuleMap)
                      _lhsOtypeSyns :: (TypeSyns)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                      _lhsOwrappers :: (Set Nonterminal)
                      _hdIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _hdIblocks :: (Blocks)
                      _hdIdatas :: (DataTypes)
                      _hdIdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _hdIdefined_nts :: (Set Nonterminal)
                      _hdIderivings :: (Derivings)
                      _hdIerrors :: (Seq Error)
                      _hdIruleMap :: (RuleMap)
                      _hdItypeSyns :: (TypeSyns)
                      _hdIuseMap :: (Map Nonterminal (Map Name (String,String)))
                      _hdIwrappers :: (Set Nonterminal)
                      _hdOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _hdOattributes :: (Map Nonterminal (Attributes, Attributes))
                      _hdOblocks :: (Blocks)
                      _hdOdatas :: (DataTypes)
                      _hdOdatatypes :: (DataTypes)
                      _hdOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _hdOdefinedSets :: (DefinedSets)
                      _hdOnonterminals :: (Set Nonterminal)
                      _hdOruleMap :: (RuleMap)
                      _hdOwithSelf :: (Bool)
                      _tlIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _tlIblocks :: (Blocks)
                      _tlIdatas :: (DataTypes)
                      _tlIdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _tlIdefined_nts :: (Set Nonterminal)
                      _tlIderivings :: (Derivings)
                      _tlIerrors :: (Seq Error)
                      _tlIruleMap :: (RuleMap)
                      _tlItypeSyns :: (TypeSyns)
                      _tlIuseMap :: (Map Nonterminal (Map Name (String,String)))
                      _tlIwrappers :: (Set Nonterminal)
                      _tlOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _tlOattributes :: (Map Nonterminal (Attributes, Attributes))
                      _tlOdatas :: (DataTypes)
                      _tlOdatatypes :: (DataTypes)
                      _tlOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _tlOdefinedSets :: (DefinedSets)
                      _tlOnonterminals :: (Set Nonterminal)
                      _tlOruleMap :: (RuleMap)
                      _tlOwithSelf :: (Bool)
                      ( _hdIattrDecls,_hdIblocks,_hdIdatas,_hdIdefSets,_hdIdefined_nts,_hdIderivings,_hdIerrors,_hdIruleMap,_hdItypeSyns,_hdIuseMap,_hdIwrappers) =
                          (hd_ (_hdOattrDecls) (_hdOattributes) (_hdOblocks) (_hdOdatas) (_hdOdatatypes) (_hdOdefSets) (_hdOdefinedSets) (_hdOnonterminals) (_hdOruleMap) (_hdOwithSelf))
                      ( _tlIattrDecls,_tlIblocks,_tlIdatas,_tlIdefSets,_tlIdefined_nts,_tlIderivings,_tlIerrors,_tlIruleMap,_tlItypeSyns,_tlIuseMap,_tlIwrappers) =
                          (tl_ (_tlOattrDecls) (_tlOattributes) (_tlOdatas) (_tlOdatatypes) (_tlOdefSets) (_tlOdefinedSets) (_tlOnonterminals) (_tlOruleMap) (_tlOwithSelf))
                      -- "Transform.ag"(line 65, column 10)
                      (_lhsOblocks@_) =
                          _hdIblocks
                      -- "Transform.ag"(line 64, column 10)
                      (_hdOblocks@_) =
                          _tlIblocks
                      -- "Transform.ag"(line 373, column 10)
                      (_tlOruleMap@_) =
                          _lhsIruleMap
                      -- "Transform.ag"(line 372, column 10)
                      (_hdOruleMap@_) =
                          _tlIruleMap
                      -- "Transform.ag"(line 371, column 10)
                      (_lhsOruleMap@_) =
                          _hdIruleMap
                      -- use rule
                      (_lhsOdefined_nts@_) =
                          _hdIdefined_nts `Set.union` _tlIdefined_nts
                      -- use rule
                      (_lhsOderivings@_) =
                          _hdIderivings `mergeDerivings` _tlIderivings
                      -- use rule
                      (_lhsOerrors@_) =
                          _hdIerrors Seq.<> _tlIerrors
                      -- use rule
                      (_lhsOtypeSyns@_) =
                          _hdItypeSyns ++ _tlItypeSyns
                      -- use rule
                      (_lhsOuseMap@_) =
                          _hdIuseMap `merge` _tlIuseMap
                      -- use rule
                      (_lhsOwrappers@_) =
                          _hdIwrappers `Set.union` _tlIwrappers
                      -- copy rule (up)
                      (_lhsOattrDecls@_) =
                          _tlIattrDecls
                      -- copy rule (up)
                      (_lhsOdatas@_) =
                          _tlIdatas
                      -- copy rule (up)
                      (_lhsOdefSets@_) =
                          _tlIdefSets
                      -- copy rule (down)
                      (_hdOattrDecls@_) =
                          _lhsIattrDecls
                      -- copy rule (down)
                      (_hdOattributes@_) =
                          _lhsIattributes
                      -- copy rule (down)
                      (_hdOdatas@_) =
                          _lhsIdatas
                      -- copy rule (down)
                      (_hdOdatatypes@_) =
                          _lhsIdatatypes
                      -- copy rule (down)
                      (_hdOdefSets@_) =
                          _lhsIdefSets
                      -- copy rule (down)
                      (_hdOdefinedSets@_) =
                          _lhsIdefinedSets
                      -- copy rule (down)
                      (_hdOnonterminals@_) =
                          _lhsInonterminals
                      -- copy rule (down)
                      (_hdOwithSelf@_) =
                          _lhsIwithSelf
                      -- copy rule (chain)
                      (_tlOattrDecls@_) =
                          _hdIattrDecls
                      -- copy rule (down)
                      (_tlOattributes@_) =
                          _lhsIattributes
                      -- copy rule (chain)
                      (_tlOdatas@_) =
                          _hdIdatas
                      -- copy rule (down)
                      (_tlOdatatypes@_) =
                          _lhsIdatatypes
                      -- copy rule (chain)
                      (_tlOdefSets@_) =
                          _hdIdefSets
                      -- copy rule (down)
                      (_tlOdefinedSets@_) =
                          _lhsIdefinedSets
                      -- copy rule (down)
                      (_tlOnonterminals@_) =
                          _lhsInonterminals
                      -- copy rule (down)
                      (_tlOwithSelf@_) =
                          _lhsIwithSelf
                  in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elems_Nil :: (T_Elems)
sem_Elems_Nil  =
    (T_Elems (\ _lhsIattrDecls
                _lhsIattributes
                _lhsIdatas
                _lhsIdatatypes
                _lhsIdefSets
                _lhsIdefinedSets
                _lhsInonterminals
                _lhsIruleMap
                _lhsIwithSelf ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOblocks :: (Blocks)
                      _lhsOdatas :: (DataTypes)
                      _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _lhsOdefined_nts :: (Set Nonterminal)
                      _lhsOderivings :: (Derivings)
                      _lhsOerrors :: (Seq Error)
                      _lhsOruleMap :: (RuleMap)
                      _lhsOtypeSyns :: (TypeSyns)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String)))
                      _lhsOwrappers :: (Set Nonterminal)
                      -- "Transform.ag"(line 66, column 10)
                      (_lhsOblocks@_) =
                          Map.empty
                      -- use rule
                      (_lhsOdefined_nts@_) =
                          Set.empty
                      -- use rule
                      (_lhsOderivings@_) =
                          Map.empty
                      -- use rule
                      (_lhsOerrors@_) =
                          Seq.empty
                      -- use rule
                      (_lhsOtypeSyns@_) =
                          []
                      -- use rule
                      (_lhsOuseMap@_) =
                          Map.empty
                      -- use rule
                      (_lhsOwrappers@_) =
                          Set.empty
                      -- copy rule (chain)
                      (_lhsOattrDecls@_) =
                          _lhsIattrDecls
                      -- copy rule (chain)
                      (_lhsOdatas@_) =
                          _lhsIdatas
                      -- copy rule (chain)
                      (_lhsOdefSets@_) =
                          _lhsIdefSets
                      -- copy rule (chain)
                      (_lhsOruleMap@_) =
                          _lhsIruleMap
                  in  ( _lhsOattrDecls,_lhsOblocks,_lhsOdatas,_lhsOdefSets,_lhsOdefined_nts,_lhsOderivings,_lhsOerrors,_lhsOruleMap,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
-- NontSet -----------------------------------------------------
{-
   inherited attributes:
      datatypes            : DataTypes
      definedSets          : DefinedSets
      nonterminals         : Set Nonterminal

   chained attributes:

   synthesised attributes:
      errors               : Seq Error
      nontSet              : Set Nonterminal
      usedNames            : Set Name

-}
{-
   local variables for NontSet.All:

-}
{-
   local variables for NontSet.Difference:

-}
{-
   local variables for NontSet.Intersect:

-}
{-
   local variables for NontSet.NamedSet:
      nontSet
      errors

-}
{-
   local variables for NontSet.Path:

-}
{-
   local variables for NontSet.Union:

-}
-- semantic domain
newtype T_NontSet = T_NontSet ((DataTypes) ->
                               (DefinedSets) ->
                               (Set Nonterminal) ->
                               ( (Seq Error),(Set Nonterminal),(Set Name)))
-- cata
sem_NontSet :: (NontSet) ->
               (T_NontSet)
sem_NontSet ((All )) =
    (sem_NontSet_All )
sem_NontSet ((Difference (_set1) (_set2))) =
    (sem_NontSet_Difference ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
sem_NontSet ((Intersect (_set1) (_set2))) =
    (sem_NontSet_Intersect ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
sem_NontSet ((NamedSet (_name))) =
    (sem_NontSet_NamedSet (_name))
sem_NontSet ((Path (_from) (_to))) =
    (sem_NontSet_Path (_from) (_to))
sem_NontSet ((Union (_set1) (_set2))) =
    (sem_NontSet_Union ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
data Inh_NontSet = Inh_NontSet {datatypes_Inh_NontSet :: DataTypes,definedSets_Inh_NontSet :: DefinedSets,nonterminals_Inh_NontSet :: Set Nonterminal}
data Syn_NontSet = Syn_NontSet {errors_Syn_NontSet :: Seq Error,nontSet_Syn_NontSet :: Set Nonterminal,usedNames_Syn_NontSet :: Set Name}
wrap_NontSet :: (T_NontSet) ->
                (Inh_NontSet) ->
                (Syn_NontSet)
wrap_NontSet ((T_NontSet (sem))) ((Inh_NontSet (i1) (i2) (i3))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2) (i3))
    in  (Syn_NontSet (s1) (s2) (s3))
sem_NontSet_All :: (T_NontSet)
sem_NontSet_All  =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        -- "Transform.ag"(line 223, column 16)
                        (_lhsOnontSet@_) =
                            _lhsInonterminals
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                        -- use rule
                        (_lhsOusedNames@_) =
                            Set.empty
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
sem_NontSet_Difference :: (T_NontSet) ->
                          (T_NontSet) ->
                          (T_NontSet)
sem_NontSet_Difference ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1IusedNames :: (Set Name)
                        _set1Odatatypes :: (DataTypes)
                        _set1OdefinedSets :: (DefinedSets)
                        _set1Ononterminals :: (Set Nonterminal)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2IusedNames :: (Set Name)
                        _set2Odatatypes :: (DataTypes)
                        _set2OdefinedSets :: (DefinedSets)
                        _set2Ononterminals :: (Set Nonterminal)
                        ( _set1Ierrors,_set1InontSet,_set1IusedNames) =
                            (set1_ (_set1Odatatypes) (_set1OdefinedSets) (_set1Ononterminals))
                        ( _set2Ierrors,_set2InontSet,_set2IusedNames) =
                            (set2_ (_set2Odatatypes) (_set2OdefinedSets) (_set2Ononterminals))
                        -- "Transform.ag"(line 230, column 16)
                        (_lhsOnontSet@_) =
                            Set.difference    _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- use rule
                        (_lhsOusedNames@_) =
                            _set1IusedNames `Set.union` _set2IusedNames
                        -- copy rule (down)
                        (_set1Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set1Ononterminals@_) =
                            _lhsInonterminals
                        -- copy rule (down)
                        (_set2Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2Ononterminals@_) =
                            _lhsInonterminals
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
sem_NontSet_Intersect :: (T_NontSet) ->
                         (T_NontSet) ->
                         (T_NontSet)
sem_NontSet_Intersect ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1IusedNames :: (Set Name)
                        _set1Odatatypes :: (DataTypes)
                        _set1OdefinedSets :: (DefinedSets)
                        _set1Ononterminals :: (Set Nonterminal)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2IusedNames :: (Set Name)
                        _set2Odatatypes :: (DataTypes)
                        _set2OdefinedSets :: (DefinedSets)
                        _set2Ononterminals :: (Set Nonterminal)
                        ( _set1Ierrors,_set1InontSet,_set1IusedNames) =
                            (set1_ (_set1Odatatypes) (_set1OdefinedSets) (_set1Ononterminals))
                        ( _set2Ierrors,_set2InontSet,_set2IusedNames) =
                            (set2_ (_set2Odatatypes) (_set2OdefinedSets) (_set2Ononterminals))
                        -- "Transform.ag"(line 229, column 16)
                        (_lhsOnontSet@_) =
                            Set.intersection  _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- use rule
                        (_lhsOusedNames@_) =
                            _set1IusedNames `Set.union` _set2IusedNames
                        -- copy rule (down)
                        (_set1Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set1Ononterminals@_) =
                            _lhsInonterminals
                        -- copy rule (down)
                        (_set2Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2Ononterminals@_) =
                            _lhsInonterminals
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
sem_NontSet_NamedSet :: (Nonterminal) ->
                        (T_NontSet)
sem_NontSet_NamedSet (name_) =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        -- "Transform.ag"(line 220, column 16)
                        (_lhsOusedNames@_) =
                            Set.single name_
                        -- "Transform.ag"(line 224, column 20)
                        ((_nontSet@_,_errors@_)) =
                            case Map.lookup name_ _lhsIdefinedSets of
                                  Nothing  -> (Set.empty, Seq.single (UndefNont name_))
                                  Just set -> (set, Seq.empty)
                        -- use rule
                        (_lhsOerrors@_) =
                            _errors
                        -- copy rule (from local)
                        (_lhsOnontSet@_) =
                            _nontSet
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
sem_NontSet_Path :: (Nonterminal) ->
                    (Nonterminal) ->
                    (T_NontSet)
sem_NontSet_Path (from_) (to_) =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        -- "Transform.ag"(line 235, column 16)
                        (_lhsOerrors@_) =
                            let check name | Set.member name _lhsInonterminals
                                                       = Seq.empty
                                           | otherwise = Seq.single (UndefNont name)
                            in check from_ <> check to_
                        -- "Transform.ag"(line 231, column 16)
                        (_lhsOnontSet@_) =
                            let table = flattenDatas _lhsIdatatypes
                            in path table from_ to_
                        -- use rule
                        (_lhsOusedNames@_) =
                            Set.empty
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
sem_NontSet_Union :: (T_NontSet) ->
                     (T_NontSet) ->
                     (T_NontSet)
sem_NontSet_Union ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIdatatypes
                  _lhsIdefinedSets
                  _lhsInonterminals ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _lhsOusedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1IusedNames :: (Set Name)
                        _set1Odatatypes :: (DataTypes)
                        _set1OdefinedSets :: (DefinedSets)
                        _set1Ononterminals :: (Set Nonterminal)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2IusedNames :: (Set Name)
                        _set2Odatatypes :: (DataTypes)
                        _set2OdefinedSets :: (DefinedSets)
                        _set2Ononterminals :: (Set Nonterminal)
                        ( _set1Ierrors,_set1InontSet,_set1IusedNames) =
                            (set1_ (_set1Odatatypes) (_set1OdefinedSets) (_set1Ononterminals))
                        ( _set2Ierrors,_set2InontSet,_set2IusedNames) =
                            (set2_ (_set2Odatatypes) (_set2OdefinedSets) (_set2Ononterminals))
                        -- "Transform.ag"(line 228, column 16)
                        (_lhsOnontSet@_) =
                            Set.union         _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- use rule
                        (_lhsOusedNames@_) =
                            _set1IusedNames `Set.union` _set2IusedNames
                        -- copy rule (down)
                        (_set1Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set1Ononterminals@_) =
                            _lhsInonterminals
                        -- copy rule (down)
                        (_set2Odatatypes@_) =
                            _lhsIdatatypes
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2Ononterminals@_) =
                            _lhsInonterminals
                    in  ( _lhsOerrors,_lhsOnontSet,_lhsOusedNames)))
-- SemAlt ------------------------------------------------------
{-
   inherited attributes:
      alternatives         : DataAlts
      attributes           : Map Nonterminal (Attributes, Attributes)
      nt                   : Nonterminal

   chained attributes:
      ruleMapAlt           : RuleMapAlt

   synthesised attributes:
      errors               : Seq Error

-}
{-
   local variables for SemAlt.SemAlt:
      errors
      ruless
      constructors

-}
-- semantic domain
newtype T_SemAlt = T_SemAlt ((DataAlts) ->
                             (Map Nonterminal (Attributes, Attributes)) ->
                             (Nonterminal) ->
                             (RuleMapAlt) ->
                             ( (Seq Error),(RuleMapAlt)))
-- cata
sem_SemAlt :: (SemAlt) ->
              (T_SemAlt)
sem_SemAlt ((SemAlt (_pos) (_constructorSet) (_rules))) =
    (sem_SemAlt_SemAlt (_pos) ((sem_ConstructorSet (_constructorSet))) (_rules))
data Inh_SemAlt = Inh_SemAlt {alternatives_Inh_SemAlt :: DataAlts,attributes_Inh_SemAlt :: Map Nonterminal (Attributes, Attributes),nt_Inh_SemAlt :: Nonterminal,ruleMapAlt_Inh_SemAlt :: RuleMapAlt}
data Syn_SemAlt = Syn_SemAlt {errors_Syn_SemAlt :: Seq Error,ruleMapAlt_Syn_SemAlt :: RuleMapAlt}
wrap_SemAlt :: (T_SemAlt) ->
               (Inh_SemAlt) ->
               (Syn_SemAlt)
wrap_SemAlt ((T_SemAlt (sem))) ((Inh_SemAlt (i1) (i2) (i3) (i4))) =
    let ( s1,s2) =
            (sem (i1) (i2) (i3) (i4))
    in  (Syn_SemAlt (s1) (s2))
sem_SemAlt_SemAlt :: (Pos) ->
                     (T_ConstructorSet) ->
                     (SemDefs) ->
                     (T_SemAlt)
sem_SemAlt_SemAlt (pos_) ((T_ConstructorSet (constructorSet_))) (rules_) =
    (T_SemAlt (\ _lhsIalternatives
                 _lhsIattributes
                 _lhsInt
                 _lhsIruleMapAlt ->
                   let _lhsOerrors :: (Seq Error)
                       _lhsOruleMapAlt :: (RuleMapAlt)
                       _constructorSetIconstructors :: (Set.Set Constructor)
                       _constructorSetIerrors :: (Seq Error)
                       _constructorSetOdefinedConstructors :: (Set.Set Constructor)
                       _constructorSetOnt :: (Nonterminal)
                       ( _constructorSetIconstructors,_constructorSetIerrors) =
                           (constructorSet_ (_constructorSetOdefinedConstructors) (_constructorSetOnt))
                       -- "Transform.ag"(line 398, column 16)
                       ((_errors@_,_ruless@_)) =
                           unzip (map rules (Set.toList _constructorSetIconstructors))
                            where rules con = let rules    = Map.findWithDefault ([],Map.empty) con _lhsIruleMapAlt
                                                  fieldMap = Map.findWithDefault []             con _lhsIalternatives
                                                  inherited = SemRules.Inh_SemDefs
                                                              { SemRules.attributes_Inh_SemDefs = _lhsIattributes
                                                              , SemRules.con_Inh_SemDefs        = con
                                                              , SemRules.fieldMap_Inh_SemDefs   = fieldMap
                                                              , SemRules.nt_Inh_SemDefs         = _lhsInt
                                                              , SemRules.rules_Inh_SemDefs      = rules
                                                              }
                                                  result = semDefs inherited
                                              in ( SemRules.errors_Syn_SemDefs result
                                                   Seq.<> checkUndef (UndefAlt _lhsInt) con _lhsIalternatives Seq.empty
                                                 , (con,SemRules.rules_Syn_SemDefs result)
                                                 )
                                  semDefs = SemRules.wrap_SemDefs (SemRules.sem_SemDefs rules_)
                       -- "Transform.ag"(line 396, column 12)
                       (_constructors@_) =
                           Set.fromList (Map.keys _lhsIalternatives )
                       -- "Transform.ag"(line 395, column 12)
                       (_constructorSetOdefinedConstructors@_) =
                           _constructors
                       -- "Transform.ag"(line 393, column 12)
                       (_lhsOerrors@_) =
                           _constructorSetIerrors <> foldr (Seq.<>) Seq.empty _errors
                       -- "Transform.ag"(line 393, column 12)
                       (_lhsOruleMapAlt@_) =
                           foldr (\(con,rules) rsMap ->Map.insert con rules rsMap) _lhsIruleMapAlt _ruless
                       -- copy rule (down)
                       (_constructorSetOnt@_) =
                           _lhsInt
                   in  ( _lhsOerrors,_lhsOruleMapAlt)))
-- SemAlts -----------------------------------------------------
{-
   inherited attributes:
      alternatives         : DataAlts
      attributes           : Map Nonterminal (Attributes, Attributes)
      nt                   : Nonterminal

   chained attributes:
      ruleMapAlt           : RuleMapAlt

   synthesised attributes:
      errors               : Seq Error

-}
{-
   local variables for SemAlts.Cons:

-}
{-
   local variables for SemAlts.Nil:

-}
-- semantic domain
newtype T_SemAlts = T_SemAlts ((DataAlts) ->
                               (Map Nonterminal (Attributes, Attributes)) ->
                               (Nonterminal) ->
                               (RuleMapAlt) ->
                               ( (Seq Error),(RuleMapAlt)))
-- cata
sem_SemAlts :: (SemAlts) ->
               (T_SemAlts)
sem_SemAlts (list) =
    (Prelude.foldr (sem_SemAlts_Cons) (sem_SemAlts_Nil) ((Prelude.map sem_SemAlt list)))
data Inh_SemAlts = Inh_SemAlts {alternatives_Inh_SemAlts :: DataAlts,attributes_Inh_SemAlts :: Map Nonterminal (Attributes, Attributes),nt_Inh_SemAlts :: Nonterminal,ruleMapAlt_Inh_SemAlts :: RuleMapAlt}
data Syn_SemAlts = Syn_SemAlts {errors_Syn_SemAlts :: Seq Error,ruleMapAlt_Syn_SemAlts :: RuleMapAlt}
wrap_SemAlts :: (T_SemAlts) ->
                (Inh_SemAlts) ->
                (Syn_SemAlts)
wrap_SemAlts ((T_SemAlts (sem))) ((Inh_SemAlts (i1) (i2) (i3) (i4))) =
    let ( s1,s2) =
            (sem (i1) (i2) (i3) (i4))
    in  (Syn_SemAlts (s1) (s2))
sem_SemAlts_Cons :: (T_SemAlt) ->
                    (T_SemAlts) ->
                    (T_SemAlts)
sem_SemAlts_Cons ((T_SemAlt (hd_))) ((T_SemAlts (tl_))) =
    (T_SemAlts (\ _lhsIalternatives
                  _lhsIattributes
                  _lhsInt
                  _lhsIruleMapAlt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOruleMapAlt :: (RuleMapAlt)
                        _hdIerrors :: (Seq Error)
                        _hdIruleMapAlt :: (RuleMapAlt)
                        _hdOalternatives :: (DataAlts)
                        _hdOattributes :: (Map Nonterminal (Attributes, Attributes))
                        _hdOnt :: (Nonterminal)
                        _hdOruleMapAlt :: (RuleMapAlt)
                        _tlIerrors :: (Seq Error)
                        _tlIruleMapAlt :: (RuleMapAlt)
                        _tlOalternatives :: (DataAlts)
                        _tlOattributes :: (Map Nonterminal (Attributes, Attributes))
                        _tlOnt :: (Nonterminal)
                        _tlOruleMapAlt :: (RuleMapAlt)
                        ( _hdIerrors,_hdIruleMapAlt) =
                            (hd_ (_hdOalternatives) (_hdOattributes) (_hdOnt) (_hdOruleMapAlt))
                        ( _tlIerrors,_tlIruleMapAlt) =
                            (tl_ (_tlOalternatives) (_tlOattributes) (_tlOnt) (_tlOruleMapAlt))
                        -- "Transform.ag"(line 390, column 10)
                        (_tlOruleMapAlt@_) =
                            _lhsIruleMapAlt
                        -- "Transform.ag"(line 389, column 10)
                        (_hdOruleMapAlt@_) =
                            _tlIruleMapAlt
                        -- "Transform.ag"(line 388, column 10)
                        (_lhsOruleMapAlt@_) =
                            _hdIruleMapAlt
                        -- use rule
                        (_lhsOerrors@_) =
                            _hdIerrors Seq.<> _tlIerrors
                        -- copy rule (down)
                        (_hdOalternatives@_) =
                            _lhsIalternatives
                        -- copy rule (down)
                        (_hdOattributes@_) =
                            _lhsIattributes
                        -- copy rule (down)
                        (_hdOnt@_) =
                            _lhsInt
                        -- copy rule (down)
                        (_tlOalternatives@_) =
                            _lhsIalternatives
                        -- copy rule (down)
                        (_tlOattributes@_) =
                            _lhsIattributes
                        -- copy rule (down)
                        (_tlOnt@_) =
                            _lhsInt
                    in  ( _lhsOerrors,_lhsOruleMapAlt)))
sem_SemAlts_Nil :: (T_SemAlts)
sem_SemAlts_Nil  =
    (T_SemAlts (\ _lhsIalternatives
                  _lhsIattributes
                  _lhsInt
                  _lhsIruleMapAlt ->
                    let _lhsOerrors :: (Seq Error)
                        _lhsOruleMapAlt :: (RuleMapAlt)
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                        -- copy rule (chain)
                        (_lhsOruleMapAlt@_) =
                            _lhsIruleMapAlt
                    in  ( _lhsOerrors,_lhsOruleMapAlt)))


