/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "objectList.h"

#include <stdlib.h>

#include <visu_tools.h>

/* Variables to store the glObjectList. */
/* The default size of the table to store the user
   lists. */
#define GLOBJECTLIST_INCREMENT 15
/* First value given to user to store their glObjectList. */
#define GLOBJECTLIST_FIRST 1001
/* The table that stores the identifier of user's glObjectList. */
int *glObjectListRegistered;
/* The allocated size of this table. */
int glObjectListRegisteredSize;
/* The number of stored elements. */
int nbGlObjectListRegistered;
/* The number of user's reserved numbers of the last
   entry in this table. */
int lastGlObjectListSize;

void openGLObjectList_init()
{
  /* Initialisation of the table that stores the user
     glObjectList. */
  glObjectListRegistered = (int*)0;
  glObjectListRegisteredSize = 0;
  nbGlObjectListRegistered = 0;
  lastGlObjectListSize = 0;
}


/* It returns the number that can be used to link glObjectList.
   This number is also added to the list of glObjectList to be displayed.
   The size parameter is the number of lists that could be used by
   the user for this glObjectList. Then the next call to this function
   will return the last value plus the size plus one. */
int openGLObjectList_new(int size)
{
  if (nbGlObjectListRegistered >= glObjectListRegisteredSize)
    {
      glObjectListRegisteredSize += GLOBJECTLIST_INCREMENT;
      glObjectListRegistered = g_realloc(glObjectListRegistered,
					 sizeof(int) * glObjectListRegisteredSize);
    }
  if (nbGlObjectListRegistered > 0)
    glObjectListRegistered[nbGlObjectListRegistered] = 
      glObjectListRegistered[nbGlObjectListRegistered - 1] + lastGlObjectListSize;
  else
    glObjectListRegistered[0] = GLOBJECTLIST_FIRST;
  lastGlObjectListSize = size;
  nbGlObjectListRegistered++;
  DBG_fprintf(stderr, "Object List: request %d OpenGL lists -> %d %d.\n",
	      size, glObjectListRegistered[nbGlObjectListRegistered - 1],
	      glObjectListRegistered[nbGlObjectListRegistered - 1] + size - 1);
  return glObjectListRegistered[nbGlObjectListRegistered - 1];
}

