/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "panelDataFile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include <gtk_main.h>
#include <visu_object.h>
#include <visu_tools.h>
#include <visu_gtk.h>
#include <visu_configFile.h>
#include <support.h>
#include <coreTools/toolShade.h>
#include <coreTools/toolConfigFile.h>
#include <extraFunctions/dataFile.h>
#include <extraGtkFunctions/gtk_numericalEntryWidget.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <extraGtkFunctions/gtk_shadeComboBoxWidget.h>

/* Local variables. */
static GtkWidget *panelDataFile;
static int nbColumns;
static gboolean panelDataFileIsInitiated;
static gboolean flagDataFileIsLoaded;
static gboolean flagDisableCallbacks;
static gchar *fileExt;
static gchar *currentDataFile;

#define RED_DATA_LABEL   _("R")
#define GREEN_DATA_LABEL _("G")
#define BLUE_DATA_LABEL  _("B")
#define HUE_DATA_LABEL   _("H")
#define SAT_DATA_LABEL   _("S")
#define VAL_DATA_LABEL   _("V")

char* labelRGB[3];
char* labelHSV[3];

#define COLOR_PREVIEW_WIDTH  120
#define COLOR_PREVIEW_HEIGHT 15
#define COLOR_PREVIEW_BITS   8

#define COLOR_TRANSFORMATION_WIDTH  60
#define COLOR_TRANSFORMATION_HEIGHT 40

#define MIN_MAX_NO_DATA_FILE _("<span style=\"italic\">No data file loaded</span>")
#define DATA_FILE_NO_FILE_MESSAGE _("No data file")

#define FLAG_PARAMETER_FILEEXT   "dataFile_fileExtension"
#define DESC_PARAMETER_FILEEXT   "The extension used for data file ; chain e.g. '.dat'"
#define PARAMETER_FILEEXT_DEFAULT    ".dat"

/* Local methods. */
static void createInteriorDataFile();
static void updateNormalisationWidgets(VisuData *data);
static void updateStatusBar(gchar *file, int nb);
static void updateColourWidgets(VisuData *data);
static void updatePostWidgets(VisuData *data);
static void makeColorPreview(VisuData *data);

/* Linkable widgets */
static GtkWidget *vBoxDataFileOption;
static GtkWidget *openDataFileButton;
static GtkWidget *checkbuttonData;
static GtkWidget *checkbuttonAutoLoad;
static GtkWidget *statusbarDataFile;
static guint statusDataFileContextId;
static GtkWidget *expanderNormalize;
static GtkWidget *radioNormalized;
static GtkWidget *radioMinMax;
static GtkWidget *entryDataMax;
static GtkWidget *entryDataMin;
static GtkWidget *spinbuttonDataChA[3];
static GtkWidget *spinbuttonDataChB[3];
static GtkWidget *comboboxDataCh[3];
static GtkWidget *radiobuttonDataRGB;
static GtkWidget *radiobuttonDataHSV;
static GtkWidget *labelChannel[3];
static GdkPixbuf *pixbufColorPreview;
static GtkWidget *colorPreview;
static GtkWidget *labelPreview;
static GtkWidget *readMinMaxValues;
static GtkWidget *comboPreSetColorRange;
static GtkWidget *checkHideMinValues;
static GtkWidget *spinHideMinValues;
static GtkWidget *entryHideMinValues;
static GtkWidget *entryFileExtension;

/* Signals that need to be suspended */
static gulong signalComboColumnId[3];
static gulong signalSpinDataChA[3];
static gulong signalSpinDataChB[3];
static gulong signalRadioRGB;
static gulong signalRadioHSV;
static gulong signalAskForHide;

/* Callbacks */
static void visuFileReset(GObject *obj, VisuData *dataObj, gpointer data);
static void onDataNew(GObject *obj, VisuData *dataObj, gpointer data);
static void loadDataFile(GtkButton *button, gpointer data);
static void useDataFileColor(GtkToggleButton *toggle, gpointer data);
static void onScaleTypeChange(GtkToggleButton *toggle, gpointer data);
static void onEntryMinMaxChangeValue(NumericalEntry *entry,
				     double oldValue, gpointer data);
static void onSpinChAChangeValue(GtkSpinButton *spinbutton, gpointer user_data);
static void onSpinChBChangeValue(GtkSpinButton *spinbutton, gpointer user_data);
static void onComboColChange(GtkComboBox *combo, gpointer data);
static void onColorTypeChange(GtkToggleButton *toggle, gpointer data);
static void onColorPreSetChange(ShadeComboBox *combo, Shade *shade, gpointer data);
static void onSpinHideMinValuesChange(GtkSpinButton *spin, gpointer data);
static void onEntryHideMinValuesChange(NumericalEntry *entry,
				       double oldValue, gpointer data);
static void onCheckHideMinValuesChange(GtkToggleButton *toggle, gpointer data);
static void onAskForHideNodes(VisuData *visuData, gboolean *redraw, gpointer data);
static void onDataFileEnter(ToolPanel *toolPanel, gpointer data);

/* Local methods. */
static void applyHideMinValues(VisuData *visuData, gboolean askRedraw);
static gboolean setPresetShade(Shade *shade);
static gboolean readFileExt(gchar **lines, int nbLines, int position,
				 VisuData *dataObj, GError **error);
static gboolean exportParameters(GString *data, int *nbLinesWritten,
				 VisuData* dataObj);



ToolPanel* panelDataFileInit()
{
  char *cl = _("Colorize with data");
  char *tl = _("Data color");
  VisuConfigFileEntry *resourceEntry;

  labelRGB[0] = RED_DATA_LABEL;
  labelRGB[1] = GREEN_DATA_LABEL;
  labelRGB[2] = BLUE_DATA_LABEL;
  labelHSV[0] = HUE_DATA_LABEL;
  labelHSV[1] = SAT_DATA_LABEL;
  labelHSV[2] = VAL_DATA_LABEL;

  panelDataFile = toolPanelNew_withIconFromPath("Panel_colorise", cl, tl,
						"stock-data_20.png");
  if (!panelDataFile)
    return (ToolPanel*)0;
  toolPanelSet_dockable(TOOL_PANEL(panelDataFile), TRUE);
						 
  /* Local variables */
  checkbuttonData = gtk_check_button_new_with_mnemonic(_("_Use color scheme"));
  entryFileExtension = (GtkWidget*)0;
  panelDataFileIsInitiated = FALSE;
  flagDataFileIsLoaded = FALSE;
  flagDisableCallbacks = FALSE;
  fileExt = g_strdup(PARAMETER_FILEEXT_DEFAULT);
  currentDataFile = (gchar*)0;

  /* Dealing with parameters. */
  resourceEntry = visuConfigFileAdd_entry(VISU_CONFIGFILE_PARAMETER,
					  FLAG_PARAMETER_FILEEXT,
					  DESC_PARAMETER_FILEEXT,
					  1, readFileExt);
  visuConfigFileSet_version(resourceEntry, 3.4f);
  visuConfigFileAdd_exportFunction(VISU_CONFIGFILE_PARAMETER,
				   exportParameters);

  /* Local callbacks. */
  g_signal_connect(G_OBJECT(panelDataFile), "page-entered",
		   G_CALLBACK(onDataFileEnter), (gpointer)0);

  return TOOL_PANEL(panelDataFile);
}

static void createInteriorDataFile()
{
  GtkWidget *containerDataFilePanel;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *vbox;
  GtkWidget *vboxNormalize, *vboxTransformation, *vboxPostProcessing;
  GtkWidget *hbox3, *hbox;
  GtkWidget *label19;
  GtkWidget *alignment2;
  GtkWidget *hbox8;
  GtkWidget *hbox7;
  GSList *radioNormalized_group = NULL;
  GtkWidget *alignment3;
  GtkWidget *table2;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *hbox6;
  GSList *radiobuttonDataRGB_group = NULL;
  GtkWidget *table3;
  GtkWidget *label;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label20;
  GtkWidget *label21;
  GtkObject *spinbuttonDataChA1_adj;
  GtkObject *spinbuttonDataChA2_adj;
  GtkObject *spinbuttonDataChA3_adj;
  GtkObject *spinbuttonDataChB1_adj;
  GtkObject *spinbuttonDataChB2_adj;
  GtkObject *spinbuttonDataChB3_adj;
  GtkWidget *expanderTransformation, *expanderPostProcessing;
  GtkWidget *hrule, *vrule;
  GtkTooltips *tooltips;
  GtkWidget *hboxPreSetColorRange;
  PangoFontDescription *font;
  gint i;
  VisuData *dataObj;

  DBG_fprintf(stderr, "Panel DataFile : creating subpanel.\n");

  tooltips = gtk_tooltips_new ();

  containerDataFilePanel = gtk_vbox_new (FALSE, 0);

  gtk_widget_show (checkbuttonData);
  gtk_box_pack_start (GTK_BOX (containerDataFilePanel), checkbuttonData, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(containerDataFilePanel), hbox3, FALSE, FALSE, 0);
  gtk_widget_show(hbox3);

  checkbuttonAutoLoad = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(hbox3), checkbuttonAutoLoad, TRUE, TRUE, 10);
  gtk_tooltips_set_tip (tooltips, checkbuttonAutoLoad,
			_("Try to load a data file whenever a new V_Sim file is loaded."
			  " For example, if 'example.ascii' has just been opened, V_Sim"
			  " will look for 'example.dat' and will apply it."), NULL);
  gtk_widget_show(checkbuttonAutoLoad);

  label19 = gtk_label_new(_("Auto load data file"));
  gtk_widget_show(label19);
  gtk_container_add(GTK_CONTAINER(checkbuttonAutoLoad), label19);

  openDataFileButton = gtk_button_new_from_stock ("gtk-open");
  gtk_tooltips_set_tip(tooltips, openDataFileButton,
		       _("Choose a file to read the colorization data from."), NULL);
  gtk_box_pack_start(GTK_BOX(hbox3), openDataFileButton, FALSE, FALSE, 10);
  gtk_widget_show (openDataFileButton);
  

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (containerDataFilePanel), scrolledwindow1, TRUE, TRUE, 0);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox);
  vBoxDataFileOption = vbox;

  /******************/
  /* Normalize part */
  /******************/
  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox7);
  gtk_box_pack_start(GTK_BOX(vbox), hbox7, FALSE, FALSE, 0);

  label = gtk_label_new(_("Normalize input: "));
  gtk_widget_set_name(label, "label_head");
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox7), label, TRUE, TRUE, 0);

  radioNormalized = gtk_radio_button_new_with_mnemonic (NULL, _("auto"));
  gtk_widget_show (radioNormalized);
  gtk_box_pack_start (GTK_BOX (hbox7), radioNormalized, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioNormalized), radioNormalized_group);
  radioNormalized_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioNormalized));

  radioMinMax = gtk_radio_button_new_with_mnemonic (NULL, _("manual"));
  gtk_widget_show (radioMinMax);
  gtk_box_pack_start (GTK_BOX (hbox7), radioMinMax, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioMinMax), radioNormalized_group);
  radioNormalized_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioMinMax));

  expanderNormalize = gtk_expander_new(_("More informations"));
  gtk_widget_show(expanderNormalize);
  gtk_box_pack_start(GTK_BOX (vbox), expanderNormalize, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(alignment3), 0, 0, 15, 0);
  gtk_widget_show(alignment3);
  gtk_container_add(GTK_CONTAINER(expanderNormalize), alignment3);

  vboxNormalize = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vboxNormalize);
  gtk_container_add(GTK_CONTAINER(alignment3), vboxNormalize);

  label = gtk_label_new(_("<b>Input data bounds:</b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_widget_show (label);
  gtk_box_pack_start(GTK_BOX(vboxNormalize), label, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 0.8, 1);
  gtk_widget_show(alignment3);
  gtk_box_pack_start(GTK_BOX(vboxNormalize), alignment3, FALSE, FALSE, 0);

  table2 = gtk_table_new (1, 4, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (alignment3), table2);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 3);

  entryDataMax = numericalEntry_new(1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryDataMax), 6);
  gtk_table_attach (GTK_TABLE (table2), entryDataMax, 3, 4, 0, 1,
                    GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 0, 0);
  gtk_widget_set_sensitive(entryDataMax, FALSE);
  gtk_widget_show(entryDataMax);

  entryDataMin = numericalEntry_new(-1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryDataMin), 6);
  gtk_table_attach (GTK_TABLE (table2), entryDataMin, 1, 2, 0, 1,
                    GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 0, 0);
  gtk_widget_set_sensitive(entryDataMin, FALSE);
  gtk_widget_show(entryDataMin);

  label7 = gtk_label_new (_("Min:"));
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table2), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 1, 0.5);

  label8 = gtk_label_new (_("Max:"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 1, 0.5);

  label = gtk_label_new(_("<b>Read min/max values:</b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX (vboxNormalize), label, FALSE, FALSE, 0);

  readMinMaxValues = gtk_alignment_new (0.5, 0.5, 0.8, 1);
  gtk_widget_show (readMinMaxValues);
  gtk_box_pack_start (GTK_BOX (vboxNormalize), readMinMaxValues, FALSE, FALSE, 0);

  label = gtk_label_new(MIN_MAX_NO_DATA_FILE);
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_widget_show(label);
  gtk_misc_set_alignment(GTK_MISC(label), 0.5, 0.5);
  gtk_container_add(GTK_CONTAINER(readMinMaxValues), label);


  /* Bar */
  alignment2 = gtk_alignment_new(0.5, 0.5, 0.3, 0);
  gtk_widget_show(alignment2);
  gtk_box_pack_start(GTK_BOX(vbox), alignment2, FALSE, FALSE, 8);
  hrule = gtk_hseparator_new();
  gtk_widget_show(hrule);
  gtk_container_add(GTK_CONTAINER(alignment2), hrule);

  /***********************/
  /* Transformation part */
  /***********************/
  label = gtk_label_new(_("Define the color scheme:"));
  gtk_widget_set_name(label, "label_head");
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_widget_show (label);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

  hboxPreSetColorRange = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hboxPreSetColorRange);
  gtk_box_pack_start(GTK_BOX(vbox), hboxPreSetColorRange, FALSE, FALSE, 0);

  label = gtk_label_new(_("Use preset:"));
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_widget_show (label);
  gtk_box_pack_start(GTK_BOX(hboxPreSetColorRange), label, TRUE, TRUE, 0);
  
  comboPreSetColorRange = shadeComboBox_new(FALSE);
  gtk_widget_show(comboPreSetColorRange);
  gtk_box_pack_start(GTK_BOX (hboxPreSetColorRange), comboPreSetColorRange, FALSE, FALSE, 0);

  expanderTransformation = gtk_expander_new(_("More options"));
  gtk_expander_set_expanded(GTK_EXPANDER(expanderTransformation), FALSE);
  gtk_widget_show(expanderTransformation);
  gtk_box_pack_start(GTK_BOX (vbox), expanderTransformation, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(alignment3), 0, 0, 15, 0);
  gtk_widget_show(alignment3);
  gtk_container_add(GTK_CONTAINER(expanderTransformation), alignment3);

  vboxTransformation = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vboxTransformation);
  gtk_container_add(GTK_CONTAINER(alignment3), vboxTransformation);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vboxTransformation), hbox6, FALSE, FALSE, 0);

  label = gtk_label_new(_("<b>Colour space: </b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox6), label, TRUE, TRUE, 0);

  radiobuttonDataRGB = gtk_radio_button_new_with_mnemonic (NULL, _("RGB"));
  gtk_widget_show (radiobuttonDataRGB);
  gtk_box_pack_start (GTK_BOX (hbox6), radiobuttonDataRGB, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonDataRGB), radiobuttonDataRGB_group);
  radiobuttonDataRGB_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonDataRGB));

  radiobuttonDataHSV = gtk_radio_button_new_with_mnemonic (NULL, _("HSV"));
  gtk_widget_show (radiobuttonDataHSV);
  gtk_box_pack_start (GTK_BOX (hbox6), radiobuttonDataHSV, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonDataHSV), radiobuttonDataRGB_group);
  radiobuttonDataRGB_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonDataHSV));

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV), TRUE);

  table3 = gtk_table_new (3, 7, FALSE);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vboxTransformation), table3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table3), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 3);

  labelChannel[0] = gtk_label_new (_("R"));
  gtk_widget_show (labelChannel[0]);
  gtk_table_attach (GTK_TABLE (table3), labelChannel[0], 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[0]), 0, 0.5);

  labelChannel[1] = gtk_label_new (_("G"));
  gtk_widget_show (labelChannel[1]);
  gtk_table_attach (GTK_TABLE (table3), labelChannel[1], 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[1]), 0, 0.5);

  labelChannel[2] = gtk_label_new (_("B"));
  gtk_widget_show (labelChannel[2]);
  gtk_table_attach (GTK_TABLE (table3), labelChannel[2], 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[2]), 0, 0.5);

  label14 = gtk_label_new ("=");
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table3), label14, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label14 = gtk_label_new ("=");
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table3), label14, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label14 = gtk_label_new ("=");
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table3), label14, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label15 = gtk_label_new ("+");
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table3), label15, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label15 = gtk_label_new ("+");
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table3), label15, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label15 = gtk_label_new ("+");
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table3), label15, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label16 = gtk_label_new ("\303\227");
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table3), label16, 5, 6, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label20 = gtk_label_new ("\303\227");
  gtk_widget_show (label20);
  gtk_table_attach (GTK_TABLE (table3), label20, 5, 6, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label21 = gtk_label_new ("\303\227");
  gtk_widget_show (label21);
  gtk_table_attach (GTK_TABLE (table3), label21, 5, 6, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  spinbuttonDataChA1_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChA[0] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA1_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChA[0]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChA[0], 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[0]), TRUE);

  spinbuttonDataChA2_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChA[1] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA2_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChA[1]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChA[1], 4, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[1]), TRUE);

  spinbuttonDataChA3_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChA[2] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA3_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChA[2]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChA[2], 4, 5, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[2]), TRUE);

  spinbuttonDataChB1_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChB[0] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB1_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChB[0]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChB[0], 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[0]), TRUE);

  spinbuttonDataChB2_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChB[1] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB2_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChB[1]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChB[1], 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[1]), TRUE);

  spinbuttonDataChB3_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.1);
  spinbuttonDataChB[2] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB3_adj), 0.001, 2);
  gtk_widget_show (spinbuttonDataChB[2]);
  gtk_table_attach (GTK_TABLE (table3), spinbuttonDataChB[2], 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[2]), TRUE);

  for (i = 0; i < 3; i++)
    {
      comboboxDataCh[i] = gtk_combo_box_new_text ();
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), "1.");
      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0);
      gtk_widget_show (comboboxDataCh[i]);
      gtk_table_attach (GTK_TABLE (table3), comboboxDataCh[i], 6, 7, i, i + 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (GTK_FILL), 0, 0);
    }

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_box_pack_start(GTK_BOX(vbox), hbox8, FALSE, FALSE, 0);

  label = gtk_label_new(_("Color range preview: "));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox8), label, FALSE, FALSE, 0);

  pixbufColorPreview = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE,
				      COLOR_PREVIEW_BITS,
				      COLOR_PREVIEW_WIDTH,
				      COLOR_PREVIEW_HEIGHT);
  colorPreview = create_pixmap ((GtkWidget*)0, NULL);
  gtk_widget_set_size_request (colorPreview, COLOR_PREVIEW_WIDTH,
			       COLOR_PREVIEW_HEIGHT);
  gtk_box_pack_start (GTK_BOX (hbox8), colorPreview, TRUE, TRUE, 0);

  labelPreview = gtk_label_new(_("<span style=\"italic\">No preview available</span>"));
  gtk_label_set_use_markup(GTK_LABEL(labelPreview), TRUE);
  gtk_widget_show (labelPreview);
  gtk_box_pack_start (GTK_BOX (hbox8), labelPreview, TRUE, TRUE, 0);

  /* Bar */
  alignment2 = gtk_alignment_new(0.5, 0.5, 0.3, 0);
  gtk_widget_show(alignment2);
  gtk_box_pack_start(GTK_BOX(vbox), alignment2, FALSE, FALSE, 8);
  hrule = gtk_hseparator_new();
  gtk_widget_show(hrule);
  gtk_container_add(GTK_CONTAINER(alignment2), hrule);

  /***********************/
  /* Post treatment part */
  /***********************/
  expanderPostProcessing = gtk_expander_new(_("Post processing"));
  gtk_widget_set_name(gtk_expander_get_label_widget(GTK_EXPANDER(expanderPostProcessing)),
		      "label_head");
  gtk_expander_set_expanded(GTK_EXPANDER(expanderPostProcessing), TRUE);
  gtk_widget_show(expanderPostProcessing);
  gtk_box_pack_start(GTK_BOX(vbox), expanderPostProcessing, FALSE, FALSE, 0);

  vboxPostProcessing = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(vboxPostProcessing);
  gtk_container_add(GTK_CONTAINER(expanderPostProcessing), vboxPostProcessing);

  hbox7 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox7);
  gtk_box_pack_start(GTK_BOX(vboxPostProcessing), hbox7, FALSE, FALSE, 0);

  checkHideMinValues = gtk_check_button_new();
  gtk_widget_show(checkHideMinValues);
  gtk_box_pack_start(GTK_BOX(hbox7), checkHideMinValues, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkHideMinValues), FALSE);
  
  label = gtk_label_new(_("Hide elements"));
  gtk_widget_show(label);
  gtk_container_add(GTK_CONTAINER(checkHideMinValues), label);

  label = gtk_label_new(_(" whose value from"));
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(hbox7), label, FALSE, FALSE, 0);

  hbox7 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox7);
  gtk_box_pack_start(GTK_BOX(vboxPostProcessing), hbox7, FALSE, FALSE, 0);

  label = gtk_label_new(_("col. "));
  gtk_widget_show(label);
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_box_pack_start(GTK_BOX(hbox7), label, TRUE, TRUE, 0);

  /* The 2 here is to avoid a GTK bug in 2.4. */
  spinHideMinValues = gtk_spin_button_new_with_range(1, 2, 1);
  gtk_widget_show(spinHideMinValues);
  gtk_box_pack_start(GTK_BOX(hbox7), spinHideMinValues, FALSE, FALSE, 0);

  label = gtk_label_new(_(" is lower than "));
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(hbox7), label, FALSE, FALSE, 0);

  entryHideMinValues = numericalEntry_new(1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryHideMinValues), 10);
  gtk_widget_show(entryHideMinValues);
  gtk_box_pack_start(GTK_BOX(hbox7), entryHideMinValues, FALSE, FALSE, 0);


  /**************/
  /* Status bar */
  /**************/
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_end(GTK_BOX(containerDataFilePanel), hbox, FALSE, FALSE, 0);

  statusbarDataFile = gtk_statusbar_new();
  gtk_box_pack_start(GTK_BOX(hbox), statusbarDataFile, TRUE, TRUE, 0);
  gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (statusbarDataFile), FALSE);
  statusDataFileContextId =
    gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbarDataFile),
				 _("Description of loaded data file."));
  gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile), statusDataFileContextId,
		     DATA_FILE_NO_FILE_MESSAGE);

  vrule = gtk_vseparator_new();
  gtk_box_pack_start(GTK_BOX(hbox), vrule, FALSE, FALSE, 0);

  label = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label),
		       _("<span size=\"smaller\">File ext.:</span>"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 1);

  entryFileExtension = gtk_entry_new();
  font = pango_font_description_copy
    (gtk_widget_get_style(entryFileExtension)->font_desc);
  pango_font_description_set_size
    (font, (int)((float)pango_font_description_get_size(font) * 0.75));
  gtk_widget_modify_font(entryFileExtension, font);
  gtk_entry_set_width_chars(GTK_ENTRY(entryFileExtension), 4);
  gtk_entry_set_text(GTK_ENTRY(entryFileExtension), fileExt);
  gtk_box_pack_start(GTK_BOX(hbox), entryFileExtension, FALSE, FALSE, 0);
  gtk_tooltips_set_tip(tooltips, entryFileExtension,
		       _("File extension used for the autoload option, its value is"
			 " saved in the parameter file (see 'dataFile_fileExt')."), NULL);
  
  gtk_widget_show_all(hbox);

  gtk_widget_set_sensitive(vBoxDataFileOption, FALSE);
  gtk_widget_show(containerDataFilePanel);

  /********************/
  /* Create callbacks */
  /********************/
  g_signal_connect(G_OBJECT(openDataFileButton), "clicked",
		   G_CALLBACK(loadDataFile), (gpointer)0);
  g_signal_connect(G_OBJECT(checkbuttonData), "toggled",
		   G_CALLBACK(useDataFileColor), (gpointer)0);

  g_signal_connect(G_OBJECT(visu), "dataLoaded",
		   G_CALLBACK(visuFileReset), (gpointer)0);
  g_signal_connect(G_OBJECT(visu), "dataNew",
		   G_CALLBACK(onDataNew), (gpointer)0);
  g_signal_connect(G_OBJECT(radioNormalized), "toggled",
		   G_CALLBACK(onScaleTypeChange), (gpointer)dataFile_normalize);
  g_signal_connect(G_OBJECT(radioMinMax), "toggled",
		   G_CALLBACK(onScaleTypeChange), (gpointer)dataFile_minMax);
  g_signal_connect(G_OBJECT(entryDataMin), "value-changed",
		   G_CALLBACK(onEntryMinMaxChangeValue), (gpointer)0);
  g_signal_connect(G_OBJECT(entryDataMax), "value-changed",
		   G_CALLBACK(onEntryMinMaxChangeValue), (gpointer)1);
  for (i = 0; i < 3; i++)
    {
      signalSpinDataChA[i] =
	g_signal_connect(G_OBJECT(spinbuttonDataChA[i]), "value-changed",
			 G_CALLBACK(onSpinChAChangeValue), GINT_TO_POINTER(i));
      signalSpinDataChB[i] =
	g_signal_connect(G_OBJECT(spinbuttonDataChB[i]), "value-changed",
			 G_CALLBACK(onSpinChBChangeValue), GINT_TO_POINTER(i));
      signalComboColumnId[i] =
	g_signal_connect(G_OBJECT(comboboxDataCh[i]), "changed",
			 G_CALLBACK(onComboColChange), GINT_TO_POINTER(i));
    }
  signalRadioRGB = g_signal_connect(G_OBJECT(radiobuttonDataRGB), "toggled",
				    G_CALLBACK(onColorTypeChange), (gpointer)dataFile_rgb);
  signalRadioHSV = g_signal_connect(G_OBJECT(radiobuttonDataHSV), "toggled",
				    G_CALLBACK(onColorTypeChange), (gpointer)dataFile_hsv);

  g_signal_connect(G_OBJECT(comboPreSetColorRange), "shade-selected",
		   G_CALLBACK(onColorPreSetChange), (gpointer)0);

  g_signal_connect(G_OBJECT(checkHideMinValues), "toggled",
		   G_CALLBACK(onCheckHideMinValuesChange), (gpointer)0);
  g_signal_connect(G_OBJECT(entryHideMinValues), "value-changed",
		   G_CALLBACK(onEntryHideMinValuesChange), (gpointer)0);
  g_signal_connect(G_OBJECT(spinHideMinValues), "value-changed",
		   G_CALLBACK(onSpinHideMinValuesChange), (gpointer)0);

  /* If there's a dataObj loaded, we missed the dataReadyForRendering signal,
     then we add the callback for NodeAskForShowHide manually. */
  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (dataObj)
    signalAskForHide = g_signal_connect(G_OBJECT(dataObj), "NodeAskForShowHide",
					G_CALLBACK(onAskForHideNodes), (gpointer)0);

  DBG_fprintf(stderr, " | Creation OK.\n");

  gtk_container_add(GTK_CONTAINER(panelDataFile), containerDataFilePanel);
}

static void updateNormalisationWidgets(VisuData *data)
{
  GtkWidget *childMinMax;
  int nbColumns;
  int i;
  GtkWidget *table, *label;
  GString *labelStr;
  float minMax[2];

  DBG_fprintf(stderr, "Panel DataFile: update widgets for normalisation.\n");

  /* empty the child of the alignment */
  childMinMax = gtk_bin_get_child(GTK_BIN(readMinMaxValues));
  if (childMinMax)
    gtk_widget_destroy(childMinMax);

  /* Special case without VisuData or without stored data. */
  if (!data || !dataFileGet_file(data))
    {
      label = gtk_label_new(MIN_MAX_NO_DATA_FILE);
      gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
      gtk_widget_show(label);
      gtk_misc_set_alignment(GTK_MISC(label), 0.5, 0.5);
      gtk_container_add(GTK_CONTAINER(readMinMaxValues), label);

      return;
    }

  /* Update the radio buttons. */
  switch (dataFileGet_scaleType(data))
    {
    case dataFile_normalize:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioNormalized), TRUE);
      break;
    case dataFile_minMax:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioMinMax), TRUE);
      break;
    default:
      break;
    }

  /* Update the min max entries. */
  numericalEntrySet_value(NUMERICAL_ENTRY(entryDataMin),
			  dataFileGet_min(data));
  numericalEntrySet_value(NUMERICAL_ENTRY(entryDataMax),
			  dataFileGet_max(data));

  /* Update the table of min/max values. */
  nbColumns = dataFileGet_nbColumns(data);
  g_return_if_fail(nbColumns > 0);

  table = gtk_table_new(nbColumns + 1, 3, FALSE);
  label = gtk_label_new(_("Column number"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 2, 0);
  label = gtk_label_new(_("Min value"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1, GTK_EXPAND, GTK_SHRINK, 2, 0);
  label = gtk_label_new(_("Max value"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 2, 3, 0, 1, GTK_EXPAND, GTK_SHRINK, 2, 0);

  labelStr = g_string_new("");
  for (i = 0; i < nbColumns; i++)
    {
      g_string_printf(labelStr, _("Column %d"), i + 1);
      label = gtk_label_new(labelStr->str);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, i + 1, i + 2,
		       GTK_SHRINK, GTK_SHRINK, 2, 0);

      if (dataFileGet_fileMinMaxFromColumn(data, minMax, i))
	{
	  g_string_printf(labelStr, "%g", minMax[0]);
	  label = gtk_label_new(labelStr->str);
	  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
	  gtk_table_attach(GTK_TABLE(table), label, 1, 2, i + 1, i + 2,
			   GTK_EXPAND, GTK_SHRINK, 2, 0);

	  g_string_printf(labelStr, "%g", minMax[1]);
	  label = gtk_label_new(labelStr->str);
	  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
	  gtk_table_attach(GTK_TABLE(table), label, 2, 3, i + 1, i + 2,
			   GTK_EXPAND, GTK_SHRINK, 2, 0);
	}
      else
	g_warning("Can't retrieve min/max values for column %d.\n", i);
    }
  gtk_widget_show_all(table);
  g_string_free(labelStr, TRUE);

  gtk_container_add(GTK_CONTAINER(readMinMaxValues), table);
}
static void updateColourWidgets(VisuData *data)
{
  int i, j;
  GString *label;
  int *selected;
  float *val;

  DBG_fprintf(stderr, "Panel dataFile: rebuilding comboboxes.\n");
  /* empty combobox */
  for (i = 0; i < 3; i++)
    {
      for (j = nbColumns; j > 0; j--)
	gtk_combo_box_remove_text(GTK_COMBO_BOX(comboboxDataCh[i]), j);
      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0);
      DBG_fprintf(stderr, "Panel dataFile : reset channel %d.\n", i);
    }
  if (data && dataFileGet_file(data))
    {
      /* Update the vectors. */
      val = dataFileGet_vectA(data);
      if (val)
	for (i = 0; i < 3; i++)
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[i]), val[i]);
      val = dataFileGet_vectB(data);
      if (val)
	for (i = 0; i < 3; i++)
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[i]), val[i]);
      /* Change the column comboboxes. */
      nbColumns = dataFileGet_nbColumns(data);
      if (nbColumns > 0)
	{
	  label = g_string_new("");
	  for (j = 0; j < nbColumns; j++)
	    {
	      g_string_printf(label, _("Col. %d"), j + 1);
	      for (i = 0; i < 3; i++)
		gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), label->str);
	    }
	  g_string_free(label, TRUE);
	  selected = dataFileGet_colUsed(data);
	  if (selected)
	    {
	      for (i = 0; i < 3; i++)
		{
		  DBG_fprintf(stderr, "Panel dataFile : Channel %d has selection %d.\n",
			      i, selected[i]);
		  gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), selected[i] + 1);
		}
	    }
	}
      /* Change the colour scheme. */
      switch (dataFileGet_colorType(data))
	{
	case dataFile_rgb:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataRGB), TRUE);
	  for (i = 0; i < 3; i++)
	    gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
	  break;
	case dataFile_hsv:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV), TRUE);
	  for (i = 0; i < 3; i++)
	    gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
	  break;
	default:
	  break;
	}
    }
  /* Update the color preview. */
  makeColorPreview(data);
}
static void updatePostWidgets(VisuData *data)
{
  int nb;
  GtkAdjustment *adj;

  DBG_fprintf(stderr, "Panel dataFile: update post-processing widgets.\n");

  nb = (data)?MAX(dataFileGet_nbColumns(data), 1):1;

  adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinHideMinValues));
  gtk_adjustment_clamp_page(adj, 1, nb);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinHideMinValues), 1);
}
static void makeColorPreview(VisuData *data)
{
  int *valCols;
  int i, j;
  gboolean different;
  int rowstride, x, y;
  guchar *pixels, *p;
  float rgbValues[COLOR_PREVIEW_WIDTH][3];
  float fromVal[3];
  int ind[3];

  if (!data)
    {
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), NULL);
      gtk_widget_hide(colorPreview);
      gtk_widget_show(labelPreview);
      return;
    }

  valCols = dataFileGet_colUsed(data);
  if (!valCols)
    return;

  for (i = 0; i < 3; i++)
    ind[i] = (valCols[i] != -1)?i:-1;
  different = (valCols[0] != -1 && valCols[1] != -1 && valCols[0] != valCols[1]) ||
    (valCols[1] != -1 && valCols[2] != -1 && valCols[1] != valCols[2]) ||
    (valCols[0] != -1 && valCols[2] != -1 && valCols[0] != valCols[2]) ||
    (valCols[0] == -1 && valCols[1] == -1 && valCols[2] == -1);
  if (different)
    {
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), NULL);
      gtk_widget_hide(colorPreview);
      gtk_widget_show(labelPreview);
    }
  else
    {
      DBG_fprintf(stderr, "Panel dataFile : making color preview bitmap.\n");
      rowstride = gdk_pixbuf_get_rowstride(pixbufColorPreview);
      pixels = gdk_pixbuf_get_pixels(pixbufColorPreview);

      for (i = 0; i < COLOR_PREVIEW_WIDTH; i++)
	{
	  for (j = 0; j < 3; j++)
	    fromVal[j] = (ind[j] >= 0)?(float)i / (float)(COLOR_PREVIEW_WIDTH - 1):1.;
	  dataFileGet_valuesTransformedInRGB(data, rgbValues[i], fromVal);
/* 	  fprintf(stderr, "% d ----> %f %f %f -> %f %f %f\n",i, fromVal[0], fromVal[1], fromVal [2], rgbValues[i][0], rgbValues[i][1], rgbValues[i][2]); */
	}

      for (y = 0; y < COLOR_PREVIEW_HEIGHT; y++)
	for (x = 0; x < COLOR_PREVIEW_WIDTH; x++)
	  {
	    p = pixels + y * rowstride + x * 3;
	    p[0] = (guchar)(rgbValues[x][0] * 255);
	    p[1] = (guchar)(rgbValues[x][1] * 255);
	    p[2] = (guchar)(rgbValues[x][2] * 255);
	  }
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), pixbufColorPreview);

      gtk_widget_hide(labelPreview);
      gtk_widget_show(colorPreview);
    }
}

static void updateStatusBar(gchar* file, int nbColumns)
{
  gchar *fileUTF8, *basename;
  GString *message;

  /* Create the text of the status bar or empty it. */

  gtk_statusbar_pop(GTK_STATUSBAR(statusbarDataFile),
		    statusDataFileContextId);
  /* Create the text of the status bar or empty it. */
  if (file)
    {
      basename = g_path_get_basename(file);
      fileUTF8 = g_filename_to_utf8(basename, -1, NULL, NULL, NULL);
      g_free(basename);
      g_return_if_fail(fileUTF8);

      message = g_string_new("");
      if (nbColumns > 0)
	g_string_append_printf(message, _("%s: %d column(s)"),
			       fileUTF8, nbColumns);
      else
	g_string_append_printf(message, _("%s: file error"),
				   fileUTF8);
      gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile),
			 statusDataFileContextId,
			 message->str);
      g_string_free(message, TRUE);
      g_free(fileUTF8);
    }
  else
      gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile),
			 statusDataFileContextId,
			 DATA_FILE_NO_FILE_MESSAGE);
}
gboolean panelDataFileLoad_file(VisuData *visuData, gchar *file, gboolean *new)
{
  GString *message;
  int errors;

  DBG_fprintf(stderr, "Panel dataFile : loading a new file '%s'.\n", file);
  g_return_val_if_fail(visuData && file && new, 0);

  /* If panel has still not been loaded, we do it now. */
  if (!panelDataFileIsInitiated)
    {
      panelDataFileIsInitiated = TRUE;
      createInteriorDataFile();
    }
  
  message = g_string_new("");
  flagDataFileIsLoaded = dataFileSet_file(visuData, file, new, message, &errors);

  /* Raise the error dialog if necessary. */
  if (errors)
    visuGtkRaise_warningLong(_("Loading a data file"), message->str, (GtkWindow*)0);
  g_string_free(message, TRUE);

  if (flagDataFileIsLoaded)
    {
      /* Set if the colours are used. */
      dataFileSet_used
	(visuData, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)));
      /* Force applying hidding status if needed. */
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
	applyHideMinValues(visuData, FALSE);
    }
  
  DBG_fprintf(stderr, "Panel dataFile: load OK.\n");
  return flagDataFileIsLoaded;
}
void panelDataFileUpdate(VisuData *dataObj)
{
  gchar *file;

  DBG_fprintf(stderr, "Panel dataFile: update the widgets"
	      " depending on the data %p.\n", (gpointer)dataObj);

  if (dataObj && dataFileGet_used(dataObj))
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbuttonData), TRUE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbuttonData), FALSE);

  file = (dataObj)?dataFileGet_file(dataObj):(gchar*)0;

  gtk_widget_set_sensitive(openDataFileButton, (dataObj != (VisuData*)0));
  gtk_widget_set_sensitive(vBoxDataFileOption, (file != (gchar*)0));

  /* Check that widgets are out-off date. */
  if ((!file && !currentDataFile) || (file && currentDataFile &&
				      !strcmp(currentDataFile, file)))
    return;

  /* Update flags. */
  if (currentDataFile)
    g_free(currentDataFile);
  currentDataFile = (dataObj)?g_strdup(file):(gchar*)0;

  /* Update the widgets of this panel if necessary. */
  if (dataObj)
    updateStatusBar(file, dataFileGet_nbColumns(dataObj));
  else
    updateStatusBar(file, 0);
  updateNormalisationWidgets(dataObj);
  updateColourWidgets(dataObj);
  updatePostWidgets(dataObj);
}

/*************/
/* Callbacks */
/*************/
static void visuFileReset(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  char* file;
  gchar* fileCpy, *fileExtPosition;
  GString *dataFile;
  int res, i, nbColumns;
  float minVal, maxVal;
  int dataNormalize, colourScheme;
  int colUsed[3];
  float vectA[3], vectB[3];
  gboolean new;

  DBG_fprintf(stderr, "Panel dataFile : caught 'dataLoaded' signal.\n");
  if (dataObj)
    {
      /* Store old values, may be useful if data file is autoloaded. */
      DBG_fprintf(stderr, "Panel dataFile : Saving current colour values.\n");
      for (i = 0; i < 3; i++)
	{
	  vectA[i] = (float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbuttonDataChA[i]));
	  vectB[i] = (float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinbuttonDataChB[i]));
	  colUsed[i] = gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxDataCh[i])) - 1;
	}
      minVal = numericalEntryGet_value(NUMERICAL_ENTRY(entryDataMin));
      maxVal = numericalEntryGet_value(NUMERICAL_ENTRY(entryDataMax));
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioNormalized)))
	dataNormalize = dataFile_normalize;
      else
	dataNormalize = dataFile_minMax;
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV)))
	colourScheme = dataFile_hsv;
      else
	colourScheme = dataFile_rgb;
	  
      /* Check the autoload flag. */
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonAutoLoad)))
	{
	  /* Compute the name of the data
	     file from the rendered filename. */
	  file = visuDataGet_file(dataObj, 0, (FileFormat**)0);
	  fileCpy = g_strdup(file);
	  fileExtPosition = g_strrstr(fileCpy, ".");
	  if (fileExtPosition)
	    *fileExtPosition = '\0';
	  dataFile = g_string_new("");
	  g_string_printf(dataFile, "%s%s", fileCpy,
			  gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
	  DBG_fprintf(stderr, "Panel DataFile : try to load a new data file"
		      " ('%s') from the name of the rendered file.\n", dataFile->str);
	  res = panelDataFileLoad_file(dataObj, dataFile->str, &new);
	  if (res)
	    {
	      DBG_fprintf(stderr, "Panel dataFile: restore colour"
			  " values from previous.\n");
	      /* Reuse previous colUsed values. */
	      nbColumns = dataFileGet_nbColumns(dataObj);
	      for (i = 0; i < 3; i++)
		{
		  dataFileSet_vectA(dataObj, vectA[i], i);
		  dataFileSet_vectB(dataObj, vectB[i], i);
		  if (colUsed[i] < nbColumns)
		    dataFileSet_colUsed(dataObj, colUsed[i], i);
		}
	      dataFileSet_min(dataObj, minVal);
	      dataFileSet_max(dataObj, maxVal);
	      dataFileSet_scaleType(dataObj, dataNormalize);
	      dataFileSet_colorType(dataObj, colourScheme);
	      dataFileSet_used
		(dataObj, 
		 gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)));
	    }

	  g_string_free(dataFile, TRUE);
	  g_free(fileCpy);
	}
    }
  if (toolPanelGet_visible(TOOL_PANEL(panelDataFile)))
    {
      flagDisableCallbacks = TRUE;
      panelDataFileUpdate(dataObj);
      flagDisableCallbacks = FALSE;
    }
}
static void onDataNew(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  /* Add the listener to the 'NodeAskForShowHide' signal. */
  signalAskForHide = g_signal_connect(G_OBJECT(dataObj), "NodeAskForShowHide",
				      G_CALLBACK(onAskForHideNodes), (gpointer)0);
}
static void loadDataFile(GtkButton *button _U_, gpointer data _U_)
{
  GtkWidget *file_selector;
  char *filename;
  char *directory;
  int res;
  VisuData *dataObj;
  gboolean new;
  GtkFileFilter *filter;
  GString *label;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  file_selector = gtk_file_chooser_dialog_new(_("Load data file"),
					      toolPanelGet_containerWindow(TOOL_PANEL(panelDataFile)),
					      GTK_FILE_CHOOSER_ACTION_OPEN,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OPEN, GTK_RESPONSE_OK,
					      NULL);
  directory = gtkMainClassGet_lastOpenDirectory();
  if (directory)
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(file_selector), directory);
  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(file_selector),
				       FALSE);
  filter = gtk_file_filter_new();
  label = g_string_new(_("Data files"));
  g_string_append_printf(label, " (*%s)",
			 gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
  gtk_file_filter_set_name(filter, label->str);
  g_string_printf(label, "*%s", gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
  gtk_file_filter_add_pattern(filter, label->str);
  g_string_free(label, TRUE);
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(file_selector), filter);
  filter = gtk_file_filter_new();
  gtk_file_filter_set_name(filter, _("All files"));
  gtk_file_filter_add_pattern(filter, "*");
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(file_selector), filter);

  gtk_widget_set_name(file_selector, "filesel");
  gtk_window_set_position(GTK_WINDOW(file_selector), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (file_selector), TRUE);

  if (gtk_dialog_run (GTK_DIALOG (file_selector)) == GTK_RESPONSE_OK)
    {
      filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER (file_selector));
      directory = (char*)gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (file_selector));
      gtkMainClassSet_lastOpenDirectory(directory);
      g_free(directory);
      gtk_widget_destroy (file_selector);
      res = panelDataFileLoad_file(dataObj, filename, &new);
      g_free(filename);
      panelDataFileUpdate(dataObj);
      /* Ask for a redraw */
      if (res)
	{
	  /* Update rendering. */
	  if (new)
	    gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), 0);
	  else
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)))
	      dataFileReDraw(dataObj);
	}
      else
	{
	  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
	    applyHideMinValues(dataObj, FALSE);
	  dataFileReDraw(dataObj);
	}
    }
  else
    {
      directory = (char*)gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (file_selector));
      gtkMainClassSet_lastOpenDirectory(directory);
      g_free(directory);
      gtk_widget_destroy (file_selector);
    }
}
void panelDataFileSet_use(gboolean used)
{
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbuttonData), used);
}
static void useDataFileColor(GtkToggleButton *toggle, gpointer data _U_)
{
  gboolean isOn;
  int res;
  VisuData *dataObj;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    return;

  isOn = gtk_toggle_button_get_active(toggle);
  res = dataFileSet_used(dataObj, (gboolean)isOn);
  /* Force applying hidding status if needed. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
    applyHideMinValues(dataObj, FALSE);
  if (res)
    dataFileReDraw(dataObj);
}
static void onDataFileEnter(ToolPanel *toolPanel _U_, gpointer data _U_)
{
  DBG_fprintf(stderr, "Panel dataFile : check values on enter.\n");

  if (!panelDataFileIsInitiated)
    {
      DBG_fprintf(stderr, "Panel dataFile : initialize interior.\n");
  
      panelDataFileIsInitiated = TRUE;
      createInteriorDataFile();
    }

  flagDisableCallbacks = TRUE;
  DBG_fprintf(stderr, "Panel dataFile : set values on enter.\n");
  panelDataFileUpdate(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)));
  flagDisableCallbacks = FALSE;
}
static void onScaleTypeChange(GtkToggleButton *toggle, gpointer data)
{
  int scale, res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile : change on scale radio buttons.\n");

  if (!gtk_toggle_button_get_active(toggle))
    return;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  scale = GPOINTER_TO_INT(data);
  g_return_if_fail(scale >= dataFile_normalize && scale <= dataFile_minMax);

  res = dataFileSet_scaleType(dataObj, scale);
  if (scale != dataFile_minMax)
    {
      gtk_widget_set_sensitive(entryDataMax, FALSE);
      gtk_widget_set_sensitive(entryDataMin, FALSE);
    }
  else
    {
      gtk_widget_set_sensitive(entryDataMax, TRUE);
      gtk_widget_set_sensitive(entryDataMin, TRUE);
      gtk_expander_set_expanded(GTK_EXPANDER(expanderNormalize), TRUE);
    }
  if (res)
    dataFileReDraw(dataObj);
}
static void onEntryMinMaxChangeValue(NumericalEntry *entry,
				     double oldValue _U_, gpointer data)
{
  int minMax, res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on min/max entries.\n");

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  minMax = GPOINTER_TO_INT(data);
  g_return_if_fail(minMax == 0 || minMax == 1);
  DBG_fprintf(stderr, "Panel Data File: grep value from GtkEntry for"
	      " the minMax value (%d).\n", minMax);

  switch (minMax)
    {
    case 0:
      res = dataFileSet_min(dataObj, numericalEntryGet_value(entry));
      break;
    case 1:
      res = dataFileSet_max(dataObj, numericalEntryGet_value(entry));
      break;
    default:
      res = 0;
      break;
    }
  if (res)
    dataFileReDraw(dataObj);
}
static void onSpinChAChangeValue(GtkSpinButton *spinbutton, gpointer user_data)
{
  int pos;
  int res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile : change on spin vectA.\n");
  /* Desable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  pos = GPOINTER_TO_INT(user_data);
  g_return_if_fail(pos >= 0 && pos < 3);

  res = dataFileSet_vectA(dataObj, gtk_spin_button_get_value(spinbutton), pos);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}
static void onSpinChBChangeValue(GtkSpinButton *spinbutton, gpointer user_data)
{
  int pos;
  int res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile : change on spin vectB.\n");
  /* Desable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  pos = GPOINTER_TO_INT(user_data);
  g_return_if_fail(pos >= 0 && pos < 3);

  res = dataFileSet_vectB(dataObj, gtk_spin_button_get_value(spinbutton), pos);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}

static void onComboColChange(GtkComboBox *combo, gpointer data)
{
  int pos;
  int res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile : change on combo column.\n");
  /* Disable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  pos = GPOINTER_TO_INT(data);
  g_return_if_fail(pos >= 0 && pos < 3);

  res = dataFileSet_colUsed(dataObj, gtk_combo_box_get_active(combo) - 1, pos);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}
static void onColorTypeChange(GtkToggleButton *toggle, gpointer data)
{
  int color, res, i;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile : change on colour type radio buttons.\n");
  /* Desable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  if (!gtk_toggle_button_get_active(toggle))
    return;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  color = GPOINTER_TO_INT(data);
  g_return_if_fail(color >= dataFile_rgb && color <= dataFile_hsv);

  res = dataFileSet_colorType(dataObj, color);
  if (color == dataFile_rgb)
    for (i = 0; i < 3; i++)
      gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
  else
    for (i = 0; i < 3; i++)
      gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}
static gboolean setPresetShade(Shade *shade)
{
  gboolean ok;
  float *vectA, *vectB;
  gboolean *vectX;
  int i;
  VisuData *dataObj;

  DBG_fprintf(stderr, "Panel dataFile: change the colour transformation"
	      " according to shade %p.\n", (gpointer)shade);
  
  if (!shade)
    return FALSE;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));

  /* Suspend all combo signals during changes */
  g_signal_handler_block(G_OBJECT(radiobuttonDataRGB), signalRadioRGB);
  g_signal_handler_block(G_OBJECT(radiobuttonDataHSV), signalRadioHSV);
  for (i = 0; i < 3; i++)
    {
      g_signal_handler_block(G_OBJECT(comboboxDataCh[i]), signalComboColumnId[i]);
      g_signal_handler_block(G_OBJECT(spinbuttonDataChA[i]), signalSpinDataChA[i]);
      g_signal_handler_block(G_OBJECT(spinbuttonDataChB[i]), signalSpinDataChB[i]);
    }
  dataFileSet_shade(dataObj, shade);
  switch (shadeGet_colorMode(shade))
    {
    case shade_colorModeRGB:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataRGB), TRUE);
      for (i = 0; i < 3; i++)
	gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
      break;
    case shade_colorModeHSV:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV), TRUE);
      for (i = 0; i < 3; i++)
	gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
      break;
    default:
      g_warning("Incorrect ShadeColorMode in call of 'onColorPreSetChange'.");
    }
  ok = shadeGet_colorTransformation(shade, &vectA, &vectB, &vectX);
  if (ok)
    for (i = 0; i < 3; i++)
      {
	if (vectX[i])
	  gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 1);
	else
	  gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[i]), vectA[i]);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[i]), vectB[i]);
      }
  else
    g_warning("Can't get the color transformation parameters.");

  /* ReActivate all combo signals after changes */
  g_signal_handler_unblock(G_OBJECT(radiobuttonDataRGB), signalRadioRGB);
  g_signal_handler_unblock(G_OBJECT(radiobuttonDataHSV), signalRadioHSV);
  for (i = 0; i < 3; i++)
    {
      g_signal_handler_unblock(G_OBJECT(comboboxDataCh[i]), signalComboColumnId[i]);
      g_signal_handler_unblock(G_OBJECT(spinbuttonDataChA[i]), signalSpinDataChA[i]);
      g_signal_handler_unblock(G_OBJECT(spinbuttonDataChB[i]), signalSpinDataChB[i]);
    }

  makeColorPreview(dataObj);

  return TRUE;
}
static void onColorPreSetChange(ShadeComboBox *combo _U_, Shade *values,
				gpointer data _U_)
{
  if (setPresetShade(values) &&
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)))
    {
      visuData_createAllNodes(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)));
      g_idle_add(visuObjectRedraw, (gpointer)0);
    }
}
static void applyHideMinValues(VisuData *visuData, gboolean askRedraw)
{
  gboolean redraw;
  int col;
  double value;

  g_return_if_fail(visuData);

  /* Wants to change the rendered attributes of Nodes, must
     emit the NodeAskForShowHide signal. */
  DBG_fprintf(stderr, "Panel DataFile : emitting 'NodeAskForShowHide' signal.\n");
  g_signal_handler_block(G_OBJECT(visuData), signalAskForHide);
  visuDataEmit_askForShowHideNodes(visuData, &redraw);
  g_signal_handler_unblock(G_OBJECT(visuData), signalAskForHide);
  DBG_fprintf(stderr, " | returned redraw value %d.\n", redraw);

  /* Get the parameters for hiding mode. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) && 
      dataFileGet_used(visuData))
    col = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinHideMinValues)) - 1;
  else
    col = -1;
  value = numericalEntryGet_value(NUMERICAL_ENTRY(entryHideMinValues));

  redraw = dataFileApply_hideOnMinValue(visuData, col, value) || redraw;

  if (redraw)
    {
      visuDataEmit_nodeRenderedChange(visuData);
      if (askRedraw)
	{
	  visuData_createAllNodes(visuData);
	  g_idle_add(visuObjectRedraw, (gpointer)0);
	}
    }
}
static void onCheckHideMinValuesChange(GtkToggleButton *toggle _U_,
				       gpointer data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : toggle check"
	      " button to hide elements.\n");
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onEntryHideMinValuesChange(NumericalEntry *entry,
				       double oldValue _U_, gpointer data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : change value on hide"
	      " min values entry : %f\n", numericalEntryGet_value(entry));
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onSpinHideMinValuesChange(GtkSpinButton *spinbutton,
				      gpointer user_data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : change value of spin column"
	      " for hide function : %f\n", gtk_spin_button_get_value(spinbutton));
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onAskForHideNodes(VisuData *visuData, gboolean *redraw,
			      gpointer data _U_)
{
  int col;
  double val;

  /* No data, useless to stay here. */
  if (!flagDataFileIsLoaded)
    return;

  /* Not in used, can safely go out. */
  if (!dataFileGet_used(visuData))
    return;

  DBG_fprintf(stderr, "Panel DataFile : caught the 'NodeAskForShowHide' signal for"
	      " VisuData %p.\n", (gpointer)visuData);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
    {
      col = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinHideMinValues)) - 1;
      val = numericalEntryGet_value(NUMERICAL_ENTRY(entryHideMinValues));
      *redraw = dataFileApply_hideOnMinValue(visuData, col, val) || *redraw;
    }
}
static gboolean readFileExt(gchar **lines, int nbLines, int position,
			    VisuData *dataObj _U_, GError **error)
{
  g_return_val_if_fail(nbLines == 1, FALSE);

  lines[0] = g_strstrip(lines[0]);

  if (!lines[0][0])
    {
      *error = g_error_new(CONFIG_FILE_ERROR, CONFIG_FILE_ERROR_VALUE,
			   _("Parse error at line %d: 1 string value must appear"
			     " after the %s markup.\n"), position,
			   FLAG_PARAMETER_FILEEXT);
      return FALSE;
    }
  if (fileExt)
    g_free(fileExt);
  fileExt = g_strdup(lines[0]);

  if (entryFileExtension)
    gtk_entry_set_text(GTK_ENTRY(entryFileExtension), fileExt);

  return TRUE;
}
static gboolean exportParameters(GString *data, int *nbLinesWritten,
				 VisuData* dataObj _U_)
{
  g_string_append_printf(data, "# %s\n", DESC_PARAMETER_FILEEXT);
  g_string_append_printf(data, "%s[gtk]: %s\n\n", FLAG_PARAMETER_FILEEXT,
			 fileExt);
  *nbLinesWritten = 3;

  return TRUE;
}
