/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "visu_windowInterface.h"

#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>

#include <visu_tools.h>
#include <support.h>
#include <gtk_renderingWindowWidget.h>
#include <gtk_main.h>


void setObserveEventListener(GenericRenderingWindow window)
{
  renderingWindowSet_observeEventListener(RENDERING_WINDOW(window));
}

void setPickEventListener(GenericRenderingWindow window)
{
  renderingWindowSet_pickEventListener(RENDERING_WINDOW(window));
}

void removeEventListener(GenericRenderingWindow window)
{
  renderingWindowRemove_interactiveEventListener(RENDERING_WINDOW(window));
}
void setInteractiveHandlers(GenericRenderingWindow window, VisuInteractive *inter)
{
  renderingWindowSet_interactiveHandlers(RENDERING_WINDOW(window), inter);
}

int visuRenderingWindowInit(char* windowRef _U_, char* iconRef _U_,
			    char* window_name _U_, char* class_name _U_,
			    int width _U_, int height _U_)
{
  g_warning("Do nothing.");
  return 1;
}

void checkWindowSize(GenericRenderingWindow window, unsigned int *width, unsigned int *height)
{
  renderingWindowGet_openGLAreaSize(RENDERING_WINDOW(window), width, height);
}

void raiseRenderWindow(GenericRenderingWindow window)
{
  gdk_window_raise(GDK_WINDOW(GTK_WIDGET(window)->window));
}

void rename_window(GenericRenderingWindow window, char *nom)
{
  gtk_window_set_title(GTK_WINDOW(window), nom);
}

void visuRenderingWindowGet_backgroundColor(GenericRenderingWindow window, float rgb[3])
{
  GtkStyle *style;

  style = gtk_widget_get_style(GTK_WIDGET(window));
  rgb[0] = (float)style->bg[0].red / 65536.;
  rgb[1] = (float)style->bg[0].green / 65536.;
  rgb[2] = (float)style->bg[0].blue / 65536.;
}

gpointer visuRenderingWindowGet_backgroundImage(GenericRenderingWindow window,
					       guchar **rowData, gboolean *hasAlphaChannel,
					       int *width, int *height)
{
  return (gpointer)renderingWindowGet_backgroundImage(RENDERING_WINDOW(window),
						     rowData, hasAlphaChannel,
						     width, height);
}
void visuRenderingWindowFree_backgroundImage(GenericRenderingWindow window,
					    gpointer image _U_)
{
  renderingWindowFree_backgroundImage(RENDERING_WINDOW(window));
}
GenericRenderingWindow visuRenderingWindowGet_current()
{
  return (GenericRenderingWindow)currentRenderingWindow;
}
void visuRenderingWindowSet_visuData(GenericRenderingWindow window, VisuData *data)
{
  renderingWindowSet_visuData(RENDERING_WINDOW(window), data);
}
VisuData* visuRenderingWindowGet_visuData(GenericRenderingWindow window)
{
  return renderingWindowGet_visuData(RENDERING_WINDOW(window));
}
gboolean visuRenderingWindowDump(GenericRenderingWindow window, DumpType *format,
				 char* fileName, gint width, gint height, GError **error,
				 voidDataFunc functionWait, gpointer data)
{
  return renderingWindowDump(RENDERING_WINDOW(window), format,
			     fileName, width, height, error, functionWait, data);
}
