/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "visu_object.h"

#include <glib.h>

/**
 * SECTION:visu_object
 * @short_description: A general object to store the signals.
 * 
 * <para>At the present time, the signals are global to all V_Sim,
 * owned by a variable include in each parts called visu. This is
 * wherre these signals are defined.</para>
 */

/**
 * VisuObject:
 * @parent: an object to inherit from (NULL here).
 * @privateDt: a pointer to the private data.
 *
 * This structure describes a #VisuObject object.
 */
struct _VisuObject {
	GObject parent;
};

/* All signal emit by visu are handled by this ogbject. */
static GObject *visu;

G_DEFINE_TYPE(VisuObject, visuObject, G_TYPE_OBJECT)

static void visuObject_class_init(VisuObjectClass *klass)
{
  GType paramPointer[1] = {G_TYPE_POINTER};
  GType paramObject[1] = {G_TYPE_OBJECT};
  GType paramGuint[1] = {G_TYPE_UINT};

  DBG_fprintf(stderr, "Visu Object: installing signals.\n");
  klass->signals[COLORNEWAVAILABLE_SIGNAL] = 
    g_signal_newv ("colorNewAvailable",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__POINTER,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramPointer /* pointer to the added color */);

  klass->signals[DATANEW_SIGNAL] = 
    g_signal_newv("dataNew",
		  G_TYPE_FROM_CLASS(klass),
		  G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		  NULL,
		  NULL, 
		  NULL,              
		  g_cclosure_marshal_VOID__OBJECT,
		  G_TYPE_NONE, 1, paramObject);
  klass->signals[DATALOADED_SIGNAL] = 
    g_signal_newv("dataLoaded",
		  G_TYPE_FROM_CLASS(klass),
		  G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		  NULL,
		  NULL, 
		  NULL,              
		  g_cclosure_marshal_VOID__OBJECT,
		  G_TYPE_NONE, 1, paramObject);
  klass->signals[DATAREADYFORRENDERING_SIGNAL] = 
    g_signal_newv ("dataReadyForRendering",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__OBJECT,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramObject  /* param_types */);
  klass->signals[RENDERINGCHANGED_SIGNAL] = 
    g_signal_newv ("renderingChanged",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__POINTER,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramPointer  /* param_types */);
  klass->signals[RESOURCESLOADED_SIGNAL] = 
    g_signal_newv ("resourcesLoaded",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__OBJECT,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramObject  /* param_types */);
  klass->signals[OPENGLASKFORREDRAW_SIGNAL] = 
    g_signal_newv ("OpenGLAskForReDraw",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__VOID,
		   G_TYPE_NONE /* return_type */,
		   0     /* n_params */,
		   NULL  /* param_types */);
  klass->signals[OPENGLFORCEREDRAW_SIGNAL] = 
    g_signal_newv ("OpenGLForceReDraw",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL /* class closure */,
		   NULL /* accumulator */,
		   NULL /* accu_data */,
		   g_cclosure_marshal_VOID__VOID,
		   G_TYPE_NONE /* return_type */,
		   0     /* n_params */,
		   NULL  /* param_types */);

  klass->signals[SPINAXES_SIGNAL] = 
    g_signal_newv ("SpinAxes",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL , NULL, NULL,
		   g_cclosure_marshal_VOID__OBJECT,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramObject  /* param_types */);

  klass->signals[DIR_SIGNAL] = 
    g_signal_newv ("DirectoryChanged",
		   G_TYPE_FROM_CLASS (klass),
		   G_SIGNAL_RUN_LAST | G_SIGNAL_NO_RECURSE | G_SIGNAL_NO_HOOKS,
		   NULL , NULL, NULL,
		   g_cclosure_marshal_VOID__UINT,
		   G_TYPE_NONE /* return_type */,
		   1     /* n_params */,
		   paramGuint  /* param_types */);

  /* Creating the visu object to handle the signals. */
  visu = g_object_new(VISU_TYPE, NULL);
}

static void visuObject_init(VisuObject *obj)
{
  DBG_fprintf(stderr, "Visu Object: creating a new visu (%p).\n", (gpointer)obj);
}

gboolean visuObjectRedraw(gpointer data)
{
  if (GPOINTER_TO_INT(data))
    g_signal_emit(visu, VISU_GET_CLASS(visu)->signals[OPENGLFORCEREDRAW_SIGNAL],
		  0 , NULL);
  else
    g_signal_emit (visu, VISU_GET_CLASS(visu)->signals[OPENGLASKFORREDRAW_SIGNAL],
		   0 /* details */, NULL);
  
  return FALSE;
}

GObject* visuObjectGet_static()
{
  return visu;
}
