/* vala-dbus-binding-tool.c generated by valac, the Vala compiler
 * generated from vala-dbus-binding-tool.vala, do not modify */

/*
 * vala-dbus-binding-tool.vala
 *
 * (C) 2009 by Didier "Ptitjes" <ptitjes@free.fr>
 * (C) 2009-2010 the freesmartphone.org team <smartphones-standards@linuxtogo.org>
 *
 * GPLv3
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>
#include <stdio.h>
#include <libxml/parser.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GENERATED_NAMESPACE (generated_namespace_get_type ())
#define GENERATED_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERATED_NAMESPACE, GeneratedNamespace))
#define GENERATED_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERATED_NAMESPACE, GeneratedNamespaceClass))
#define IS_GENERATED_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERATED_NAMESPACE))
#define IS_GENERATED_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERATED_NAMESPACE))
#define GENERATED_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERATED_NAMESPACE, GeneratedNamespaceClass))

typedef struct _GeneratedNamespace GeneratedNamespace;
typedef struct _GeneratedNamespaceClass GeneratedNamespaceClass;
typedef struct _GeneratedNamespacePrivate GeneratedNamespacePrivate;
#define _generated_namespace_unref0(var) ((var == NULL) ? NULL : (var = (generated_namespace_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecGeneratedNamespace ParamSpecGeneratedNamespace;

#define TYPE_BINDING_GENERATOR (binding_generator_get_type ())
#define BINDING_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING_GENERATOR, BindingGenerator))
#define BINDING_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING_GENERATOR, BindingGeneratorClass))
#define IS_BINDING_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING_GENERATOR))
#define IS_BINDING_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING_GENERATOR))
#define BINDING_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING_GENERATOR, BindingGeneratorClass))

typedef struct _BindingGenerator BindingGenerator;
typedef struct _BindingGeneratorClass BindingGeneratorClass;
typedef struct _BindingGeneratorPrivate BindingGeneratorPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	GENERATOR_ERROR_FILE_NOT_FOUND,
	GENERATOR_ERROR_CANT_CREATE_FILE,
	GENERATOR_ERROR_UNKNOWN_DBUS_TYPE
} GeneratorError;
#define GENERATOR_ERROR generator_error_quark ()
struct _GeneratedNamespace {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeneratedNamespacePrivate * priv;
	GeneratedNamespace* parent;
	char* name;
	GeeMap* members;
	GeeMap* namespaces;
};

struct _GeneratedNamespaceClass {
	GTypeClass parent_class;
	void (*finalize) (GeneratedNamespace *self);
};

struct _ParamSpecGeneratedNamespace {
	GParamSpec parent_instance;
};

struct _BindingGenerator {
	GObject parent_instance;
	BindingGeneratorPrivate * priv;
};

struct _BindingGeneratorClass {
	GObjectClass parent_class;
};

struct _BindingGeneratorPrivate {
	char* output_directory;
	GeeMap* namespace_renaming;
	char* command;
	guint dbus_timeout;
	gboolean inner_interface_strategy_concat;
	FILE* output;
	GeeList* api_docs;
	GeneratedNamespace* root_namespace;
	GeeMap* name_index;
	GeeMap* error_name_index;
	GeeMap* structs_to_generate;
	gint indentSize;
};


static gpointer generated_namespace_parent_class = NULL;
static GeeSet* binding_generator_registered_names;
static GeeSet* binding_generator_registered_names = NULL;
static gint binding_generator_verbosity;
static gint binding_generator_verbosity = 0;
static gint binding_generator_errors;
static gint binding_generator_errors = 0;
static gpointer binding_generator_parent_class = NULL;

GQuark generator_error_quark (void);
gpointer generated_namespace_ref (gpointer instance);
void generated_namespace_unref (gpointer instance);
GParamSpec* param_spec_generated_namespace (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_generated_namespace (GValue* value, gpointer v_object);
void value_take_generated_namespace (GValue* value, gpointer v_object);
gpointer value_get_generated_namespace (const GValue* value);
GType generated_namespace_get_type (void);
enum  {
	GENERATED_NAMESPACE_DUMMY_PROPERTY
};
GeneratedNamespace* generated_namespace_new (void);
GeneratedNamespace* generated_namespace_construct (GType object_type);
static void generated_namespace_finalize (GeneratedNamespace* obj);
GType binding_generator_get_type (void);
#define BINDING_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BINDING_GENERATOR, BindingGeneratorPrivate))
enum  {
	BINDING_GENERATOR_DUMMY_PROPERTY
};
#define BINDING_GENERATOR_FSO_NAMESPACE "http://www.freesmartphone.org/schemas/DBusSpecExtension"
#define BINDING_GENERATOR_INTERFACE_ELTNAME "interface"
#define BINDING_GENERATOR_METHOD_ELTNAME "method"
#define BINDING_GENERATOR_SIGNAL_ELTNAME "signal"
#define BINDING_GENERATOR_ARG_ELTNAME "arg"
#define BINDING_GENERATOR_NAME_ATTRNAME "name"
#define BINDING_GENERATOR_TYPE_ATTRNAME "type"
#define BINDING_GENERATOR_DIRECTION_ATTRNAME "direction"
#define BINDING_GENERATOR_IN_ATTRVALUE "in"
#define BINDING_GENERATOR_OUT_ATTRVALUE "out"
#define BINDING_GENERATOR_ENUMERATION_ELTNAME "enumeration"
#define BINDING_GENERATOR_MEMBER_ELTNAME "member"
#define BINDING_GENERATOR_VALUE_ATTRNAME "value"
#define BINDING_GENERATOR_ERRORDOMAIN_ELTNAME "errordomain"
#define BINDING_GENERATOR_ERROR_ELTNAME "error"
#define BINDING_GENERATOR_NO_CONTAINER_ATTRNAME "no-container"
#define BINDING_GENERATOR_THROWS_ELTNAME "throws"
#define BINDING_GENERATOR_STRUCT_ELTNAME "struct"
#define BINDING_GENERATOR_FIELD_ELTNAME "field"
#define BINDING_GENERATOR_ANNOTATION_ELTNAME "annotation"
void binding_generator_INFO (const char* msg);
void binding_generator_DEBUG (const char* msg);
void binding_generator_ERROR (const char* msg);
static void binding_generator_show_usage (const char* program_name);
static void binding_generator_show_version (void);
void binding_generator_generate (const char* api_path, const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout, GError** error);
gint binding_generator_main (char** args, int args_length1);
static BindingGenerator* binding_generator_new (const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout);
static BindingGenerator* binding_generator_construct (GType object_type, const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout);
static void binding_generator_generate_bindings (BindingGenerator* self, const char* api_path, GError** error);
static void binding_generator_add_api_file (BindingGenerator* self, const char* api_file, GError** error);
static void binding_generator_index_names (BindingGenerator* self, GeneratedNamespace* ns);
static void binding_generator_generate_namespace (BindingGenerator* self, GeneratedNamespace* ns, GError** error);
static void binding_generator_preprocess_binding_names (BindingGenerator* self, xmlDoc* api_doc);
static void binding_generator_create_binding_file (BindingGenerator* self, const char* name, GError** error);
static char** binding_generator_get_namespace_path (BindingGenerator* self, GeneratedNamespace* ns, int* result_length1);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
static void _vala_array_add2 (char*** array, int* length, int* size, char* value);
static char* binding_generator_get_indent (BindingGenerator* self, gint offset);
static void binding_generator_update_indent (BindingGenerator* self, gint increment);
static void binding_generator_generate_interface (BindingGenerator* self, const char* interface_name, xmlNode* node, GError** error);
static void binding_generator_generate_proxy_getter (BindingGenerator* self, xmlNode* node, const char* interface_name, GError** error);
static void binding_generator_generate_enumeration (BindingGenerator* self, const char* enumeration_name, xmlNode* node, GError** error);
static void binding_generator_generate_errordomain (BindingGenerator* self, const char* errordomain_name, xmlNode* node, GError** error);
static void binding_generator_generate_explicit_struct (BindingGenerator* self, const char* struct_name, xmlNode* node, GError** error);
static char* binding_generator_get_namespace_name (BindingGenerator* self, const char* interface_name);
static void binding_generator_generate_members (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error);
static void binding_generator_generate_struct (BindingGenerator* self, const char* name, const char* content_signature, const char* dbus_namespace, GError** error);
static char* binding_generator_normalized_to_upper_case (BindingGenerator* self, const char* name);
static char* binding_generator_camel_case_to_upper_case (BindingGenerator* self, const char* name);
static char* binding_generator_transform_registered_name (BindingGenerator* self, const char* name);
static char* binding_generator_translate_type (BindingGenerator* self, const char* type, const char* fso_type, const char* type_name, const char* dbus_namespace, GError** error);
static char* binding_generator_parse_type (BindingGenerator* self, const char* type, char** tail, const char* type_name, const char* dbus_namespace, GError** error);
static void binding_generator_generate_method (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error);
static void binding_generator_generate_signal (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error);
static void binding_generator_generate_error (BindingGenerator* self, xmlNode* node, const char* interface_name, GError** error);
static char* binding_generator_uncapitalize (BindingGenerator* self, const char* name);
static gint binding_generator_get_out_parameter_count (BindingGenerator* self, xmlNode* node);
static char* binding_generator_get_struct_name (BindingGenerator* self, const char* interface_name, const char* param_name);
static char* binding_generator_capitalize (BindingGenerator* self, const char* type_name);
static char* binding_generator_get_subsignature (BindingGenerator* self, const char* s, gchar start, gchar end, char** tail);
static char* binding_generator_plural_to_singular (BindingGenerator* self, const char* type_name);
static char* binding_generator_strip_namespace (BindingGenerator* self, const char* interface_name);
static void binding_generator_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark generator_error_quark (void) {
	return g_quark_from_static_string ("generator_error-quark");
}


GeneratedNamespace* generated_namespace_construct (GType object_type) {
	GeneratedNamespace* self;
	self = (GeneratedNamespace*) g_type_create_instance (object_type);
	return self;
}


GeneratedNamespace* generated_namespace_new (void) {
	return generated_namespace_construct (TYPE_GENERATED_NAMESPACE);
}


static void value_generated_namespace_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_generated_namespace_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		generated_namespace_unref (value->data[0].v_pointer);
	}
}


static void value_generated_namespace_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = generated_namespace_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_generated_namespace_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_generated_namespace_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeneratedNamespace* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = generated_namespace_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_generated_namespace_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeneratedNamespace** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = generated_namespace_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_generated_namespace (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGeneratedNamespace* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GENERATED_NAMESPACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_generated_namespace (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE), NULL);
	return value->data[0].v_pointer;
}


void value_set_generated_namespace (GValue* value, gpointer v_object) {
	GeneratedNamespace* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GENERATED_NAMESPACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		generated_namespace_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		generated_namespace_unref (old);
	}
}


void value_take_generated_namespace (GValue* value, gpointer v_object) {
	GeneratedNamespace* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GENERATED_NAMESPACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GENERATED_NAMESPACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		generated_namespace_unref (old);
	}
}


static void generated_namespace_class_init (GeneratedNamespaceClass * klass) {
	generated_namespace_parent_class = g_type_class_peek_parent (klass);
	GENERATED_NAMESPACE_CLASS (klass)->finalize = generated_namespace_finalize;
}


static void generated_namespace_instance_init (GeneratedNamespace * self) {
	self->members = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	self->namespaces = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_GENERATED_NAMESPACE, (GBoxedCopyFunc) generated_namespace_ref, generated_namespace_unref, g_str_hash, g_str_equal, g_direct_equal);
	self->ref_count = 1;
}


static void generated_namespace_finalize (GeneratedNamespace* obj) {
	GeneratedNamespace * self;
	self = GENERATED_NAMESPACE (obj);
	_generated_namespace_unref0 (self->parent);
	_g_free0 (self->name);
	_g_object_unref0 (self->members);
	_g_object_unref0 (self->namespaces);
}


GType generated_namespace_get_type (void) {
	static volatile gsize generated_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&generated_namespace_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_generated_namespace_init, value_generated_namespace_free_value, value_generated_namespace_copy_value, value_generated_namespace_peek_pointer, "p", value_generated_namespace_collect_value, "p", value_generated_namespace_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeneratedNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generated_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeneratedNamespace), 0, (GInstanceInitFunc) generated_namespace_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType generated_namespace_type_id;
		generated_namespace_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeneratedNamespace", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&generated_namespace_type_id__volatile, generated_namespace_type_id);
	}
	return generated_namespace_type_id__volatile;
}


gpointer generated_namespace_ref (gpointer instance) {
	GeneratedNamespace* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void generated_namespace_unref (gpointer instance) {
	GeneratedNamespace* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GENERATED_NAMESPACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void binding_generator_INFO (const char* msg) {
	g_return_if_fail (msg != NULL);
	if (binding_generator_verbosity >= 1) {
		char* _tmp0_;
		fprintf (stdout, "%s", _tmp0_ = g_strconcat ("[INFO]  ", string_to_string (msg), "\n", NULL));
		_g_free0 (_tmp0_);
	}
}


void binding_generator_DEBUG (const char* msg) {
	g_return_if_fail (msg != NULL);
	if (binding_generator_verbosity >= 2) {
		char* _tmp0_;
		fprintf (stdout, "%s", _tmp0_ = g_strconcat ("[DEBUG] ", string_to_string (msg), "\n", NULL));
		_g_free0 (_tmp0_);
	}
}


void binding_generator_ERROR (const char* msg) {
	char* _tmp0_;
	g_return_if_fail (msg != NULL);
	fprintf (stderr, "%s", _tmp0_ = g_strconcat ("[ERROR] ", string_to_string (msg), "\n", NULL));
	_g_free0 (_tmp0_);
	binding_generator_errors++;
}


gint binding_generator_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_;
	char** _tmp1_;
	gint _split_name_size_;
	gint split_name_length1;
	char** _tmp0_;
	char** split_name;
	char* program_name;
	char* command;
	char* api_path;
	char* output_directory;
	guint dbus_timeout;
	GeeMap* namespace_renaming;
	_inner_error_ = NULL;
	split_name = (_tmp1_ = _tmp0_ = g_strsplit (args[0], "/", 0), split_name_length1 = _vala_array_length (_tmp0_), _split_name_size_ = split_name_length1, _tmp1_);
	program_name = g_strdup (split_name[split_name_length1 - 1]);
	command = g_strjoinv (" ", args);
	api_path = NULL;
	output_directory = NULL;
	dbus_timeout = (guint) 120000;
	namespace_renaming = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				char* arg;
				char** _tmp4_;
				gint _split_arg_size_;
				gint split_arg_length1;
				char** _tmp3_;
				char** split_arg;
				GQuark _tmp10_;
				const char* _tmp9_;
				static GQuark _tmp10__label0 = 0;
				static GQuark _tmp10__label1 = 0;
				static GQuark _tmp10__label2 = 0;
				static GQuark _tmp10__label3 = 0;
				static GQuark _tmp10__label4 = 0;
				static GQuark _tmp10__label5 = 0;
				static GQuark _tmp10__label6 = 0;
				static GQuark _tmp10__label7 = 0;
				static GQuark _tmp10__label8 = 0;
				static GQuark _tmp10__label9 = 0;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				arg = g_strdup (args[i]);
				split_arg = (_tmp4_ = _tmp3_ = g_strsplit (arg, "=", 0), split_arg_length1 = _vala_array_length (_tmp3_), _split_arg_size_ = split_arg_length1, _tmp4_);
				_tmp9_ = split_arg[0];
				_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if ((_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("-h")))) || (_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("--help")))))
				switch (0) {
					default:
					{
						binding_generator_show_usage (program_name);
						result = 0;
						_g_free0 (arg);
						split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
						split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (program_name);
						_g_free0 (command);
						_g_free0 (api_path);
						_g_free0 (output_directory);
						_g_object_unref0 (namespace_renaming);
						return result;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("-v"))))
				switch (0) {
					default:
					{
						binding_generator_verbosity++;
						break;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("--version"))))
				switch (0) {
					default:
					{
						binding_generator_show_version ();
						result = 0;
						_g_free0 (arg);
						split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
						split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (program_name);
						_g_free0 (command);
						_g_free0 (api_path);
						_g_free0 (output_directory);
						_g_object_unref0 (namespace_renaming);
						return result;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label4) ? _tmp10__label4 : (_tmp10__label4 = g_quark_from_static_string ("--api-path"))))
				switch (0) {
					default:
					{
						char* _tmp5_;
						api_path = (_tmp5_ = g_strdup (split_arg[1]), _g_free0 (api_path), _tmp5_);
						break;
					}
				} else if ((_tmp10_ == ((0 != _tmp10__label5) ? _tmp10__label5 : (_tmp10__label5 = g_quark_from_static_string ("-d")))) || (_tmp10_ == ((0 != _tmp10__label6) ? _tmp10__label6 : (_tmp10__label6 = g_quark_from_static_string ("--directory")))))
				switch (0) {
					default:
					{
						char* _tmp6_;
						output_directory = (_tmp6_ = g_strdup (split_arg[1]), _g_free0 (output_directory), _tmp6_);
						break;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label7) ? _tmp10__label7 : (_tmp10__label7 = g_quark_from_static_string ("--strip-namespace"))))
				switch (0) {
					default:
					{
						gee_map_set (namespace_renaming, split_arg[1], "");
						break;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label8) ? _tmp10__label8 : (_tmp10__label8 = g_quark_from_static_string ("--rename-namespace"))))
				switch (0) {
					default:
					{
						char** _tmp8_;
						gint _ns_split_size_;
						gint ns_split_length1;
						char** _tmp7_;
						char** ns_split;
						ns_split = (_tmp8_ = _tmp7_ = g_strsplit (split_arg[1], ":", 0), ns_split_length1 = _vala_array_length (_tmp7_), _ns_split_size_ = ns_split_length1, _tmp8_);
						gee_map_set (namespace_renaming, ns_split[0], ns_split[1]);
						ns_split = (_vala_array_free (ns_split, ns_split_length1, (GDestroyNotify) g_free), NULL);
						break;
					}
				} else if (_tmp10_ == ((0 != _tmp10__label9) ? _tmp10__label9 : (_tmp10__label9 = g_quark_from_static_string ("--dbus-timeout"))))
				switch (0) {
					default:
					{
						dbus_timeout = (guint) atoi (split_arg[1]);
						break;
					}
				} else
				switch (0) {
					default:
					{
						fprintf (stdout, "%s: Unknown option %s\n", program_name, arg);
						binding_generator_show_usage (program_name);
						result = 1;
						_g_free0 (arg);
						split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
						split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (program_name);
						_g_free0 (command);
						_g_free0 (api_path);
						_g_free0 (output_directory);
						_g_object_unref0 (namespace_renaming);
						return result;
					}
				}
				_g_free0 (arg);
				split_arg = (_vala_array_free (split_arg, split_arg_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (api_path == NULL) {
		char* _tmp11_;
		api_path = (_tmp11_ = g_strdup ("./"), _g_free0 (api_path), _tmp11_);
	}
	if (output_directory == NULL) {
		char* _tmp12_;
		output_directory = (_tmp12_ = g_strdup ("."), _g_free0 (output_directory), _tmp12_);
	}
	{
		binding_generator_generate (api_path, output_directory, namespace_renaming, command, dbus_timeout, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error_->domain == GENERATOR_ERROR) {
				goto __catch0_generator_error;
			}
			split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (program_name);
			_g_free0 (command);
			_g_free0 (api_path);
			_g_free0 (output_directory);
			_g_object_unref0 (namespace_renaming);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError * ex;
		ex = _inner_error_;
		_inner_error_ = NULL;
		{
			binding_generator_ERROR (ex->message);
			result = 1;
			_g_error_free0 (ex);
			split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (program_name);
			_g_free0 (command);
			_g_free0 (api_path);
			_g_free0 (output_directory);
			_g_object_unref0 (namespace_renaming);
			return result;
		}
	}
	goto __finally0;
	__catch0_generator_error:
	{
		GError * ex;
		ex = _inner_error_;
		_inner_error_ = NULL;
		{
			binding_generator_ERROR (ex->message);
			result = 1;
			_g_error_free0 (ex);
			split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (program_name);
			_g_free0 (command);
			_g_free0 (api_path);
			_g_free0 (output_directory);
			_g_object_unref0 (namespace_renaming);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (program_name);
		_g_free0 (command);
		_g_free0 (api_path);
		_g_free0 (output_directory);
		_g_object_unref0 (namespace_renaming);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (binding_generator_errors > 0) {
		char* _tmp14_;
		char* _tmp13_;
		fprintf (stdout, "%s", _tmp14_ = g_strconcat ("\n", _tmp13_ = g_strdup_printf ("%i", binding_generator_errors), " errors detected in API files. The generated files will not be usable." \
"\n", NULL));
		_g_free0 (_tmp14_);
		_g_free0 (_tmp13_);
		result = 1;
		split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (program_name);
		_g_free0 (command);
		_g_free0 (api_path);
		_g_free0 (output_directory);
		_g_object_unref0 (namespace_renaming);
		return result;
	}
	result = 0;
	split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (program_name);
	_g_free0 (command);
	_g_free0 (api_path);
	_g_free0 (output_directory);
	_g_object_unref0 (namespace_renaming);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return binding_generator_main (argv, argc);
}


static void binding_generator_show_version (void) {
	char* _tmp0_;
	fprintf (stdout, "%s", _tmp0_ = g_strconcat ("Vala D-Bus Binding Tool ", string_to_string (PACKAGE_VERSION), "\n", NULL));
	_g_free0 (_tmp0_);
	fprintf (stdout, "Written by Didier \"Ptitjes\" and the freesmartphone.org team\n");
	fprintf (stdout, "This is free software; see the source for copying conditions.\n");
	fprintf (stdout, "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PA" \
"RTICULAR PURPOSE.\n");
}


static void binding_generator_show_usage (const char* program_name) {
	g_return_if_fail (program_name != NULL);
	fprintf (stdout, "Usage:\n");
	fprintf (stdout, "  %s [-v] [--version] [--help]\n", program_name);
	fprintf (stdout, "  %s [--api-path=PATH] [--dbus-timeout=TIMEOUT] [--directory=DIR] [--s" \
"trip-namespace=NS]* [--rename-namespace=OLD_NS:NEW_NS]*\n", program_name);
}


void binding_generator_generate (const char* api_path, const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout, GError** error) {
	GError * _inner_error_;
	BindingGenerator* generator;
	g_return_if_fail (api_path != NULL);
	g_return_if_fail (output_directory != NULL);
	g_return_if_fail (namespace_renaming != NULL);
	g_return_if_fail (command != NULL);
	_inner_error_ = NULL;
	xmlInitParser ();
	generator = binding_generator_new (output_directory, namespace_renaming, command, dbus_timeout);
	binding_generator_generate_bindings (generator, api_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (generator);
			return;
		} else {
			_g_object_unref0 (generator);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	xmlCleanupParser ();
	_g_object_unref0 (generator);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BindingGenerator* binding_generator_construct (GType object_type, const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout) {
	BindingGenerator * self;
	char* _tmp0_;
	GeeMap* _tmp1_;
	char* _tmp2_;
	g_return_val_if_fail (output_directory != NULL, NULL);
	g_return_val_if_fail (namespace_renaming != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	self = (BindingGenerator*) g_object_new (object_type, NULL);
	self->priv->output_directory = (_tmp0_ = g_strdup (output_directory), _g_free0 (self->priv->output_directory), _tmp0_);
	self->priv->namespace_renaming = (_tmp1_ = _g_object_ref0 (namespace_renaming), _g_object_unref0 (self->priv->namespace_renaming), _tmp1_);
	self->priv->command = (_tmp2_ = g_strdup (command), _g_free0 (self->priv->command), _tmp2_);
	self->priv->dbus_timeout = dbus_timeout;
	return self;
}


static BindingGenerator* binding_generator_new (const char* output_directory, GeeMap* namespace_renaming, const char* command, guint dbus_timeout) {
	return binding_generator_construct (TYPE_BINDING_GENERATOR, output_directory, namespace_renaming, command, dbus_timeout);
}


static void binding_generator_generate_bindings (BindingGenerator* self, const char* api_path, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (api_path != NULL);
	_inner_error_ = NULL;
	if (g_str_has_suffix (api_path, ".xml")) {
		binding_generator_add_api_file (self, api_path, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GDir* dir;
		char* name;
		dir = g_dir_open (api_path, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		name = NULL;
		while (TRUE) {
			char* _tmp0_;
			if (!((name = (_tmp0_ = g_strdup (g_dir_read_name (dir)), _g_free0 (name), _tmp0_)) != NULL)) {
				break;
			}
			if (g_str_has_suffix (name, ".xml")) {
				char* _tmp1_;
				binding_generator_add_api_file (self, _tmp1_ = g_build_filename (api_path, name, NULL), &_inner_error_);
				_g_free0 (_tmp1_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_dir_close0 (dir);
						_g_free0 (name);
						return;
					} else {
						_g_dir_close0 (dir);
						_g_free0 (name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_dir_close0 (dir);
		_g_free0 (name);
	}
	binding_generator_index_names (self, self->priv->root_namespace);
	binding_generator_generate_namespace (self, self->priv->root_namespace, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GENERATOR_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void binding_generator_add_api_file (BindingGenerator* self, const char* api_file, GError** error) {
	GError * _inner_error_;
	char* _tmp0_;
	xmlDoc* api_doc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (api_file != NULL);
	_inner_error_ = NULL;
	binding_generator_INFO (_tmp0_ = g_strconcat ("Adding API file ", string_to_string (api_file), NULL));
	_g_free0 (_tmp0_);
	api_doc = xmlParseFile (api_file);
	if (api_doc == NULL) {
		_inner_error_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_FILE_NOT_FOUND, api_file);
		{
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gee_collection_add ((GeeCollection*) self->priv->api_docs, api_doc);
	binding_generator_preprocess_binding_names (self, api_doc);
}


static void binding_generator_create_binding_file (BindingGenerator* self, const char* name, GError** error) {
	GError * _inner_error_;
	FILE* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_inner_error_ = NULL;
	self->priv->output = (_tmp0_ = fopen (name, "w"), _fclose0 (self->priv->output), _tmp0_);
	if (self->priv->output == NULL) {
		_inner_error_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_CANT_CREATE_FILE, name);
		{
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	fprintf (self->priv->output, "%s", _tmp1_ = g_strconcat ("/* Generated by vala-dbus-binding-tool ", string_to_string (PACKAGE_VERSION), ". Do not modify! */\n", NULL));
	_g_free0 (_tmp1_);
	fprintf (self->priv->output, "%s", _tmp2_ = g_strconcat ("/* Generated with: ", string_to_string (self->priv->command), " */\n", NULL));
	_g_free0 (_tmp2_);
	fprintf (self->priv->output, "using DBus;\n");
	fprintf (self->priv->output, "using GLib;\n");
}


static gpointer _generated_namespace_ref0 (gpointer self) {
	return self ? generated_namespace_ref (self) : NULL;
}


static void binding_generator_preprocess_binding_names (BindingGenerator* self, xmlDoc* api_doc) {
	g_return_if_fail (self != NULL);
	{
		xmlNode* iter;
		iter = xmlDocGetRootElement (api_doc)->children;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* _tmp2_;
				char* _tmp1_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				char* no_error_container_string;
				gboolean _tmp6_ = FALSE;
				gboolean no_error_container;
				char* dbus_interface_name;
				char** _tmp8_;
				gint _split_name_size_;
				gint split_name_length1;
				char** _tmp7_;
				char** split_name;
				char* short_name;
				gint last_part = 0;
				gboolean _tmp9_ = FALSE;
				gint i;
				GeneratedNamespace* ns;
				char* interface_name;
				if (!_tmp0_) {
					iter = iter->next;
				}
				_tmp0_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				binding_generator_DEBUG (_tmp2_ = g_strdup_printf (_tmp1_ = g_strconcat ("   Processing ", string_to_string (iter->name), " as type %d", NULL), iter->type));
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				if (iter->type != XML_ELEMENT_NODE) {
					binding_generator_DEBUG ("      not a node; continuing");
					continue;
				}
				if (_vala_strcmp0 (iter->name, BINDING_GENERATOR_INTERFACE_ELTNAME) != 0) {
					_tmp5_ = _vala_strcmp0 (iter->name, BINDING_GENERATOR_ENUMERATION_ELTNAME) != 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_tmp4_ = _vala_strcmp0 (iter->name, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) != 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_tmp3_ = _vala_strcmp0 (iter->name, BINDING_GENERATOR_STRUCT_ELTNAME) != 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					binding_generator_DEBUG ("      not interface or enumeration or errordomain or struct; continuin" \
"g");
					continue;
				}
				no_error_container_string = xmlGetNsProp (iter, BINDING_GENERATOR_NO_CONTAINER_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE);
				if (no_error_container_string != NULL) {
					_tmp6_ = _vala_strcmp0 (no_error_container_string, "true") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				no_error_container = _tmp6_;
				dbus_interface_name = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME);
				split_name = (_tmp8_ = _tmp7_ = g_strsplit (dbus_interface_name, ".", 0), split_name_length1 = _vala_array_length (_tmp7_), _split_name_size_ = split_name_length1, _tmp8_);
				short_name = NULL;
				if (_vala_strcmp0 (iter->name, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) == 0) {
					_tmp9_ = no_error_container;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					char* _tmp10_;
					short_name = (_tmp10_ = g_strdup ("Error"), _g_free0 (short_name), _tmp10_);
					last_part = split_name_length1;
				} else {
					char* _tmp11_;
					short_name = (_tmp11_ = g_strdup (split_name[split_name_length1 - 1]), _g_free0 (short_name), _tmp11_);
					last_part = split_name_length1 - 1;
				}
				i = 0;
				{
					gboolean _tmp12_;
					_tmp12_ = TRUE;
					while (TRUE) {
						char* part;
						char* _tmp13_;
						gboolean _tmp14_;
						if (!_tmp12_) {
							i++;
						}
						_tmp12_ = FALSE;
						if (!(i < last_part)) {
							break;
						}
						part = g_strdup (split_name[i]);
						if ((_tmp14_ = _vala_strcmp0 (_tmp13_ = (char*) gee_map_get (self->priv->namespace_renaming, part), "") != 0, _g_free0 (_tmp13_), _tmp14_)) {
							_g_free0 (part);
							break;
						}
						_g_free0 (part);
					}
				}
				ns = _generated_namespace_ref0 (self->priv->root_namespace);
				{
					gboolean _tmp15_;
					_tmp15_ = TRUE;
					while (TRUE) {
						char* part;
						gboolean _tmp16_ = FALSE;
						gboolean _tmp19_ = FALSE;
						GeneratedNamespace* child;
						GeneratedNamespace* _tmp28_;
						if (!_tmp15_) {
							i++;
						}
						_tmp15_ = FALSE;
						if (!(i < last_part)) {
							break;
						}
						part = g_strdup (split_name[i]);
						if (gee_map_contains (self->priv->namespace_renaming, part)) {
							char* _tmp17_;
							_tmp16_ = _vala_strcmp0 (_tmp17_ = (char*) gee_map_get (self->priv->namespace_renaming, part), "") != 0;
							_g_free0 (_tmp17_);
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							char* _tmp18_;
							part = (_tmp18_ = (char*) gee_map_get (self->priv->namespace_renaming, part), _g_free0 (part), _tmp18_);
						}
						if (gee_map_contains (ns->members, part)) {
							_tmp19_ = self->priv->inner_interface_strategy_concat;
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							if (gee_map_contains (ns->namespaces, part)) {
								GeneratedNamespace* child;
								GeneratedNamespace* _tmp23_;
								child = (GeneratedNamespace*) gee_map_get (ns->namespaces, part);
								{
									GeeSet* _tmp20_;
									GeeIterator* _tmp21_;
									GeeIterator* _interf_name_it;
									_interf_name_it = (_tmp21_ = gee_iterable_iterator ((GeeIterable*) (_tmp20_ = gee_map_get_keys (child->members))), _g_object_unref0 (_tmp20_), _tmp21_);
									while (TRUE) {
										char* interf_name;
										xmlNode* interf;
										char* _tmp22_;
										if (!gee_iterator_next (_interf_name_it)) {
											break;
										}
										interf_name = (char*) gee_iterator_get (_interf_name_it);
										interf = gee_map_get (child->members, interf_name);
										gee_map_set (ns->members, _tmp22_ = g_strconcat (part, interf_name, NULL), interf);
										_g_free0 (_tmp22_);
										_g_free0 (interf_name);
									}
									_g_object_unref0 (_interf_name_it);
								}
								gee_map_remove (ns->namespaces, part, NULL);
								child->parent = (_tmp23_ = NULL, _generated_namespace_unref0 (child->parent), _tmp23_);
								_generated_namespace_unref0 (child);
							}
							_g_free0 (part);
							break;
						}
						child = NULL;
						if (gee_map_contains (ns->namespaces, part)) {
							GeneratedNamespace* _tmp24_;
							child = (_tmp24_ = (GeneratedNamespace*) gee_map_get (ns->namespaces, part), _generated_namespace_unref0 (child), _tmp24_);
						} else {
							GeneratedNamespace* _tmp25_;
							GeneratedNamespace* _tmp26_;
							char* _tmp27_;
							child = (_tmp25_ = generated_namespace_new (), _generated_namespace_unref0 (child), _tmp25_);
							child->parent = (_tmp26_ = _generated_namespace_ref0 (ns), _generated_namespace_unref0 (child->parent), _tmp26_);
							child->name = (_tmp27_ = g_strdup (part), _g_free0 (child->name), _tmp27_);
							gee_map_set (ns->namespaces, part, child);
						}
						if (gee_map_contains (ns->members, part)) {
							gee_map_set (child->members, part, gee_map_get (ns->members, part));
							gee_map_remove (ns->members, part, NULL);
						}
						ns = (_tmp28_ = _generated_namespace_ref0 (child), _generated_namespace_unref0 (ns), _tmp28_);
						_g_free0 (part);
						_generated_namespace_unref0 (child);
					}
				}
				interface_name = NULL;
				if (self->priv->inner_interface_strategy_concat) {
					GString* name_builder;
					char* _tmp30_;
					name_builder = g_string_new ("");
					{
						gboolean _tmp29_;
						_tmp29_ = TRUE;
						while (TRUE) {
							if (!_tmp29_) {
								i++;
							}
							_tmp29_ = FALSE;
							if (!(i < last_part)) {
								break;
							}
							g_string_append (name_builder, split_name[i]);
						}
					}
					g_string_append (name_builder, short_name);
					interface_name = (_tmp30_ = g_strdup (name_builder->str), _g_free0 (interface_name), _tmp30_);
					if (gee_map_contains (ns->namespaces, short_name)) {
						GeneratedNamespace* child;
						GeneratedNamespace* _tmp34_;
						child = (GeneratedNamespace*) gee_map_get (ns->namespaces, short_name);
						{
							GeeSet* _tmp31_;
							GeeIterator* _tmp32_;
							GeeIterator* _interf_name_it;
							_interf_name_it = (_tmp32_ = gee_iterable_iterator ((GeeIterable*) (_tmp31_ = gee_map_get_keys (child->members))), _g_object_unref0 (_tmp31_), _tmp32_);
							while (TRUE) {
								char* interf_name;
								xmlNode* interf;
								char* _tmp33_;
								if (!gee_iterator_next (_interf_name_it)) {
									break;
								}
								interf_name = (char*) gee_iterator_get (_interf_name_it);
								interf = gee_map_get (child->members, interf_name);
								gee_map_set (ns->members, _tmp33_ = g_strconcat (short_name, interf_name, NULL), interf);
								_g_free0 (_tmp33_);
								_g_free0 (interf_name);
							}
							_g_object_unref0 (_interf_name_it);
						}
						gee_map_remove (ns->namespaces, short_name, NULL);
						child->parent = (_tmp34_ = NULL, _generated_namespace_unref0 (child->parent), _tmp34_);
						_generated_namespace_unref0 (child);
					}
					_g_string_free0 (name_builder);
				} else {
					char* _tmp36_;
					if (gee_map_contains (ns->namespaces, short_name)) {
						GeneratedNamespace* _tmp35_;
						ns = (_tmp35_ = (GeneratedNamespace*) gee_map_get (ns->namespaces, short_name), _generated_namespace_unref0 (ns), _tmp35_);
					}
					interface_name = (_tmp36_ = g_strdup (short_name), _g_free0 (interface_name), _tmp36_);
				}
				if (!gee_map_contains (ns->members, interface_name)) {
					gee_map_set (ns->members, interface_name, iter);
				} else {
					xmlNode* iter2;
					char* name;
					char* _tmp37_;
					iter2 = gee_map_get (ns->members, interface_name);
					name = xmlGetProp (iter2, BINDING_GENERATOR_NAME_ATTRNAME);
					binding_generator_ERROR (_tmp37_ = g_strconcat (string_to_string (interface_name), " has been added already as namespace ", string_to_string (name), NULL));
					_g_free0 (_tmp37_);
					_g_free0 (name);
				}
				_g_free0 (no_error_container_string);
				_g_free0 (dbus_interface_name);
				split_name = (_vala_array_free (split_name, split_name_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (short_name);
				_generated_namespace_unref0 (ns);
				_g_free0 (interface_name);
			}
		}
	}
}


static void binding_generator_index_names (BindingGenerator* self, GeneratedNamespace* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	if (gee_map_get_size (ns->members) > 0) {
		gint _tmp1__length1;
		char** _tmp1_;
		gint _tmp0_;
		char* _tmp2_;
		char* namespace_name;
		namespace_name = (_tmp2_ = g_strjoinv (".", (_tmp1_ = binding_generator_get_namespace_path (self, ns, &_tmp0_), _tmp1__length1 = _tmp0_, _tmp1_)), _tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL), _tmp2_);
		{
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _name_it;
			_name_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = gee_map_get_keys (ns->members))), _g_object_unref0 (_tmp3_), _tmp4_);
			while (TRUE) {
				char* name;
				xmlNode* api;
				char* dbus_name;
				if (!gee_iterator_next (_name_it)) {
					break;
				}
				name = (char*) gee_iterator_get (_name_it);
				api = gee_map_get (ns->members, name);
				dbus_name = xmlGetProp (api, BINDING_GENERATOR_NAME_ATTRNAME);
				if (_vala_strcmp0 (api->name, BINDING_GENERATOR_ERRORDOMAIN_ELTNAME) == 0) {
					char* _tmp5_;
					char* _tmp7_;
					char* _tmp6_;
					binding_generator_INFO (_tmp5_ = g_strconcat ("Registering new errordomain ", string_to_string (dbus_name), NULL));
					_g_free0 (_tmp5_);
					gee_map_set (self->priv->error_name_index, dbus_name, _tmp7_ = g_strconcat (_tmp6_ = g_strconcat (namespace_name, ".", NULL), name, NULL));
					_g_free0 (_tmp7_);
					_g_free0 (_tmp6_);
				} else {
					char* _tmp9_;
					char* _tmp8_;
					gee_map_set (self->priv->name_index, dbus_name, _tmp9_ = g_strconcat (_tmp8_ = g_strconcat (namespace_name, ".", NULL), name, NULL));
					_g_free0 (_tmp9_);
					_g_free0 (_tmp8_);
				}
				_g_free0 (name);
				_g_free0 (dbus_name);
			}
			_g_object_unref0 (_name_it);
		}
		_g_free0 (namespace_name);
	}
	{
		GeeSet* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _name_it;
		_name_it = (_tmp11_ = gee_iterable_iterator ((GeeIterable*) (_tmp10_ = gee_map_get_keys (ns->namespaces))), _g_object_unref0 (_tmp10_), _tmp11_);
		while (TRUE) {
			char* name;
			GeneratedNamespace* child;
			if (!gee_iterator_next (_name_it)) {
				break;
			}
			name = (char*) gee_iterator_get (_name_it);
			child = (GeneratedNamespace*) gee_map_get (ns->namespaces, name);
			binding_generator_index_names (self, child);
			_g_free0 (name);
			_generated_namespace_unref0 (child);
		}
		_g_object_unref0 (_name_it);
	}
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static char** binding_generator_get_namespace_path (BindingGenerator* self, GeneratedNamespace* ns, int* result_length1) {
	char** result = NULL;
	char** _tmp0_;
	gint _reversed_namespace_names_size_;
	gint reversed_namespace_names_length1;
	char** reversed_namespace_names;
	GeneratedNamespace* a_namespace;
	char** _tmp2_;
	gint _namespace_names_size_;
	gint namespace_names_length1;
	char** namespace_names;
	char** _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	reversed_namespace_names = (_tmp0_ = g_new0 (char*, 0 + 1), reversed_namespace_names_length1 = 0, _reversed_namespace_names_size_ = reversed_namespace_names_length1, _tmp0_);
	a_namespace = _generated_namespace_ref0 (ns);
	while (TRUE) {
		GeneratedNamespace* _tmp1_;
		if (!(a_namespace->name != NULL)) {
			break;
		}
		_vala_array_add1 (&reversed_namespace_names, &reversed_namespace_names_length1, &_reversed_namespace_names_size_, g_strdup (a_namespace->name));
		a_namespace = (_tmp1_ = _generated_namespace_ref0 (a_namespace->parent), _generated_namespace_unref0 (a_namespace), _tmp1_);
	}
	namespace_names = (_tmp2_ = g_new0 (char*, 0 + 1), namespace_names_length1 = 0, _namespace_names_size_ = namespace_names_length1, _tmp2_);
	{
		gint i;
		i = reversed_namespace_names_length1 - 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					i--;
				}
				_tmp3_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_vala_array_add2 (&namespace_names, &namespace_names_length1, &_namespace_names_size_, g_strdup (reversed_namespace_names[i]));
			}
		}
	}
	result = (_tmp4_ = namespace_names, *result_length1 = namespace_names_length1, _tmp4_);
	reversed_namespace_names = (_vala_array_free (reversed_namespace_names, reversed_namespace_names_length1, (GDestroyNotify) g_free), NULL);
	_generated_namespace_unref0 (a_namespace);
	return result;
	reversed_namespace_names = (_vala_array_free (reversed_namespace_names, reversed_namespace_names_length1, (GDestroyNotify) g_free), NULL);
	_generated_namespace_unref0 (a_namespace);
	namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
}


static void binding_generator_generate_namespace (BindingGenerator* self, GeneratedNamespace* ns, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_inner_error_ = NULL;
	if (gee_map_get_size (ns->members) > 0) {
		char** _tmp1_;
		gint _namespace_names_size_;
		gint namespace_names_length1;
		gint _tmp0_;
		char** namespace_names;
		char* _tmp6_;
		char* _tmp5_;
		char* _tmp4_;
		char* _tmp3_;
		char* _tmp2_;
		FILE* _tmp13_;
		namespace_names = (_tmp1_ = binding_generator_get_namespace_path (self, ns, &_tmp0_), namespace_names_length1 = _tmp0_, _namespace_names_size_ = namespace_names_length1, _tmp1_);
		binding_generator_create_binding_file (self, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp2_ = g_strconcat (self->priv->output_directory, "/", NULL), _tmp4_ = g_utf8_strdown (_tmp3_ = g_strjoinv ("-", namespace_names), -1), NULL), ".vala", NULL), &_inner_error_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			char** name_collection;
			int name_collection_length1;
			int name_it;
			name_collection = namespace_names;
			name_collection_length1 = namespace_names_length1;
			for (name_it = 0; name_it < namespace_names_length1; name_it = name_it + 1) {
				char* name;
				name = g_strdup (name_collection[name_it]);
				{
					char* _tmp7_;
					fprintf (self->priv->output, "\n");
					fprintf (self->priv->output, "%snamespace %s {\n", _tmp7_ = binding_generator_get_indent (self, 0), name);
					_g_free0 (_tmp7_);
					binding_generator_update_indent (self, +1);
					_g_free0 (name);
				}
			}
		}
		{
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _name_it;
			_name_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = gee_map_get_keys (ns->members))), _g_object_unref0 (_tmp8_), _tmp9_);
			while (TRUE) {
				char* name;
				xmlNode* api;
				GQuark _tmp11_;
				const char* _tmp10_;
				if (!gee_iterator_next (_name_it)) {
					break;
				}
				name = (char*) gee_iterator_get (_name_it);
				api = gee_map_get (ns->members, name);
				_tmp10_ = api->name;
				_tmp11_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
				if (_tmp11_ == g_quark_from_string (BINDING_GENERATOR_INTERFACE_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_interface (self, name, api, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						binding_generator_generate_proxy_getter (self, api, name, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				} else if (_tmp11_ == g_quark_from_string (BINDING_GENERATOR_ENUMERATION_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_enumeration (self, name, api, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				} else if (_tmp11_ == g_quark_from_string (BINDING_GENERATOR_ERRORDOMAIN_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_errordomain (self, name, api, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				} else if (_tmp11_ == g_quark_from_string (BINDING_GENERATOR_STRUCT_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_explicit_struct (self, name, api, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								_g_free0 (name);
								_g_object_unref0 (_name_it);
								namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				}
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		{
			char** name_collection;
			int name_collection_length1;
			int name_it;
			name_collection = namespace_names;
			name_collection_length1 = namespace_names_length1;
			for (name_it = 0; name_it < namespace_names_length1; name_it = name_it + 1) {
				char* name;
				name = g_strdup (name_collection[name_it]);
				{
					char* _tmp12_;
					binding_generator_update_indent (self, -1);
					fprintf (self->priv->output, "%s}\n", _tmp12_ = binding_generator_get_indent (self, 0));
					_g_free0 (_tmp12_);
					_g_free0 (name);
				}
			}
		}
		self->priv->output = (_tmp13_ = NULL, _fclose0 (self->priv->output), _tmp13_);
		namespace_names = (_vala_array_free (namespace_names, namespace_names_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeeSet* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _name_it;
		_name_it = (_tmp15_ = gee_iterable_iterator ((GeeIterable*) (_tmp14_ = gee_map_get_keys (ns->namespaces))), _g_object_unref0 (_tmp14_), _tmp15_);
		while (TRUE) {
			char* name;
			GeneratedNamespace* child;
			if (!gee_iterator_next (_name_it)) {
				break;
			}
			name = (char*) gee_iterator_get (_name_it);
			child = (GeneratedNamespace*) gee_map_get (ns->namespaces, name);
			binding_generator_generate_namespace (self, child, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == GENERATOR_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (name);
					_generated_namespace_unref0 (child);
					_g_object_unref0 (_name_it);
					return;
				} else {
					_g_free0 (name);
					_generated_namespace_unref0 (child);
					_g_object_unref0 (_name_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_free0 (name);
			_generated_namespace_unref0 (child);
		}
		_g_object_unref0 (_name_it);
	}
}


static void binding_generator_generate_interface (BindingGenerator* self, const char* interface_name, xmlNode* node, GError** error) {
	GError * _inner_error_;
	char* dbus_name;
	char* namespace_name;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	_inner_error_ = NULL;
	dbus_name = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME);
	namespace_name = binding_generator_get_namespace_name (self, interface_name);
	binding_generator_INFO (_tmp0_ = g_strconcat ("Generating interface ", string_to_string (dbus_name), NULL));
	_g_free0 (_tmp0_);
	fprintf (self->priv->output, "\n");
	fprintf (self->priv->output, "%s[DBus (name = \"%s\", timeout = %u)]\n", _tmp1_ = binding_generator_get_indent (self, 0), dbus_name, self->priv->dbus_timeout);
	_g_free0 (_tmp1_);
	fprintf (self->priv->output, "%spublic interface %s : GLib.Object {\n", _tmp2_ = binding_generator_get_indent (self, 0), interface_name);
	_g_free0 (_tmp2_);
	binding_generator_update_indent (self, +1);
	binding_generator_generate_members (self, node, interface_name, _tmp3_ = binding_generator_get_namespace_name (self, dbus_name), &_inner_error_);
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (dbus_name);
			_g_free0 (namespace_name);
			return;
		} else {
			_g_free0 (dbus_name);
			_g_free0 (namespace_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "%s}\n", _tmp4_ = binding_generator_get_indent (self, 0));
	_g_free0 (_tmp4_);
	if (gee_map_get_size (self->priv->structs_to_generate) != 0) {
		{
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _name_it;
			_name_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = gee_map_get_keys (self->priv->structs_to_generate))), _g_object_unref0 (_tmp5_), _tmp6_);
			while (TRUE) {
				char* name;
				char* _tmp7_;
				if (!gee_iterator_next (_name_it)) {
					break;
				}
				name = (char*) gee_iterator_get (_name_it);
				binding_generator_generate_struct (self, name, _tmp7_ = (char*) gee_map_get (self->priv->structs_to_generate, name), namespace_name, &_inner_error_);
				_g_free0 (_tmp7_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GENERATOR_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						_g_object_unref0 (_name_it);
						_g_free0 (dbus_name);
						_g_free0 (namespace_name);
						return;
					} else {
						_g_free0 (name);
						_g_object_unref0 (_name_it);
						_g_free0 (dbus_name);
						_g_free0 (namespace_name);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		gee_map_clear (self->priv->structs_to_generate);
	}
	_g_free0 (dbus_name);
	_g_free0 (namespace_name);
}


static void binding_generator_generate_enumeration (BindingGenerator* self, const char* enumeration_name, xmlNode* node, GError** error) {
	char* dbus_name;
	char* type;
	gboolean string_enum;
	char* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (enumeration_name != NULL);
	dbus_name = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME);
	type = xmlGetProp (node, BINDING_GENERATOR_TYPE_ATTRNAME);
	string_enum = _vala_strcmp0 (type, "s") == 0;
	binding_generator_INFO (_tmp0_ = g_strconcat ("Generating enumeration ", string_to_string (type), " for ", string_to_string (dbus_name), NULL));
	_g_free0 (_tmp0_);
	fprintf (self->priv->output, "\n");
	_tmp1_ = NULL;
	if (string_enum) {
		_tmp1_ = " (use_string_marshalling = true)";
	} else {
		_tmp1_ = "";
	}
	fprintf (self->priv->output, "%s[DBus%s]\n", _tmp2_ = binding_generator_get_indent (self, 0), _tmp1_);
	_g_free0 (_tmp2_);
	fprintf (self->priv->output, "%spublic enum %s {\n", _tmp3_ = binding_generator_get_indent (self, 0), enumeration_name);
	_g_free0 (_tmp3_);
	binding_generator_update_indent (self, +1);
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GQuark _tmp14_;
				const char* _tmp13_;
				if (!_tmp4_) {
					iter = iter->next;
				}
				_tmp4_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp13_ = iter->name;
				_tmp14_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp14_ == g_quark_from_string (BINDING_GENERATOR_MEMBER_ELTNAME))
				switch (0) {
					default:
					{
						char* _tmp5_;
						char* _tmp6_;
						char* member_name;
						char* member_value;
						char* _tmp8_;
						const char* _tmp11_;
						char* _tmp12_;
						member_name = (_tmp6_ = binding_generator_normalized_to_upper_case (self, _tmp5_ = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME)), _g_free0 (_tmp5_), _tmp6_);
						member_value = xmlGetProp (iter, BINDING_GENERATOR_VALUE_ATTRNAME);
						if (string_enum) {
							char* _tmp7_;
							fprintf (self->priv->output, "%s[DBus (value=\"%s\")]\n", _tmp7_ = binding_generator_get_indent (self, 0), member_value);
							_g_free0 (_tmp7_);
						}
						_tmp8_ = NULL;
						if (string_enum) {
							char* _tmp9_;
							_tmp8_ = (_tmp9_ = g_strdup (""), _g_free0 (_tmp8_), _tmp9_);
						} else {
							char* _tmp10_;
							_tmp8_ = (_tmp10_ = g_strdup_printf (" = %s", member_value), _g_free0 (_tmp8_), _tmp10_);
						}
						_tmp11_ = NULL;
						if (iter->next == NULL) {
							_tmp11_ = "";
						} else {
							_tmp11_ = ",";
						}
						fprintf (self->priv->output, "%s%s%s%s\n", _tmp12_ = binding_generator_get_indent (self, 0), member_name, _tmp8_, _tmp11_);
						_g_free0 (_tmp12_);
						_g_free0 (member_name);
						_g_free0 (member_value);
						_g_free0 (_tmp8_);
						break;
					}
				}
			}
		}
	}
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "%s}\n", _tmp15_ = binding_generator_get_indent (self, 0));
	_g_free0 (_tmp15_);
	_g_free0 (dbus_name);
	_g_free0 (type);
}


static void binding_generator_generate_errordomain (BindingGenerator* self, const char* errordomain_name, xmlNode* node, GError** error) {
	char* dbus_name;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errordomain_name != NULL);
	dbus_name = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME);
	binding_generator_INFO (_tmp0_ = g_strconcat ("Generating errordomain ", string_to_string (errordomain_name), " for ", string_to_string (dbus_name), NULL));
	_g_free0 (_tmp0_);
	fprintf (self->priv->output, "\n");
	fprintf (self->priv->output, "%s[DBus (name = \"%s\")]\n", _tmp1_ = binding_generator_get_indent (self, 0), dbus_name);
	_g_free0 (_tmp1_);
	fprintf (self->priv->output, "%spublic errordomain %s {\n", _tmp2_ = binding_generator_get_indent (self, 0), errordomain_name);
	_g_free0 (_tmp2_);
	binding_generator_update_indent (self, +1);
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				GQuark _tmp8_;
				const char* _tmp7_;
				if (!_tmp3_) {
					iter = iter->next;
				}
				_tmp3_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp7_ = iter->name;
				_tmp8_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp8_ == g_quark_from_string (BINDING_GENERATOR_ERROR_ELTNAME))
				switch (0) {
					default:
					{
						char* dbus_error_name;
						char* error_name;
						char* _tmp4_;
						const char* _tmp5_;
						char* _tmp6_;
						dbus_error_name = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME);
						error_name = binding_generator_camel_case_to_upper_case (self, dbus_error_name);
						fprintf (self->priv->output, "%s[DBus (name = \"%s\")]\n", _tmp4_ = binding_generator_get_indent (self, 0), dbus_error_name);
						_g_free0 (_tmp4_);
						_tmp5_ = NULL;
						if (iter->next == NULL) {
							_tmp5_ = "";
						} else {
							_tmp5_ = ",";
						}
						fprintf (self->priv->output, "%s%s%s\n", _tmp6_ = binding_generator_get_indent (self, 0), error_name, _tmp5_);
						_g_free0 (_tmp6_);
						_g_free0 (dbus_error_name);
						_g_free0 (error_name);
						break;
					}
				}
			}
		}
	}
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "%s}\n", _tmp9_ = binding_generator_get_indent (self, 0));
	_g_free0 (_tmp9_);
	_g_free0 (dbus_name);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void binding_generator_generate_explicit_struct (BindingGenerator* self, const char* struct_name, xmlNode* node, GError** error) {
	GError * _inner_error_;
	char* dbus_name;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* ctor_signature;
	char* ctor_body;
	char* _tmp23_;
	char* _tmp22_;
	char* _tmp24_;
	char* constructor;
	char* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (struct_name != NULL);
	_inner_error_ = NULL;
	dbus_name = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME);
	binding_generator_INFO (_tmp0_ = g_strconcat ("Generating explicit struct ", string_to_string (struct_name), " for ", string_to_string (dbus_name), NULL));
	_g_free0 (_tmp0_);
	fprintf (self->priv->output, "\n");
	fprintf (self->priv->output, "%spublic struct %s {\n", _tmp1_ = binding_generator_get_indent (self, 0), struct_name);
	_g_free0 (_tmp1_);
	binding_generator_update_indent (self, +1);
	ctor_signature = (_tmp3_ = g_strdup_printf ("%spublic %s (", _tmp2_ = binding_generator_get_indent (self, 0), struct_name), _g_free0 (_tmp2_), _tmp3_);
	ctor_body = g_strdup ("");
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GQuark _tmp21_;
				const char* _tmp20_;
				if (!_tmp4_) {
					iter = iter->next;
				}
				_tmp4_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp20_ = iter->name;
				_tmp21_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
				if (_tmp21_ == g_quark_from_string (BINDING_GENERATOR_FIELD_ELTNAME))
				switch (0) {
					default:
					{
						char* _tmp5_;
						char* _tmp6_;
						char* field_name;
						char* field_type;
						char* _tmp14_;
						char* _tmp16_;
						char* _tmp15_;
						char* _tmp19_;
						char* _tmp18_;
						char* _tmp17_;
						field_name = (_tmp6_ = binding_generator_transform_registered_name (self, _tmp5_ = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME)), _g_free0 (_tmp5_), _tmp6_);
						field_type = g_strdup ("unknown");
						{
							char* _tmp9_;
							char* _tmp8_;
							char* _tmp7_;
							char* _tmp10_;
							char* _tmp11_;
							char* _tmp12_;
							_tmp11_ = (_tmp10_ = binding_generator_translate_type (self, _tmp7_ = xmlGetProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME), _tmp8_ = xmlGetNsProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE), struct_name, _tmp9_ = binding_generator_get_namespace_name (self, dbus_name), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _tmp10_);
							if (_inner_error_ != NULL) {
								if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
									goto __catch1_generator_error_unknown_dbus_type;
								}
								goto __finally1;
							}
							field_type = (_tmp12_ = _tmp11_, _g_free0 (field_type), _tmp12_);
						}
						goto __finally1;
						__catch1_generator_error_unknown_dbus_type:
						{
							GError * ex;
							ex = _inner_error_;
							_inner_error_ = NULL;
							{
								char* _tmp13_;
								binding_generator_ERROR (_tmp13_ = g_strconcat ("In struct ", string_to_string (struct_name), " field ", string_to_string (field_name), " : Unknown dbus type ", string_to_string (ex->message), NULL));
								_g_free0 (_tmp13_);
								_g_error_free0 (ex);
							}
						}
						__finally1:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (field_name);
								_g_free0 (field_type);
								_g_free0 (dbus_name);
								_g_free0 (ctor_signature);
								_g_free0 (ctor_body);
								return;
							} else {
								_g_free0 (field_name);
								_g_free0 (field_type);
								_g_free0 (dbus_name);
								_g_free0 (ctor_signature);
								_g_free0 (ctor_body);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						fprintf (self->priv->output, "%spublic %s %s;\n", _tmp14_ = binding_generator_get_indent (self, 0), field_type, field_name);
						_g_free0 (_tmp14_);
						ctor_signature = (_tmp16_ = g_strconcat (ctor_signature, _tmp15_ = g_strdup_printf ("%s %s, ", field_type, field_name), NULL), _g_free0 (ctor_signature), _tmp16_);
						_g_free0 (_tmp15_);
						ctor_body = (_tmp19_ = g_strconcat (ctor_body, _tmp18_ = g_strdup_printf ("%sthis.%s = %s;\n", _tmp17_ = binding_generator_get_indent (self, +1), field_name, field_name), NULL), _g_free0 (ctor_body), _tmp19_);
						_g_free0 (_tmp18_);
						_g_free0 (_tmp17_);
						_g_free0 (field_name);
						_g_free0 (field_type);
						break;
					}
				}
			}
		}
	}
	constructor = (_tmp24_ = g_strdup_printf ("%s ) {\n%s%s}", _tmp22_ = string_substring (ctor_signature, (glong) 0, string_get_length (ctor_signature) - 2), ctor_body, _tmp23_ = binding_generator_get_indent (self, 0)), _g_free0 (_tmp23_), _g_free0 (_tmp22_), _tmp24_);
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "\n%s\n%s}\n", constructor, _tmp25_ = binding_generator_get_indent (self, 0));
	_g_free0 (_tmp25_);
	_g_free0 (dbus_name);
	_g_free0 (ctor_signature);
	_g_free0 (ctor_body);
	_g_free0 (constructor);
}


static void binding_generator_generate_struct (BindingGenerator* self, const char* name, const char* content_signature, const char* dbus_namespace, GError** error) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	gint attribute_number;
	char* signature;
	char* tail;
	char* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (content_signature != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_inner_error_ = NULL;
	binding_generator_INFO (_tmp0_ = g_strconcat ("Generating struct ", string_to_string (name), " w/ signature ", string_to_string (content_signature), " in dbus namespace ", string_to_string (dbus_namespace), NULL));
	_g_free0 (_tmp0_);
	fprintf (self->priv->output, "\n");
	fprintf (self->priv->output, "%spublic struct %s {\n", _tmp1_ = binding_generator_get_indent (self, 0), name);
	_g_free0 (_tmp1_);
	binding_generator_update_indent (self, +1);
	attribute_number = 1;
	signature = g_strdup (content_signature);
	tail = NULL;
	while (TRUE) {
		char* _tmp4_;
		char* _tmp3_;
		char* _tmp2_ = NULL;
		char* type;
		char* _tmp5_;
		char* _tmp6_;
		if (!(_vala_strcmp0 (signature, "") != 0)) {
			break;
		}
		type = (_tmp3_ = binding_generator_parse_type (self, signature, &_tmp2_, "", dbus_namespace, &_inner_error_), tail = (_tmp4_ = _tmp2_, _g_free0 (tail), _tmp4_), _tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GENERATOR_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (signature);
				_g_free0 (tail);
				return;
			} else {
				_g_free0 (signature);
				_g_free0 (tail);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		fprintf (self->priv->output, "%spublic %s attr%d;\n", _tmp5_ = binding_generator_get_indent (self, 0), type, attribute_number);
		_g_free0 (_tmp5_);
		attribute_number++;
		signature = (_tmp6_ = g_strdup (tail), _g_free0 (signature), _tmp6_);
		_g_free0 (type);
	}
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "%s}\n", _tmp7_ = binding_generator_get_indent (self, 0));
	_g_free0 (_tmp7_);
	_g_free0 (signature);
	_g_free0 (tail);
}


static void binding_generator_generate_members (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_inner_error_ = NULL;
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GQuark _tmp2_;
				const char* _tmp1_;
				if (!_tmp0_) {
					iter = iter->next;
				}
				_tmp0_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp1_ = iter->name;
				_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
				if (_tmp2_ == g_quark_from_string (BINDING_GENERATOR_METHOD_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_method (self, iter, interface_name, dbus_namespace, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				} else if (_tmp2_ == g_quark_from_string (BINDING_GENERATOR_SIGNAL_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_signal (self, iter, interface_name, dbus_namespace, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				} else if (_tmp2_ == g_quark_from_string (BINDING_GENERATOR_ERROR_ELTNAME))
				switch (0) {
					default:
					{
						binding_generator_generate_error (self, iter, interface_name, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
				}
			}
		}
	}
}


static void binding_generator_generate_method (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error) {
	GError * _inner_error_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* name;
	char* _tmp3_;
	gint unknown_param_count;
	gint out_param_count;
	gboolean first_param;
	gboolean first_error;
	GString* args_builder;
	GString* throws_builder;
	char* return_value_type;
	gboolean async_method;
	const char* _tmp25_;
	char* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_inner_error_ = NULL;
	name = (_tmp2_ = binding_generator_transform_registered_name (self, _tmp1_ = binding_generator_uncapitalize (self, _tmp0_ = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	binding_generator_INFO (_tmp3_ = g_strconcat ("   Generating method ", string_to_string (name), " for ", string_to_string (interface_name), NULL));
	_g_free0 (_tmp3_);
	unknown_param_count = 0;
	out_param_count = binding_generator_get_out_parameter_count (self, node);
	first_param = TRUE;
	first_error = TRUE;
	args_builder = g_string_new ("");
	throws_builder = g_string_new ("");
	return_value_type = g_strdup ("void");
	async_method = FALSE;
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GQuark _tmp24_;
				const char* _tmp23_;
				if (!_tmp4_) {
					iter = iter->next;
				}
				_tmp4_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp23_ = iter->name;
				_tmp24_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
				if (_tmp24_ == g_quark_from_string (BINDING_GENERATOR_ARG_ELTNAME))
				switch (0) {
					default:
					{
						char* _tmp5_;
						char* _tmp6_;
						char* param_name;
						gboolean _tmp7_ = FALSE;
						char* param_type;
						char* param_dir;
						GQuark _tmp19_;
						const char* _tmp18_;
						param_name = (_tmp6_ = binding_generator_transform_registered_name (self, _tmp5_ = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME)), _g_free0 (_tmp5_), _tmp6_);
						if (param_name == NULL) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = _vala_strcmp0 (param_name, "") == 0;
						}
						if (_tmp7_) {
							char* _tmp8_;
							param_name = (_tmp8_ = g_strdup_printf ("param%i", unknown_param_count), _g_free0 (param_name), _tmp8_);
							unknown_param_count++;
						}
						param_type = g_strdup ("unknown");
						{
							char* _tmp11_;
							char* _tmp10_;
							char* _tmp9_;
							char* _tmp12_;
							char* _tmp13_;
							char* _tmp14_;
							_tmp13_ = (_tmp12_ = binding_generator_translate_type (self, _tmp9_ = xmlGetProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME), _tmp10_ = xmlGetNsProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE), _tmp11_ = binding_generator_get_struct_name (self, interface_name, param_name), dbus_namespace, &_inner_error_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp12_);
							if (_inner_error_ != NULL) {
								if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
									goto __catch2_generator_error_unknown_dbus_type;
								}
								goto __finally2;
							}
							param_type = (_tmp14_ = _tmp13_, _g_free0 (param_type), _tmp14_);
						}
						goto __finally2;
						__catch2_generator_error_unknown_dbus_type:
						{
							GError * ex;
							ex = _inner_error_;
							_inner_error_ = NULL;
							{
								char* _tmp15_;
								binding_generator_ERROR (_tmp15_ = g_strconcat ("In interface ", string_to_string (interface_name), " method ", string_to_string (name), " : Unknown dbus type ", string_to_string (ex->message), NULL));
								_g_free0 (_tmp15_);
								_g_error_free0 (ex);
							}
						}
						__finally2:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == GENERATOR_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (param_name);
								_g_free0 (param_type);
								_g_free0 (name);
								_g_string_free0 (args_builder);
								_g_string_free0 (throws_builder);
								_g_free0 (return_value_type);
								return;
							} else {
								_g_free0 (param_name);
								_g_free0 (param_type);
								_g_free0 (name);
								_g_string_free0 (args_builder);
								_g_string_free0 (throws_builder);
								_g_free0 (return_value_type);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						param_dir = xmlGetProp (iter, BINDING_GENERATOR_DIRECTION_ATTRNAME);
						_tmp18_ = param_dir;
						_tmp19_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
						if (_tmp19_ == g_quark_from_string (BINDING_GENERATOR_OUT_ATTRVALUE))
						switch (0) {
							default:
							{
								if (param_type == NULL) {
									char* _tmp16_;
									param_type = (_tmp16_ = g_strdup ("void"), _g_free0 (param_type), _tmp16_);
								}
								if (out_param_count != 1) {
									if (!first_param) {
										g_string_append (args_builder, ", ");
									}
									g_string_append (args_builder, "out ");
									g_string_append (args_builder, param_type);
									g_string_append (args_builder, " ");
									g_string_append (args_builder, param_name);
									first_param = FALSE;
								} else {
									char* _tmp17_;
									return_value_type = (_tmp17_ = g_strdup (param_type), _g_free0 (return_value_type), _tmp17_);
								}
								break;
							}
						} else
						switch (0) {
							default:
							{
								if (!first_param) {
									g_string_append (args_builder, ", ");
								}
								g_string_append (args_builder, param_type);
								g_string_append (args_builder, " ");
								g_string_append (args_builder, param_name);
								first_param = FALSE;
								break;
							}
						}
						_g_free0 (param_name);
						_g_free0 (param_type);
						_g_free0 (param_dir);
						break;
					}
				} else if (_tmp24_ == g_quark_from_string (BINDING_GENERATOR_THROWS_ELTNAME))
				switch (0) {
					default:
					{
						char* errordomain_name;
						char* fso_type;
						errordomain_name = NULL;
						fso_type = xmlGetProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME);
						if (fso_type != NULL) {
							char* _tmp20_;
							errordomain_name = (_tmp20_ = (char*) gee_map_get (self->priv->error_name_index, fso_type), _g_free0 (errordomain_name), _tmp20_);
						}
						if (errordomain_name == NULL) {
							char* _tmp21_;
							char* _tmp22_;
							binding_generator_ERROR (_tmp21_ = g_strconcat ("In interface ", string_to_string (interface_name), " method ", string_to_string (name), " : Unknown dbus error ", string_to_string (fso_type), NULL));
							_g_free0 (_tmp21_);
							errordomain_name = (_tmp22_ = g_strdup ("<unknown>"), _g_free0 (errordomain_name), _tmp22_);
						}
						if (!first_error) {
							g_string_append (throws_builder, ", ");
						}
						g_string_append (throws_builder, errordomain_name);
						first_error = FALSE;
						_g_free0 (errordomain_name);
						_g_free0 (fso_type);
						break;
					}
				} else if (_tmp24_ == g_quark_from_string (BINDING_GENERATOR_ANNOTATION_ELTNAME))
				switch (0) {
					default:
					{
						char* annotation_name;
						annotation_name = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME);
						if (_vala_strcmp0 (annotation_name, "org.freedesktop.DBus.GLib.Async") == 0) {
							async_method = TRUE;
						}
						_g_free0 (annotation_name);
						break;
					}
				}
			}
		}
	}
	if (!first_error) {
		g_string_append (throws_builder, ", ");
	}
	g_string_append (throws_builder, "DBus.Error");
	fprintf (self->priv->output, "\n");
	_tmp25_ = NULL;
	if (async_method) {
		_tmp25_ = "async";
	} else {
		_tmp25_ = "";
	}
	fprintf (self->priv->output, "%spublic abstract %s %s %s(%s) throws %s;\n", _tmp26_ = binding_generator_get_indent (self, 0), _tmp25_, return_value_type, name, args_builder->str, throws_builder->str);
	_g_free0 (_tmp26_);
	_g_free0 (name);
	_g_string_free0 (args_builder);
	_g_string_free0 (throws_builder);
	_g_free0 (return_value_type);
}


static gint binding_generator_get_out_parameter_count (BindingGenerator* self, xmlNode* node) {
	gint result = 0;
	gint out_param_count;
	g_return_val_if_fail (self != NULL, 0);
	out_param_count = 0;
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					iter = iter->next;
				}
				_tmp0_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				if (_vala_strcmp0 (iter->name, BINDING_GENERATOR_ARG_ELTNAME) != 0) {
					continue;
				}
				if ((_tmp2_ = _vala_strcmp0 (_tmp1_ = xmlGetProp (iter, BINDING_GENERATOR_DIRECTION_ATTRNAME), BINDING_GENERATOR_OUT_ATTRVALUE) != 0, _g_free0 (_tmp1_), _tmp2_)) {
					continue;
				}
				out_param_count++;
			}
		}
	}
	result = out_param_count;
	return result;
}


static void binding_generator_generate_signal (BindingGenerator* self, xmlNode* node, const char* interface_name, const char* dbus_namespace, GError** error) {
	GError * _inner_error_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* name;
	char* _tmp3_;
	gint unknown_param_count;
	gboolean first_param;
	GString* args_builder;
	char* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (dbus_namespace != NULL);
	_inner_error_ = NULL;
	name = (_tmp2_ = binding_generator_transform_registered_name (self, _tmp1_ = binding_generator_uncapitalize (self, _tmp0_ = xmlGetProp (node, BINDING_GENERATOR_NAME_ATTRNAME))), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	binding_generator_INFO (_tmp3_ = g_strconcat ("   Generating signal ", string_to_string (name), " for ", string_to_string (interface_name), NULL));
	_g_free0 (_tmp3_);
	unknown_param_count = 0;
	first_param = TRUE;
	args_builder = g_string_new ("");
	{
		xmlNode* iter;
		iter = node->children;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				char* _tmp5_;
				char* _tmp6_;
				char* param_name;
				gboolean _tmp7_ = FALSE;
				char* param_type;
				if (!_tmp4_) {
					iter = iter->next;
				}
				_tmp4_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				if (_vala_strcmp0 (iter->name, BINDING_GENERATOR_ARG_ELTNAME) != 0) {
					continue;
				}
				param_name = (_tmp6_ = binding_generator_transform_registered_name (self, _tmp5_ = xmlGetProp (iter, BINDING_GENERATOR_NAME_ATTRNAME)), _g_free0 (_tmp5_), _tmp6_);
				if (param_name == NULL) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = _vala_strcmp0 (param_name, "") == 0;
				}
				if (_tmp7_) {
					char* _tmp8_;
					param_name = (_tmp8_ = g_strdup_printf ("param%i", unknown_param_count), _g_free0 (param_name), _tmp8_);
					unknown_param_count++;
				}
				param_type = g_strdup ("unknown");
				{
					char* _tmp12_;
					char* _tmp11_;
					char* _tmp10_;
					char* _tmp9_;
					char* _tmp13_;
					char* _tmp14_;
					char* _tmp15_;
					_tmp14_ = (_tmp13_ = binding_generator_translate_type (self, _tmp9_ = xmlGetProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME), _tmp10_ = xmlGetNsProp (iter, BINDING_GENERATOR_TYPE_ATTRNAME, BINDING_GENERATOR_FSO_NAMESPACE), _tmp12_ = g_strconcat (interface_name, _tmp11_ = binding_generator_capitalize (self, param_name), NULL), dbus_namespace, &_inner_error_), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _tmp13_);
					if (_inner_error_ != NULL) {
						if (g_error_matches (_inner_error_, GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE)) {
							goto __catch3_generator_error_unknown_dbus_type;
						}
						goto __finally3;
					}
					param_type = (_tmp15_ = _tmp14_, _g_free0 (param_type), _tmp15_);
				}
				goto __finally3;
				__catch3_generator_error_unknown_dbus_type:
				{
					GError * ex;
					ex = _inner_error_;
					_inner_error_ = NULL;
					{
						char* _tmp16_;
						binding_generator_ERROR (_tmp16_ = g_strconcat ("In interface ", string_to_string (interface_name), " signal ", string_to_string (name), " : Unknown dbus type ", string_to_string (ex->message), NULL));
						_g_free0 (_tmp16_);
						_g_error_free0 (ex);
					}
				}
				__finally3:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == GENERATOR_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (param_name);
						_g_free0 (param_type);
						_g_free0 (name);
						_g_string_free0 (args_builder);
						return;
					} else {
						_g_free0 (param_name);
						_g_free0 (param_type);
						_g_free0 (name);
						_g_string_free0 (args_builder);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!first_param) {
					g_string_append (args_builder, ", ");
				}
				g_string_append (args_builder, param_type);
				g_string_append (args_builder, " ");
				g_string_append (args_builder, param_name);
				first_param = FALSE;
				_g_free0 (param_name);
				_g_free0 (param_type);
			}
		}
	}
	fprintf (self->priv->output, "\n");
	fprintf (self->priv->output, "%spublic signal void %s(%s);\n", _tmp17_ = binding_generator_get_indent (self, 0), name, args_builder->str);
	_g_free0 (_tmp17_);
	_g_free0 (name);
	_g_string_free0 (args_builder);
}


static void binding_generator_generate_error (BindingGenerator* self, xmlNode* node, const char* interface_name, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
}


static void binding_generator_generate_proxy_getter (BindingGenerator* self, xmlNode* node, const char* interface_name, GError** error) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp6_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	fprintf (self->priv->output, "%s", _tmp2_ = g_strconcat ("\n", string_to_string (_tmp0_ = binding_generator_get_indent (self, 0)), "public ", string_to_string (interface_name), " get_", string_to_string (_tmp1_ = binding_generator_uncapitalize (self, interface_name)), "_proxy(DBus.Connection con, string busname, DBus.ObjectPath path) {", NULL));
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	binding_generator_update_indent (self, +1);
	fprintf (self->priv->output, "%s", _tmp4_ = g_strconcat ("\n", string_to_string (_tmp3_ = binding_generator_get_indent (self, 0)), "return con.get_object(busname, path) as ", string_to_string (interface_name), ";", NULL));
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	binding_generator_update_indent (self, -1);
	fprintf (self->priv->output, "%s", _tmp6_ = g_strconcat ("\n", string_to_string (_tmp5_ = binding_generator_get_indent (self, 0)), "}", NULL));
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char* binding_generator_translate_type (BindingGenerator* self, const char* type, const char* fso_type, const char* type_name, const char* dbus_namespace, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* tail;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_ = NULL;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (dbus_namespace != NULL, NULL);
	_inner_error_ = NULL;
	tail = NULL;
	if (fso_type != NULL) {
		char* vala_type;
		const char* _tmp0_;
		vala_type = (char*) gee_map_get (self->priv->name_index, fso_type);
		if (vala_type == NULL) {
			_inner_error_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE, fso_type);
			{
				if (_inner_error_->domain == GENERATOR_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (vala_type);
					_g_free0 (tail);
					return NULL;
				} else {
					_g_free0 (vala_type);
					_g_free0 (tail);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		_tmp0_ = NULL;
		if (g_str_has_prefix (type, "a")) {
			_tmp0_ = "[]";
		} else {
			_tmp0_ = "";
		}
		result = g_strconcat (vala_type, _tmp0_, NULL);
		_g_free0 (vala_type);
		_g_free0 (tail);
		return result;
	}
	_tmp4_ = (_tmp2_ = binding_generator_parse_type (self, type, &_tmp1_, type_name, dbus_namespace, &_inner_error_), tail = (_tmp3_ = _tmp1_, _g_free0 (tail), _tmp3_), _tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (tail);
			return NULL;
		} else {
			_g_free0 (tail);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = (_tmp6_ = string_replace (_tmp5_ = _tmp4_, "][", ","), _g_free0 (_tmp5_), _tmp6_);
	_g_free0 (tail);
	return result;
	_g_free0 (tail);
}


static char* binding_generator_parse_type (BindingGenerator* self, const char* type, char** tail, const char* type_name, const char* dbus_namespace, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp33_;
	GError* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (tail != NULL) {
		*tail = NULL;
	}
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (dbus_namespace != NULL, NULL);
	_inner_error_ = NULL;
	*tail = (_tmp0_ = string_substring (type, (glong) 1, -1), _g_free0 (*tail), _tmp0_);
	if (g_str_has_prefix (type, "y")) {
		result = g_strdup ("uint8");
		return result;
	} else {
		if (g_str_has_prefix (type, "b")) {
			result = g_strdup ("bool");
			return result;
		} else {
			gboolean _tmp1_ = FALSE;
			if (g_str_has_prefix (type, "n")) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = g_str_has_prefix (type, "i");
			}
			if (_tmp1_) {
				result = g_strdup ("int");
				return result;
			} else {
				gboolean _tmp2_ = FALSE;
				if (g_str_has_prefix (type, "q")) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = g_str_has_prefix (type, "u");
				}
				if (_tmp2_) {
					result = g_strdup ("uint");
					return result;
				} else {
					if (g_str_has_prefix (type, "x")) {
						result = g_strdup ("int64");
						return result;
					} else {
						if (g_str_has_prefix (type, "t")) {
							result = g_strdup ("uint64");
							return result;
						} else {
							if (g_str_has_prefix (type, "d")) {
								result = g_strdup ("double");
								return result;
							} else {
								if (g_str_has_prefix (type, "s")) {
									result = g_strdup ("string");
									return result;
								} else {
									if (g_str_has_prefix (type, "o")) {
										result = g_strdup ("ObjectPath");
										return result;
									} else {
										if (g_str_has_prefix (type, "v")) {
											result = g_strdup ("GLib.Value");
											return result;
										} else {
											if (g_str_has_prefix (type, "a{")) {
												char* _tmp5_;
												char* _tmp4_;
												char* _tmp3_ = NULL;
												char* tmp_type;
												char* tail2;
												char* tail3;
												GString* vala_type;
												char* _tmp10_;
												char* _tmp9_;
												char* _tmp8_ = NULL;
												char* _tmp7_;
												char* _tmp6_;
												char* _tmp11_;
												char* foo;
												char* _tmp15_;
												char* _tmp14_;
												char* _tmp13_ = NULL;
												char* _tmp12_;
												char* _tmp16_;
												char* value_type;
												tmp_type = (_tmp4_ = binding_generator_get_subsignature (self, type, '{', '}', &_tmp3_), *tail = (_tmp5_ = _tmp3_, _g_free0 (*tail), _tmp5_), _tmp4_);
												tail2 = NULL;
												tail3 = NULL;
												vala_type = g_string_new ("");
												g_string_append (vala_type, "GLib.HashTable<");
												foo = (_tmp11_ = (_tmp9_ = binding_generator_parse_type (self, tmp_type, &_tmp8_, _tmp7_ = g_strconcat (_tmp6_ = binding_generator_plural_to_singular (self, type_name), "Key", NULL), dbus_namespace, &_inner_error_), tail2 = (_tmp10_ = _tmp8_, _g_free0 (tail2), _tmp10_), _tmp9_), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _tmp11_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == GENERATOR_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (tmp_type);
														_g_free0 (tail2);
														_g_free0 (tail3);
														_g_string_free0 (vala_type);
														return NULL;
													} else {
														_g_free0 (tmp_type);
														_g_free0 (tail2);
														_g_free0 (tail3);
														_g_string_free0 (vala_type);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												g_string_append (vala_type, foo);
												g_string_append (vala_type, ", ");
												value_type = (_tmp16_ = (_tmp14_ = binding_generator_parse_type (self, tail2, &_tmp13_, _tmp12_ = binding_generator_plural_to_singular (self, type_name), dbus_namespace, &_inner_error_), tail3 = (_tmp15_ = _tmp13_, _g_free0 (tail3), _tmp15_), _tmp14_), _g_free0 (_tmp12_), _tmp16_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == GENERATOR_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (tmp_type);
														_g_free0 (tail2);
														_g_free0 (tail3);
														_g_string_free0 (vala_type);
														_g_free0 (foo);
														return NULL;
													} else {
														_g_free0 (tmp_type);
														_g_free0 (tail2);
														_g_free0 (tail3);
														_g_string_free0 (vala_type);
														_g_free0 (foo);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												if (_vala_strcmp0 (value_type, "GLib.Value") == 0) {
													char* _tmp17_;
													value_type = (_tmp17_ = g_strconcat (value_type, "?", NULL), _g_free0 (value_type), _tmp17_);
												}
												g_string_append (vala_type, value_type);
												g_string_append (vala_type, ">");
												result = g_strdup (vala_type->str);
												_g_free0 (tmp_type);
												_g_free0 (tail2);
												_g_free0 (tail3);
												_g_string_free0 (vala_type);
												_g_free0 (foo);
												_g_free0 (value_type);
												return result;
											} else {
												if (g_str_has_prefix (type, "a")) {
													char* tail2;
													char* _tmp21_;
													char* _tmp20_;
													char* _tmp19_ = NULL;
													char* _tmp18_;
													char* _tmp22_;
													char* _tmp23_;
													char* _tmp24_;
													char* _tmp25_;
													tail2 = NULL;
													_tmp23_ = (_tmp22_ = (_tmp20_ = binding_generator_parse_type (self, *tail, &_tmp19_, _tmp18_ = binding_generator_plural_to_singular (self, type_name), dbus_namespace, &_inner_error_), tail2 = (_tmp21_ = _tmp19_, _g_free0 (tail2), _tmp21_), _tmp20_), _g_free0 (_tmp18_), _tmp22_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == GENERATOR_ERROR) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (tail2);
															return NULL;
														} else {
															_g_free0 (tail2);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													result = (_tmp25_ = g_strconcat (_tmp24_ = _tmp23_, "[]", NULL), _g_free0 (_tmp24_), _tmp25_);
													_g_free0 (tail2);
													return result;
													_g_free0 (tail2);
												} else {
													if (g_str_has_prefix (type, "(")) {
														char* _tmp28_;
														char* _tmp27_;
														char* _tmp26_ = NULL;
														char* sub_type;
														gint number;
														char* unique_type_name;
														char* _tmp31_;
														char* _tmp30_;
														gboolean _tmp32_;
														sub_type = (_tmp27_ = binding_generator_get_subsignature (self, type, '(', ')', &_tmp26_), *tail = (_tmp28_ = _tmp26_, _g_free0 (*tail), _tmp28_), _tmp27_);
														number = 2;
														unique_type_name = g_strconcat (type_name, "Struct", NULL);
														while (TRUE) {
															char* _tmp29_;
															if (!gee_map_contains (self->priv->structs_to_generate, unique_type_name)) {
																break;
															}
															unique_type_name = (_tmp29_ = g_strdup_printf ("%s%d", unique_type_name, number++), _g_free0 (unique_type_name), _tmp29_);
														}
														if ((_tmp32_ = !gee_map_contains (self->priv->name_index, _tmp31_ = g_strconcat (_tmp30_ = g_strconcat (dbus_namespace, ".", NULL), unique_type_name, NULL)), _g_free0 (_tmp31_), _g_free0 (_tmp30_), _tmp32_)) {
															gee_map_set (self->priv->structs_to_generate, unique_type_name, sub_type);
														}
														result = unique_type_name;
														_g_free0 (sub_type);
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_inner_error_ = (_tmp34_ = g_error_new_literal (GENERATOR_ERROR, GENERATOR_ERROR_UNKNOWN_DBUS_TYPE, _tmp33_ = g_strconcat ("dbustype: '", string_to_string (type), "' unknown", NULL)), _g_free0 (_tmp33_), _tmp34_);
	{
		if (_inner_error_->domain == GENERATOR_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


static char* binding_generator_get_struct_name (BindingGenerator* self, const char* interface_name, const char* param_name) {
	char* result = NULL;
	char* striped_interface_name;
	char* name;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	g_return_val_if_fail (param_name != NULL, NULL);
	striped_interface_name = binding_generator_strip_namespace (self, interface_name);
	name = binding_generator_capitalize (self, param_name);
	_tmp0_ = NULL;
	if (g_str_has_prefix (name, striped_interface_name)) {
		char* _tmp1_;
		_tmp0_ = (_tmp1_ = g_strdup (name), _g_free0 (_tmp0_), _tmp1_);
	} else {
		char* _tmp2_;
		_tmp0_ = (_tmp2_ = g_strconcat (striped_interface_name, name, NULL), _g_free0 (_tmp0_), _tmp2_);
	}
	result = _tmp0_;
	_g_free0 (striped_interface_name);
	_g_free0 (name);
	return result;
}


static char* binding_generator_get_namespace_name (BindingGenerator* self, const char* interface_name) {
	char* result = NULL;
	glong last_dot;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	last_dot = string_get_length (interface_name) - 1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (last_dot >= 0) {
			_tmp0_ = g_utf8_get_char (g_utf8_offset_to_pointer (interface_name, last_dot)) != '.';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		last_dot--;
	}
	result = string_substring (interface_name, (glong) 0, last_dot);
	return result;
}


static char* binding_generator_strip_namespace (BindingGenerator* self, const char* interface_name) {
	char* result = NULL;
	glong last_dot;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	last_dot = string_get_length (interface_name) - 1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (last_dot >= 0) {
			_tmp0_ = g_utf8_get_char (g_utf8_offset_to_pointer (interface_name, last_dot)) != '.';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		last_dot--;
	}
	result = string_substring (interface_name, last_dot + 1, (string_get_length (interface_name) - last_dot) - 1);
	return result;
}


static char* binding_generator_capitalize (BindingGenerator* self, const char* type_name) {
	char* result = NULL;
	char** _tmp1_;
	gint _parts_size_;
	gint parts_length1;
	char** _tmp0_;
	char** parts;
	GString* capitalized_name;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	parts = (_tmp1_ = _tmp0_ = g_strsplit (type_name, "_", 0), parts_length1 = _vala_array_length (_tmp0_), _parts_size_ = parts_length1, _tmp1_);
	capitalized_name = g_string_new ("");
	{
		char** part_collection;
		int part_collection_length1;
		int part_it;
		part_collection = parts;
		part_collection_length1 = parts_length1;
		for (part_it = 0; part_it < parts_length1; part_it = part_it + 1) {
			char* part;
			part = g_strdup (part_collection[part_it]);
			{
				if (_vala_strcmp0 (part, "") != 0) {
					char* _tmp3_;
					char* _tmp2_;
					char* _tmp4_;
					g_string_append (capitalized_name, _tmp3_ = g_utf8_strup (_tmp2_ = string_substring (part, (glong) 0, (glong) 1), -1));
					_g_free0 (_tmp3_);
					_g_free0 (_tmp2_);
					g_string_append (capitalized_name, _tmp4_ = string_substring (part, (glong) 1, string_get_length (part) - 1));
					_g_free0 (_tmp4_);
				}
				_g_free0 (part);
			}
		}
	}
	result = g_strdup (capitalized_name->str);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (capitalized_name);
	return result;
}


static char* binding_generator_uncapitalize (BindingGenerator* self, const char* name) {
	char* result = NULL;
	GString* uncapitalized_name;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	uncapitalized_name = g_string_new ("");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gunichar c;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < string_get_length (name))) {
					break;
				}
				c = g_utf8_get_char (g_utf8_offset_to_pointer (name, i));
				if (g_unichar_isupper (c)) {
					if (i > 0) {
						g_string_append_unichar (uncapitalized_name, (gunichar) '_');
					}
					g_string_append_unichar (uncapitalized_name, g_unichar_tolower (c));
				} else {
					g_string_append_unichar (uncapitalized_name, c);
				}
			}
		}
	}
	result = binding_generator_transform_registered_name (self, uncapitalized_name->str);
	_g_string_free0 (uncapitalized_name);
	return result;
}


static char* binding_generator_normalized_to_upper_case (BindingGenerator* self, const char* name) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = string_replace (name, "-", "_"), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* binding_generator_camel_case_to_upper_case (BindingGenerator* self, const char* name) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = binding_generator_uncapitalize (self, name), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* binding_generator_transform_registered_name (BindingGenerator* self, const char* name) {
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (name != NULL) {
		_tmp0_ = gee_collection_contains ((GeeCollection*) binding_generator_registered_names, name);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = g_strconcat (name, "_", NULL);
		return result;
	}
	result = g_strdup (name);
	return result;
}


static char* binding_generator_plural_to_singular (BindingGenerator* self, const char* type_name) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	if (g_str_has_suffix (type_name, "ies")) {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strconcat (_tmp0_ = string_substring (type_name, (glong) 0, string_get_length (type_name) - 3), "y", NULL), _g_free0 (_tmp0_), _tmp1_);
		return result;
	} else {
		if (g_str_has_suffix (type_name, "ses")) {
			result = string_substring (type_name, (glong) 0, string_get_length (type_name) - 2);
			return result;
		} else {
			if (g_str_has_suffix (type_name, "us")) {
				result = g_strdup (type_name);
				return result;
			} else {
				if (g_str_has_suffix (type_name, "i")) {
					char* _tmp2_;
					char* _tmp3_;
					result = (_tmp3_ = g_strconcat (_tmp2_ = string_substring (type_name, (glong) 0, string_get_length (type_name) - 1), "o", NULL), _g_free0 (_tmp2_), _tmp3_);
					return result;
				} else {
					if (g_str_has_suffix (type_name, "s")) {
						result = string_substring (type_name, (glong) 0, string_get_length (type_name) - 1);
						return result;
					} else {
						result = g_strdup (type_name);
						return result;
					}
				}
			}
		}
	}
}


static char* binding_generator_get_indent (BindingGenerator* self, gint offset) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strnfill ((gsize) (self->priv->indentSize + offset), '\t');
	return result;
}


static void binding_generator_update_indent (BindingGenerator* self, gint increment) {
	g_return_if_fail (self != NULL);
	self->priv->indentSize = self->priv->indentSize + increment;
}


static char* binding_generator_get_subsignature (BindingGenerator* self, const char* s, gchar start, gchar end, char** tail) {
	char* result = NULL;
	gchar* _tmp0_;
	gint _data_size_;
	gint data_length1;
	gchar* data;
	gint iter;
	gint counter;
	gint begin;
	gchar c = '\0';
	char* _tmp2_;
	char* tmp;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	if (tail != NULL) {
		*tail = NULL;
	}
	data = (_tmp0_ = (gchar*) s, data_length1 = -1, _data_size_ = data_length1, _tmp0_);
	iter = 0;
	counter = 0;
	begin = 0;
	{
		gboolean _tmp1_;
		iter = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			if (!_tmp1_) {
				iter++;
			}
			_tmp1_ = FALSE;
			if (!(iter < g_utf8_strlen (s, -1))) {
				break;
			}
			c = data[iter];
			if (c == start) {
				if (counter == 0) {
					begin = iter;
				}
				counter++;
			} else {
				if (c == end) {
					counter--;
					if (counter == 0) {
						break;
					}
				}
			}
		}
	}
	*tail = (_tmp2_ = string_substring (s, (glong) (iter + 1), (glong) (-1)), _g_free0 (*tail), _tmp2_);
	tmp = string_substring (s, (glong) (begin + 1), (glong) ((iter - begin) - 1));
	result = tmp;
	return result;
}


static void binding_generator_class_init (BindingGeneratorClass * klass) {
	binding_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BindingGeneratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = binding_generator_finalize;
	binding_generator_registered_names = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	{
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "using");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "namespace");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "public");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "private");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "internal");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "errordomain");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "class");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "struct");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "new");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "for");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "while");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "foreach");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "switch");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "case");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "static");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "unowned");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "weak");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "register");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "message");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "get_type");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "dispose");
		gee_collection_add ((GeeCollection*) binding_generator_registered_names, "result");
	}
}


static void binding_generator_instance_init (BindingGenerator * self) {
	self->priv = BINDING_GENERATOR_GET_PRIVATE (self);
	self->priv->inner_interface_strategy_concat = TRUE;
	self->priv->api_docs = (GeeList*) gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL);
	self->priv->root_namespace = generated_namespace_new ();
	self->priv->name_index = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->priv->error_name_index = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->priv->structs_to_generate = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->priv->indentSize = 0;
}


static void binding_generator_finalize (GObject* obj) {
	BindingGenerator * self;
	self = BINDING_GENERATOR (obj);
	_g_free0 (self->priv->output_directory);
	_g_object_unref0 (self->priv->namespace_renaming);
	_g_free0 (self->priv->command);
	_fclose0 (self->priv->output);
	_g_object_unref0 (self->priv->api_docs);
	_generated_namespace_unref0 (self->priv->root_namespace);
	_g_object_unref0 (self->priv->name_index);
	_g_object_unref0 (self->priv->error_name_index);
	_g_object_unref0 (self->priv->structs_to_generate);
	G_OBJECT_CLASS (binding_generator_parent_class)->finalize (obj);
}


GType binding_generator_get_type (void) {
	static volatile gsize binding_generator_type_id__volatile = 0;
	if (g_once_init_enter (&binding_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BindingGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingGenerator), 0, (GInstanceInitFunc) binding_generator_instance_init, NULL };
		GType binding_generator_type_id;
		binding_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "BindingGenerator", &g_define_type_info, 0);
		g_once_init_leave (&binding_generator_type_id__volatile, binding_generator_type_id);
	}
	return binding_generator_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




