/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Modify by Salmaso Raffaele <r.salmaso@flashnet.it> 10 Jan 1999
 * added 2 property: Caption and CaptionWrap
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  LABEL_H
#define  LABEL_H

#include <vdk/vdkobj.h>
/*!
  \class VDKLabel
  \brief Provides a gtklabel wrapper
  \par EXAMPLES
  Almost all ./testvdk/.*cc
 */
class VDKLabel: public VDKObject
{
public:
  //
  /*!
    Sets/gets label text justification
   */
  VDKReadWriteValueProp<VDKLabel, GtkJustification> Justify;
  /*!
    Sets/gets label text
   */
  VDKReadWriteValueProp<VDKLabel, char*> Caption;
  /*!
    Sets/gets label text wrap
   */
  VDKReadWriteValueProp<VDKLabel, bool> CaptionWrap;
  /*!
    Constructor
    \param owner
    \param label
    \param justify
   */
  VDKLabel(VDKForm* owner, char* label, 
	   GtkJustification justify = GTK_JUSTIFY_LEFT);
  virtual ~VDKLabel();
  void SetCaption (char* str);
  char* GetCaption ();
  void SetCaptionWrap (bool flag);
  bool GetCaptionWrap ();
  void SetJustify(GtkJustification jtype);
  GtkJustification GetJustify()
    { return Justify; }
};
#endif

