/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.css;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.fop.dom.css.CSSStyleDeclarationImpl;
import org.apache.fop.dom.css.Selector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;

public class CSSStyleRuleImpl
implements CSSStyleRule {
    String seltext;
    String cssText;
    CSSStyleDeclaration style;
    CSSStyleSheet styleSheet;
    Vector selectors = new Vector();

    public CSSStyleRuleImpl(CSSStyleSheet cSSStyleSheet) {
        this.styleSheet = cSSStyleSheet;
    }

    public String getCssText() {
        return this.cssText;
    }

    public CSSRule getParentRule() {
        return null;
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this.styleSheet;
    }

    public String getSelectorText() {
        return this.seltext;
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    public short getType() {
        return 1;
    }

    public boolean matches(SVGElement sVGElement) {
        Enumeration enumeration = this.selectors.elements();
        while (enumeration.hasMoreElements()) {
            Selector selector = (Selector)enumeration.nextElement();
            if (!this.matches(sVGElement, selector)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(SVGElement sVGElement, Selector selector) {
        short s = selector.type;
        if (sVGElement == null) {
            return false;
        }
        switch (s) {
            case 0: {
                return true;
            }
            case 1: {
                return sVGElement.getId().equals(selector.value);
            }
            case 2: {
                return ((SVGStylable)sVGElement).getClassName().getBaseVal().equals(selector.value);
            }
            case 4: {
                return selector.value.equals(sVGElement.getTagName());
            }
            case 8: {
                if (sVGElement.getParentNode() == null) break;
                return sVGElement.getParentNode().getFirstChild() == sVGElement;
            }
            case 9: {
                return selector.value.equals(sVGElement.getTagName()) && selector.subValue.equals(sVGElement.getId());
            }
            case 10: {
                return selector.value.equals(sVGElement.getTagName()) && selector.subValue.equals(((SVGStylable)sVGElement).getClassName().getBaseVal());
            }
            case 5: {
                if (sVGElement.getParentNode() instanceof SVGElement) {
                    if (!this.matches(sVGElement, selector.current)) {
                        return false;
                    }
                    for (SVGElement sVGElement2 = (SVGElement)sVGElement.getParentNode(); sVGElement2 != null; sVGElement2 = (SVGElement)sVGElement2.getParentNode()) {
                        if (this.matches(sVGElement2, selector.last)) {
                            return true;
                        }
                        if (sVGElement2.getParentNode() instanceof SVGElement) {
                            continue;
                        }
                        return false;
                    }
                }
                return false;
            }
            case 6: {
                return this.matches(sVGElement, selector.current) && this.matches((SVGElement)sVGElement.getParentNode(), selector.last);
            }
            case 7: {
                return this.matches(sVGElement, selector.current) && this.matches((SVGElement)sVGElement.getPreviousSibling(), selector.last);
            }
        }
        return false;
    }

    protected void parseSelector() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.seltext, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, " \t\n\r");
            Selector selector = null;
            Selector selector2 = null;
            int n = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken().trim();
                selector2 = new Selector();
                boolean bl = false;
                if (string2.equals("*")) {
                    selector2.type = 0;
                    selector2.value = "*";
                } else if (string2.equals(">")) {
                    n = 1;
                    bl = true;
                } else if (string2.equals("+")) {
                    n = 2;
                    bl = true;
                } else if (string2.startsWith("#")) {
                    selector2.type = 1;
                    selector2.value = string2.substring(1);
                } else if (string2.startsWith(".")) {
                    selector2.type = (short)2;
                    selector2.value = string2.substring(1);
                } else if (string2.startsWith("[")) {
                    selector2.type = (short)3;
                    selector2.value = string2.substring(1, string2.length() - 1);
                } else {
                    selector2.type = (short)4;
                    if (string2.indexOf(":") != -1) {
                        selector2.type = (short)8;
                        int n2 = string2.indexOf(":");
                        selector2.value = string2.substring(0, n2);
                        selector2.subValue = string2.substring(n2 + 1);
                    } else if (string2.indexOf("#") != -1) {
                        selector2.type = (short)9;
                        int n3 = string2.indexOf("#");
                        selector2.value = string2.substring(0, n3);
                        selector2.subValue = string2.substring(n3 + 1);
                    } else if (string2.indexOf(".") != -1) {
                        selector2.type = (short)10;
                        int n4 = string2.indexOf(".");
                        selector2.value = string2.substring(0, n4);
                        selector2.subValue = string2.substring(n4 + 1);
                    } else {
                        selector2.value = string2;
                    }
                }
                if (bl) continue;
                switch (n) {
                    case 0: {
                        if (selector == null) break;
                        Selector selector3 = new Selector();
                        selector3.type = (short)5;
                        selector3.last = selector;
                        selector3.current = selector2;
                        selector2 = selector3;
                        n = 0;
                        break;
                    }
                    case 1: {
                        Selector selector4 = new Selector();
                        selector4.type = (short)6;
                        selector4.last = selector;
                        selector4.current = selector2;
                        selector2 = selector4;
                        n = 0;
                        break;
                    }
                    case 2: {
                        Selector selector5 = new Selector();
                        selector5.type = (short)7;
                        selector5.last = selector;
                        selector5.current = selector2;
                        selector2 = selector5;
                        n = 0;
                        break;
                    }
                }
                selector = selector2;
            }
            if (selector2 == null) continue;
            this.selectors.addElement(selector2);
        }
    }

    public void setCssText(String string) {
        this.cssText = string;
        this.style = new CSSStyleDeclarationImpl();
        this.style.setCssText(string);
    }

    public void setSelectorText(String string) {
        this.seltext = string;
        this.parseSelector();
    }
}

