/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.dom.svg;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.fop.dom.svg.SVGExceptionImpl;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGException;

public class SVGAngleImpl
implements SVGAngle {
    float value = 0.0f;
    short unitType = 0;

    public void convertToSpecifiedUnits(short s) throws SVGException {
        switch (s) {
            case 0: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
            case 1: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
        }
        this.unitType = s;
    }

    public float getAnimatedValue() {
        return 0.0f;
    }

    public short getUnitType() {
        return this.unitType;
    }

    public float getValue() {
        return this.value;
    }

    public String getValueAsString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(this.value);
    }

    public float getValueInSpecifiedUnits() {
        switch (this.unitType) {
            case 0: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
            case 1: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
        }
        return 0.0f;
    }

    public void newValueSpecifiedUnits(short s, float f) throws SVGException {
        switch (s) {
            case 0: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
            case 1: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
            case 2: {
                this.value = (float)((double)f * Math.PI / 90.0);
                break;
            }
            case 3: {
                this.value = f;
                break;
            }
            case 4: {
                this.value = (float)((double)f * Math.PI / 90.0);
                break;
            }
        }
        this.unitType = s;
    }

    public void setValue(float f) {
        this.value = f;
    }

    public void setValueAsString(String string) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            this.value = numberFormat.parse(string).floatValue();
            if (string.indexOf("grad") != -1) {
                this.value = (float)((double)this.value * 360.0 / 400.0);
            } else if (string.indexOf("rad") != -1) {
                this.value = (float)((double)this.value * 180.0 / Math.PI);
            }
        }
        catch (ParseException parseException) {
            this.value = 0.0f;
        }
    }

    public void setValueInSpecifiedUnits(float f) {
        switch (this.unitType) {
            case 0: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
            case 1: {
                throw new SVGExceptionImpl(0, "unknown unit type");
            }
        }
    }
}

