/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;

public class Character
extends FObj {
    public static final int OK = 0;
    public static final int DOESNOT_FIT = 1;

    public Character(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:character";
    }

    public Status layout(Area area) throws FOPException {
        BlockArea blockArea = (BlockArea)area;
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        int n2 = this.properties.get("font-variant").getEnum();
        FontState fontState = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        int n3 = this.properties.get("white-space-collapse").getEnum();
        int n4 = this.parent.properties.get("wrap-option").getEnum();
        int n5 = this.properties.get("text-decoration").getEnum();
        boolean bl = n5 == 2;
        char c = this.properties.get("character").getCharacter();
        String string4 = this.properties.get("id").getString();
        blockArea.getIDReferences().initializeID(string4, blockArea);
        LineArea lineArea = blockArea.getCurrentLineArea();
        if (lineArea == null) {
            return new Status(2);
        }
        lineArea.changeFont(fontState);
        lineArea.changeColor(f, f2, f3);
        lineArea.changeWrapOption(n4);
        lineArea.changeWhiteSpaceCollapse(n3);
        blockArea.setupLinkSet(this.getLinkSet());
        int n6 = lineArea.addCharacter(c, this.getLinkSet(), bl);
        if (n6 == 1) {
            lineArea = blockArea.createNextLineArea();
            if (lineArea == null) {
                return new Status(2);
            }
            lineArea.changeFont(fontState);
            lineArea.changeColor(f, f2, f3);
            lineArea.changeWrapOption(n4);
            lineArea.changeWhiteSpaceCollapse(n3);
            blockArea.setupLinkSet(this.getLinkSet());
            lineArea.addCharacter(c, this.getLinkSet(), bl);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Character(fObj, propertyList);
        }
    }
}

