/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableCell
extends FObj {
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    FontState fs;
    ColorType borderTopColor;
    int borderTopWidth;
    int borderTopStyle;
    ColorType borderBottomColor;
    int borderBottomWidth;
    int borderBottomStyle;
    ColorType borderLeftColor;
    int borderLeftWidth;
    int borderLeftStyle;
    ColorType borderRightColor;
    int borderRightWidth;
    int borderRightStyle;
    int paddingTop;
    int paddingBottom;
    int paddingLeft;
    int paddingRight;
    int position;
    String id;
    int numColumnsSpanned;
    int numRowsSpanned;
    protected int startOffset;
    protected int width;
    protected int height = 0;
    protected int top;
    protected int verticalAlign = 1;
    boolean setup = false;
    AreaContainer areaContainer;

    public TableCell(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-cell";
    }

    public void doSetup(Area area) throws FOPException {
        this.numColumnsSpanned = this.properties.get("number-columns-spanned").getNumber().intValue();
        this.numRowsSpanned = this.properties.get("number-rows-spanned").getNumber().intValue();
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        int n2 = this.properties.get("font-variant").getEnum();
        this.fs = new FontState(area.getFontInfo(), string, string2, string3, n, n2);
        this.borderBottomColor = this.borderTopColor = this.properties.get("border-color").getColorType();
        this.borderLeftColor = this.borderTopColor;
        this.borderRightColor = this.borderTopColor;
        if (this.borderTopColor == null) {
            this.borderTopColor = this.properties.get("border-top-color").getColorType();
            this.borderBottomColor = this.properties.get("border-bottom-color").getColorType();
            this.borderLeftColor = this.properties.get("border-left-color").getColorType();
            this.borderRightColor = this.properties.get("border-right-color").getColorType();
        }
        this.borderBottomWidth = this.borderTopWidth = this.properties.get("border-width").getLength().mvalue();
        this.borderLeftWidth = this.borderTopWidth;
        this.borderRightWidth = this.borderTopWidth;
        if (this.borderTopWidth == 0) {
            this.borderTopWidth = this.properties.get("border-top-width").getLength().mvalue();
            this.borderBottomWidth = this.properties.get("border-bottom-width").getLength().mvalue();
            this.borderLeftWidth = this.properties.get("border-left-width").getLength().mvalue();
            this.borderRightWidth = this.properties.get("border-right-width").getLength().mvalue();
        }
        this.borderBottomStyle = this.borderTopStyle = this.properties.get("border-style").getEnum();
        this.borderLeftStyle = this.borderTopStyle;
        this.borderRightStyle = this.borderTopStyle;
        if (this.borderTopStyle == 0) {
            this.borderTopStyle = this.properties.get("border-top-style").getEnum();
            this.borderBottomStyle = this.properties.get("border-bottom-style").getEnum();
            this.borderLeftStyle = this.properties.get("border-left-style").getEnum();
            this.borderRightStyle = this.properties.get("border-right-style").getEnum();
        }
        this.paddingLeft = this.paddingTop = this.properties.get("padding").getLength().mvalue();
        this.paddingRight = this.paddingTop;
        this.paddingBottom = this.paddingTop;
        if (this.paddingTop == 0) {
            this.paddingTop = this.properties.get("padding-top").getLength().mvalue();
            this.paddingLeft = this.properties.get("padding-left").getLength().mvalue();
            this.paddingBottom = this.properties.get("padding-bottom").getLength().mvalue();
            this.paddingRight = this.properties.get("padding-right").getLength().mvalue();
        }
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.id = this.properties.get("id").getString();
    }

    public int getHeight() {
        return this.areaContainer.getHeight() + this.spaceBefore + this.spaceAfter;
    }

    public int getNumColumnsSpanned() {
        return this.numColumnsSpanned;
    }

    public int getNumRowsSpanned() {
        return this.numRowsSpanned;
    }

    public Status layout(Area area) throws FOPException {
        int n = area.getAbsoluteHeight();
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            if (!this.setup) {
                this.doSetup(area);
            }
            if (area instanceof BlockArea) {
                area.end();
            }
            area.getIDReferences().createID(this.id);
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.increaseHeight(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, this.startOffset - area.borderWidthLeft, -area.borderWidthTop + (this.marker == 0 ? this.spaceBefore : 0), this.width, area.spaceLeft(), 2);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setPadding(this.paddingTop, this.paddingLeft, this.paddingBottom, this.paddingRight);
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderTopStyle, this.borderLeftStyle, this.borderBottomStyle, this.borderRightStyle);
        this.areaContainer.setBorderWidth(this.borderTopWidth, this.borderLeftWidth, this.borderBottomWidth, this.borderRightWidth);
        this.areaContainer.setBorderColor(this.borderTopColor, this.borderLeftColor, this.borderBottomColor, this.borderRightColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        this.areaContainer.setTableCellXOffset(this.startOffset);
        int n2 = this.children.size();
        int n3 = this.marker;
        while (n3 < n2) {
            FObj fObj = (FObj)this.children.elementAt(n3);
            fObj.setIsInTableCell();
            fObj.forceWidth(this.width);
            this.verticalAlign = fObj.properties.get("vertical-align").getEnum();
            Status status = fObj.layout(this.areaContainer);
            if (status.isIncomplete()) {
                this.marker = n3;
                if (n3 == 0 && status.getCode() == 2) {
                    return new Status(2);
                }
                area.addChild(this.areaContainer);
                area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                return new Status(3);
            }
            ++n3;
        }
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        this.height = this.areaContainer.getHeight();
        this.top = this.areaContainer.getCurrentYPosition();
        area.setHeight(this.areaContainer.getHeight() + this.spaceBefore + this.spaceAfter);
        area.setAbsoluteHeight(n);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setRowHeight(int n) {
        this.areaContainer.setMaxHeight(n);
        switch (this.verticalAlign) {
            case 2: {
                this.areaContainer.setHeight(this.height);
                this.areaContainer.setYPosition(this.spaceBefore + this.top + n / 2 - this.height / 2);
                break;
            }
            default: {
                this.areaContainer.setHeight(n - (this.spaceBefore + this.spaceAfter));
            }
        }
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableCell(fObj, propertyList);
        }
    }
}

