/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFFile;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TTFReader {
    private static final String XSL_POSTPROCESS = "TTFPostProcess.xsl";
    private static final String XSL_SORT = "TTFPostProcessSort.xsl";
    private boolean invokedStandalone = false;

    public Document constructFontXML(TTFFile tTFFile, String string, String string2, String string3, String string4) {
        Object object;
        System.out.println("Creating xml font file...");
        System.out.println();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("font-metrics");
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement("font-name");
        element.appendChild(element2);
        String string5 = tTFFile.getPostscriptName();
        if (string != null) {
            element2.appendChild(documentImpl.createTextNode(string));
        } else {
            element2.appendChild(documentImpl.createTextNode(string5.replace('-', ',')));
        }
        int n = string5.indexOf("-");
        if (n >= 0) {
            object = new char[string5.length() - 1];
            string5.getChars(0, n, (char[])object, 0);
            string5.getChars(n + 1, string5.length(), (char[])object, n);
            string5 = new String((char[])object);
        }
        element2 = documentImpl.createElement("class-name");
        element.appendChild(element2);
        if (string2 != null) {
            element2.appendChild(documentImpl.createTextNode(string2));
        } else {
            element2.appendChild(documentImpl.createTextNode(string5));
        }
        element2 = documentImpl.createElement("embedFile");
        element.appendChild(element2);
        if (string4 == null) {
            element2.appendChild(documentImpl.createTextNode("null"));
        } else {
            element2.appendChild(documentImpl.createTextNode("\"" + this.escapeString(string4) + "\""));
        }
        element2 = documentImpl.createElement("embedResource");
        element.appendChild(element2);
        if (string3 == null) {
            element2.appendChild(documentImpl.createTextNode("null"));
        } else {
            element2.appendChild(documentImpl.createTextNode("\"" + this.escapeString(string3) + "\""));
        }
        element2 = documentImpl.createElement("subtype");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode("TRUETYPE"));
        element2 = documentImpl.createElement("encoding");
        element.appendChild(element2);
        element2.appendChild(documentImpl.createTextNode(String.valueOf(tTFFile.getCharSetName()) + "Encoding"));
        element2 = documentImpl.createElement("cap-height");
        element.appendChild(element2);
        object = new Integer(tTFFile.getCapHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("x-height");
        element.appendChild(element2);
        object = new Integer(tTFFile.getXHeight());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("ascender");
        element.appendChild(element2);
        object = new Integer(tTFFile.getLowerCaseAscent());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("descender");
        element.appendChild(element2);
        object = new Integer(tTFFile.getLowerCaseDescent());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        Element element3 = documentImpl.createElement("bbox");
        element.appendChild(element3);
        int[] nArray = tTFFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        int n2 = 0;
        while (n2 < 4) {
            element2 = documentImpl.createElement(stringArray[n2]);
            element3.appendChild(element2);
            object = new Integer(nArray[n2]);
            element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
            ++n2;
        }
        element2 = documentImpl.createElement("flags");
        element.appendChild(element2);
        object = new Integer(tTFFile.getFlags());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("stemv");
        element.appendChild(element2);
        object = new Integer(tTFFile.getStemV());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("italicangle");
        element.appendChild(element2);
        object = new Integer(tTFFile.getItalicAngle());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("first-char");
        element.appendChild(element2);
        object = new Integer(tTFFile.getFirstChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        element2 = documentImpl.createElement("last-char");
        element.appendChild(element2);
        object = new Integer(tTFFile.getLastChar());
        element2.appendChild(documentImpl.createTextNode(((Integer)object).toString()));
        Element element4 = documentImpl.createElement("widths");
        element.appendChild(element4);
        short s = tTFFile.getFirstChar();
        while (s < tTFFile.getLastChar()) {
            element2 = documentImpl.createElement("char");
            element4.appendChild(element2);
            element2.setAttribute("name", "0x00" + Integer.toHexString(s).toUpperCase());
            element2.setAttribute("width", new Integer(tTFFile.getCharWidth(s)).toString());
            s = (short)(s + 1);
        }
        Enumeration enumeration = tTFFile.getKerning().keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            element2 = documentImpl.createElement("kerning");
            element2.setAttribute("kpx1", string6);
            element.appendChild(element2);
            Element element5 = null;
            Hashtable hashtable = (Hashtable)tTFFile.getKerning().get(string6);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string7 = (String)enumeration2.nextElement();
                element5 = documentImpl.createElement("pair");
                element5.setAttribute("kpx2", string7);
                Integer n3 = (Integer)hashtable.get(string7);
                element5.setAttribute("kern", n3.toString());
                element2.appendChild(element5);
            }
        }
        return documentImpl;
    }

    private static final void displayUsage() {
        System.out.println(" java org.apache.fop.fonts.apps.TTFReader [options] fontfile.ttf xmlfile.xml\n");
        System.out.println(" where options can be:\n");
        System.out.println(" -fn <fontname>\n");
        System.out.println("     default is to use the fontname in the .ttf file, but you can override\n");
        System.out.println("     that name to make sure that the embedded font is used instead of installed\n");
        System.out.println("     fonts when viewing documents with Acrobat Reader.\n");
        System.out.println(" -cn <classname>\n");
        System.out.println("     default is to use the fontname\n");
        System.out.println(" -ef <path to the truetype fontfile>\n");
        System.out.println("     will add the possibility to embed the font. When running fop, fop will look\n");
        System.out.println("     for this file to embed it\n");
        System.out.println(" -er <path to truetype fontfile relative to org/apache/fop/render/pdf/fonts>\n");
        System.out.println("     you can also include the fontfile in the fop.jar file when building fop.\n");
        System.out.println("     You can use both -ef and -er. The file specified in -ef will be searched first,\n");
        System.out.println("     then the -er file.\n");
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public TTFFile loadTTF(String string) {
        TTFFile tTFFile = new TTFFile();
        try {
            System.out.println("Reading " + string + "...");
            System.out.println();
            FontFileReader fontFileReader = new FontFileReader(string);
            tTFFile.readFont(fontFileReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return tTFFile;
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable hashtable = new Hashtable();
        String[] stringArray2 = TTFReader.parseArguments(hashtable, stringArray);
        TTFReader tTFReader = new TTFReader();
        tTFReader.invokedStandalone = true;
        System.out.println("TTF Reader v1.0");
        System.out.println();
        if (hashtable.get("-ef") != null) {
            string = (String)hashtable.get("-ef");
        }
        if (hashtable.get("-er") != null) {
            string2 = (String)hashtable.get("-er");
        }
        if (hashtable.get("-fn") != null) {
            string4 = (String)hashtable.get("-fn");
        }
        if (hashtable.get("-cn") != null) {
            string3 = (String)hashtable.get("-cn");
        }
        if (stringArray2.length != 2 || hashtable.get("-h") != null || hashtable.get("-help") != null || hashtable.get("--help") != null) {
            TTFReader.displayUsage();
        } else {
            TTFFile tTFFile = tTFReader.loadTTF(stringArray2[0]);
            if (tTFFile != null) {
                tTFReader.preview(tTFFile);
                Document document = tTFReader.constructFontXML(tTFFile, string4, string3, string2, string);
                document = tTFReader.postProcessXML(document);
                if (document != null) {
                    tTFReader.writeFontXML(document, stringArray2[1]);
                }
            }
        }
    }

    private static String[] parseArguments(Hashtable hashtable, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (++n < stringArray.length) {
                    hashtable.put(stringArray[n - 1], stringArray[n]);
                } else {
                    hashtable.put(stringArray[n - 1], "");
                }
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Document postProcessXML(Document document) {
        return document;
    }

    public void preview(TTFFile tTFFile) {
        PrintStream printStream = System.out;
        printStream.print("Font: ");
        printStream.println(tTFFile.getWindowsName());
        printStream.print("Name: ");
        printStream.println(tTFFile.getPostscriptName());
        printStream.print("CharSet: ");
        printStream.println(tTFFile.getCharSetName());
        printStream.print("CapHeight: ");
        printStream.println(tTFFile.getCapHeight());
        printStream.print("XHeight: ");
        printStream.println(tTFFile.getXHeight());
        printStream.print("LowerCaseAscent: ");
        printStream.println(tTFFile.getLowerCaseAscent());
        printStream.print("LowerCaseDescent: ");
        printStream.println(tTFFile.getLowerCaseDescent());
        printStream.print("Having widths for ");
        printStream.print(tTFFile.getLastChar() - tTFFile.getFirstChar());
        printStream.print(" characters (");
        printStream.print(tTFFile.getFirstChar());
        printStream.print("-");
        printStream.print(tTFFile.getLastChar());
        printStream.println(").");
        printStream.print("for example: Char ");
        printStream.print(tTFFile.getFirstChar());
        printStream.print(" has a width of ");
        printStream.println(tTFFile.getCharWidth(tTFFile.getFirstChar()));
        printStream.println();
        if (tTFFile.isEmbeddable()) {
            printStream.println("This font might be embedded");
        } else {
            printStream.println("This font might not be embedded");
        }
    }

    public void writeFontXML(Document document, String string) {
        System.out.println("Writing xml font file " + string + "...");
        System.out.println();
        try {
            OutputFormat outputFormat = new OutputFormat(document);
            FileWriter fileWriter = new FileWriter(string);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

