/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.CategoryFactory;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootCategory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Category
implements AppenderAttachable {
    public static final Hierarchy defaultHierarchy = new Hierarchy(new RootCategory(Priority.DEBUG));
    public static final String DEFAULT_CONFIGURATION_FILE = "log4j.properties";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    protected String name;
    protected volatile Priority priority;
    protected volatile Category parent;
    private static final String FQCN;
    protected ResourceBundle resourceBundle;
    protected Hierarchy hierarchy;
    AppenderAttachableImpl aai;
    protected boolean additive = true;
    static /* synthetic */ Class class$org$apache$log4j$Category;

    protected Category(String name) {
        this.name = name;
    }

    public synchronized void addAppender(Appender newAppender) {
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(newAppender);
    }

    public void assert(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        Category c = this;
        while (c != null) {
            Category category = c;
            synchronized (category) {
                if (c.aai != null) {
                    writes += c.aai.appendLoopOnAppenders(event);
                }
                if (!c.additive) {
                    break;
                }
            }
            c = c.parent;
        }
        if (!this.hierarchy.emittedNoAppenderWarning && writes == 0) {
            LogLog.error("No appenders could be found for category (" + this.getName() + ").");
            LogLog.error("Please initialize the log4j system properly.");
            this.hierarchy.emittedNoAppenderWarning = true;
        }
    }

    synchronized void closeNestedAppenders() {
        Enumeration enumeration = this.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Appender a = (Appender)enumeration.nextElement();
                if (!(a instanceof AppenderAttachable)) continue;
                a.close();
            }
        }
    }

    public void debug(Object message) {
        if (this.hierarchy.disable >= 10000) {
            return;
        }
        if (Priority.DEBUG.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, Priority.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.hierarchy.disable >= 10000) {
            return;
        }
        if (this.isEnabledFor(Priority.DEBUG)) {
            this.forcedLog(FQCN, Priority.DEBUG, message, t);
        }
    }

    public void error(Object message) {
        if (this.hierarchy.disable >= 40000) {
            return;
        }
        if (this.isEnabledFor(Priority.ERROR)) {
            this.forcedLog(FQCN, Priority.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.hierarchy.disable >= 40000) {
            return;
        }
        if (this.isEnabledFor(Priority.ERROR)) {
            this.forcedLog(FQCN, Priority.ERROR, message, t);
        }
    }

    public static Category exists(String name) {
        return defaultHierarchy.exists(name);
    }

    public void fatal(Object message) {
        if (this.hierarchy.disable >= 50000) {
            return;
        }
        if (Priority.FATAL.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, Priority.FATAL, message, null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.hierarchy.disable >= 50000) {
            return;
        }
        if (Priority.FATAL.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, Priority.FATAL, message, t);
        }
    }

    protected void forcedLog(String fqcn, Priority priority, Object message, Throwable t) {
        this.callAppenders(new LoggingEvent(fqcn, this, priority, message, t));
    }

    public boolean getAdditivity() {
        return this.additive;
    }

    public synchronized Enumeration getAllAppenders() {
        if (this.aai == null) {
            return NullEnumeration.getInstance();
        }
        return this.aai.getAllAppenders();
    }

    public synchronized Appender getAppender(String name) {
        if (this.aai == null || name == null) {
            return null;
        }
        return this.aai.getAppender(name);
    }

    public Priority getChainedPriority() {
        Category c = this;
        while (c != null) {
            if (c.priority != null) {
                return c.priority;
            }
            c = c.parent;
        }
        return null;
    }

    public static Enumeration getCurrentCategories() {
        return defaultHierarchy.getCurrentCategories();
    }

    public static Hierarchy getDefaultHierarchy() {
        return defaultHierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public static Category getInstance(String name) {
        return defaultHierarchy.getInstance(name);
    }

    public static Category getInstance(Class clazz) {
        return Category.getInstance(clazz.getName());
    }

    public static Category getInstance(String name, CategoryFactory factory) {
        return defaultHierarchy.getInstance(name, factory);
    }

    public final String getName() {
        return this.name;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public static final Category getRoot() {
        return defaultHierarchy.getRoot();
    }

    public ResourceBundle getResourceBundle() {
        Category c = this;
        while (c != null) {
            if (c.resourceBundle != null) {
                return c.resourceBundle;
            }
            c = c.parent;
        }
        return null;
    }

    protected String getResourceBundleString(String key) {
        ResourceBundle rb = this.getResourceBundle();
        if (rb == null) {
            if (!this.hierarchy.emittedNoResourceBundleWarning) {
                this.error("No resource bundle has been set for category " + this.name);
                this.hierarchy.emittedNoResourceBundleWarning = true;
            }
            return null;
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException mre) {
            this.error("No resource is associated with key \"" + key + "\".");
            return null;
        }
    }

    public void info(Object message) {
        if (this.hierarchy.disable >= 20000) {
            return;
        }
        if (Priority.INFO.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, Priority.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.hierarchy.disable >= 20000) {
            return;
        }
        if (Priority.INFO.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, Priority.INFO, message, t);
        }
    }

    public boolean isDebugEnabled() {
        if (this.hierarchy.disable >= 10000) {
            return false;
        }
        return Priority.DEBUG.isGreaterOrEqual(this.getChainedPriority());
    }

    public boolean isEnabledFor(Priority priority) {
        if (this.hierarchy.disable >= priority.level) {
            return false;
        }
        return priority.isGreaterOrEqual(this.getChainedPriority());
    }

    public boolean isInfoEnabled() {
        if (this.hierarchy.disable >= 20000) {
            return false;
        }
        return Priority.INFO.isGreaterOrEqual(this.getChainedPriority());
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        if (this.hierarchy.disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            String msg = this.getResourceBundleString(key);
            if (msg == null) {
                msg = key;
            }
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        if (this.hierarchy.disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            String pattern = this.getResourceBundleString(key);
            String msg = pattern == null ? key : MessageFormat.format(pattern, params);
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (this.hierarchy.disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, priority, message, t);
        }
    }

    public void log(Priority priority, Object message) {
        if (this.hierarchy.disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(FQCN, priority, message, null);
        }
    }

    public void log(String callerFQCN, Priority priority, Object message, Throwable t) {
        if (this.hierarchy.disable >= priority.level) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getChainedPriority())) {
            this.forcedLog(callerFQCN, priority, message, t);
        }
    }

    public synchronized void removeAllAppenders() {
        if (this.aai != null) {
            this.aai.removeAllAppenders();
            this.aai = null;
        }
    }

    public synchronized void removeAppender(Appender appender) {
        if (appender == null || this.aai == null) {
            return;
        }
        this.aai.removeAppender(appender);
    }

    public synchronized void removeAppender(String name) {
        if (name == null || this.aai == null) {
            return;
        }
        this.aai.removeAppender(name);
    }

    public void setAdditivity(boolean additive) {
        this.additive = additive;
    }

    final void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundle = bundle;
    }

    public static void shutdown() {
        defaultHierarchy.shutdown();
    }

    public void warn(Object message) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.forcedLog(FQCN, Priority.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isEnabledFor(Priority.WARN)) {
            this.forcedLog(FQCN, Priority.WARN, message, t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String override = OptionConverter.getSystemProperty(DEFAULT_INIT_OVERRIDE_KEY, null);
        if (override == null || "false".equalsIgnoreCase(override)) {
            String resource = OptionConverter.getSystemProperty(DEFAULT_CONFIGURATION_KEY, DEFAULT_CONFIGURATION_FILE);
            URL url = null;
            try {
                url = new URL(resource);
            }
            catch (MalformedURLException ex) {
                url = Loader.getResource(resource, class$org$apache$log4j$Category == null ? (class$org$apache$log4j$Category = Category.class$("org.apache.log4j.Category")) : class$org$apache$log4j$Category);
            }
            if (url != null) {
                LogLog.debug("Using URL [" + url + "] for automatic log4j configuration.");
                OptionConverter.selectAndConfigure(url, defaultHierarchy);
            } else {
                LogLog.debug("Could not find resource: [" + resource + "].");
            }
        }
        FQCN = (class$org$apache$log4j$Category == null ? (class$org$apache$log4j$Category = Category.class$("org.apache.log4j.Category")) : class$org$apache$log4j$Category).getName();
    }
}

