#ifndef __stringheap_H
#define __stringheap_H
/*
 * Copyright (c) 2003 Stephen Williams (steve@icarus.com)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ifdef HAVE_CVS_IDENT
#ident "$Id: stringheap.h,v 1.1 2003/02/13 18:13:28 steve Exp $"
#endif

struct stringheap_cell;

struct stringheap_s {
      struct stringheap_cell*cell_lst;
      unsigned cell_off;
};

/*
 * Allocate the string from the heap.
 */
const char*strdup_sh(struct stringheap_s*hp, const char*str);

/*
 * $Log: stringheap.h,v $
 * Revision 1.1  2003/02/13 18:13:28  steve
 *  Make lxt use stringheap to perm-allocate strings.
 *
 */
#endif
