/*
		     VMA Editor - Text Dialog

	For editing text in models and comment primtiives.
 */

#ifndef EDITORTDIALOG_H
#define EDITORTDIALOG_H

#include <gtk/gtk.h>
#include "editor.h"

extern void EditorTDialogSetValues(
	ma_editor_tdialog_struct *d,  
	int model_num,  
	int primitive_num  
);
extern void EditorTDialogClear(ma_editor_tdialog_struct *d);
extern void EditorTDialogFetch(
	ma_editor_struct *editor, ma_editor_tdialog_struct *d 
);
extern void EditorTDialogApply(
	ma_editor_struct *editor, ma_editor_tdialog_struct *d
);

extern gbool EditorTDialogDoFind(
	ma_editor_tdialog_struct *d, GtkText *text,
	char *haystack, char *needle,
	int haystack_len, int start_pos,
	gbool case_sensitive,
	gbool move_to,
	gbool *search_wrapped
);

extern int EditorTDialogCreate(
	ma_editor_struct *editor, ma_editor_tdialog_struct *d
);
extern void EditorTDialogReset(
	ma_editor_tdialog_struct *d, gbool need_unmap
);
extern void EditorTDialogUpdateAppearance(ma_editor_tdialog_struct *d);
extern void EditorTDialogUpdateMenus(ma_editor_tdialog_struct *d);
extern void EditorTDialogDestroy(
	ma_editor_struct *editor, ma_editor_tdialog_struct *d
);

#endif	/* EDITORTDIALOG_H */
