/*****
This file is part of the Babel Program
Copyright (C) 1992-96 W. Patrick Walters and Matthew T. Stahl 
All Rights Reserved 
All Rights Reserved 
All Rights Reserved 
All Rights Reserved 

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : wrvm.c
AUTHOR(S) : Jrg-Rdiger Hill
DATE : 1-99
PURPOSE : Routines to write a Viewmol type file.

******/


#include "bbltyp.h"

int
  write_viewmol(FILE *file1, ums_type *mol)
{
  int i,j;
  char type_name[5];
  int result;

  if (strlen(Title) > 0)
    fprintf(file1,"$title\n%s\n",Title);
  fprintf(file1,"$coord 1.0\n");

  for (i = 1; i <= Atoms; i ++)
  {
    result =  get_output_type(i,"XYZ",Type(i),type_name,all_caps);

    fprintf(file1,"%22.14f%22.14f%22.14f %s\n",
	      X(i),
	      Y(i),
	      Z(i),
	      type_name);
  }
  fprintf(file1,"$end\n");
  return(TRUE);
}
