/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;

public class PixelFormat {
    public int bpp;
    public int depth;
    public boolean bigEndian;
    public boolean trueColour;
    public int redMax;
    public int greenMax;
    public int blueMax;
    public int redShift;
    public int greenShift;
    public int blueShift;

    public boolean equal(PixelFormat pixelFormat) {
        return this.bpp == pixelFormat.bpp && this.depth == pixelFormat.depth && (this.bigEndian == pixelFormat.bigEndian || this.bpp == 8) && this.trueColour == pixelFormat.trueColour && (!this.trueColour || this.redMax == pixelFormat.redMax && this.greenMax == pixelFormat.greenMax && this.blueMax == pixelFormat.blueMax && this.redShift == pixelFormat.redShift && this.greenShift == pixelFormat.greenShift && this.blueShift == pixelFormat.blueShift);
    }

    public void read(InStream inStream) {
        this.bpp = inStream.readU8();
        this.depth = inStream.readU8();
        this.bigEndian = inStream.readU8() != 0;
        this.trueColour = inStream.readU8() != 0;
        this.redMax = inStream.readU16();
        this.greenMax = inStream.readU16();
        this.blueMax = inStream.readU16();
        this.redShift = inStream.readU8();
        this.greenShift = inStream.readU8();
        this.blueShift = inStream.readU8();
        inStream.skip(3);
    }

    public void write(OutStream outStream) {
        outStream.writeU8(this.bpp);
        outStream.writeU8(this.depth);
        outStream.writeU8(this.bigEndian ? 1 : 0);
        outStream.writeU8(this.trueColour ? 1 : 0);
        outStream.writeU16(this.redMax);
        outStream.writeU16(this.greenMax);
        outStream.writeU16(this.blueMax);
        outStream.writeU8(this.redShift);
        outStream.writeU8(this.greenShift);
        outStream.writeU8(this.blueShift);
        outStream.pad(3);
    }

    public String print() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("depth " + this.depth + " (" + this.bpp + "bpp)");
        if (this.bpp != 8) {
            if (this.bigEndian) {
                stringBuffer.append(" big-endian");
            } else {
                stringBuffer.append(" little-endian");
            }
        }
        if (!this.trueColour) {
            stringBuffer.append(" colour-map");
            return stringBuffer.toString();
        }
        if (this.blueShift == 0 && this.greenShift > this.blueShift && this.redShift > this.greenShift && this.blueMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.redShift - this.greenShift) - 1 && this.redMax == (1 << this.depth - this.redShift) - 1) {
            stringBuffer.append(" rgb" + (this.depth - this.redShift) + (this.redShift - this.greenShift) + this.greenShift);
            return stringBuffer.toString();
        }
        if (this.redShift == 0 && this.greenShift > this.redShift && this.blueShift > this.greenShift && this.redMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.blueShift - this.greenShift) - 1 && this.blueMax == (1 << this.depth - this.blueShift) - 1) {
            stringBuffer.append(" bgr" + (this.depth - this.blueShift) + (this.blueShift - this.greenShift) + this.greenShift);
            return stringBuffer.toString();
        }
        stringBuffer.append(" rgb max " + this.redMax + "," + this.greenMax + "," + this.blueMax + " shift " + this.redShift + "," + this.greenShift + "," + this.blueShift);
        return stringBuffer.toString();
    }

    public PixelFormat(int n, int n2, boolean bl, boolean bl2) {
        this.bpp = n;
        this.depth = n2;
        this.bigEndian = bl;
        this.trueColour = bl2;
    }

    public PixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n, n2, bl, bl2);
        this.redMax = n3;
        this.greenMax = n4;
        this.blueMax = n5;
        this.redShift = n6;
        this.greenShift = n7;
        this.blueShift = n8;
    }

    public PixelFormat() {
        this(8, 8, false, true, 7, 7, 3, 0, 3, 6);
    }
}

