
// vbio.h
// environment and db class, wrapper of Berkeley DB's native DbEnv and Db classes
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Dongbo Hu

#ifndef MYDB_H
#define MYDB_H

#include <string>
#include <db_cxx.h>
#include "typedefs.h"

// myEnv definition
class myEnv 
{
 public:
  myEnv();
  myEnv(const std::string&);
  ~myEnv() { close(); }

  DbEnv& getEnv() { return env; }
  int open(const std::string&);
  int open();
  int close();
  bool isOpen() { return stat; }

 private:
  DbEnv env;
  std::string envDir;
  bool stat;
  static const uint32 log_size;
};

// myDB definition
class myDB
{
 public:
  enum key_comp { cmp_int, cmp_lex };
  enum dup_flag { no_dup, sort_default, sort_int };

  myDB();

  // ctor for transactional db, which includes an env argument
  myDB(const std::string&, myEnv&, key_comp = cmp_int, dup_flag = no_dup, DBTYPE = DB_BTREE);

  // ctor for non-transactional db (w/o environment, but db open flags is specified)
  myDB(const std::string&, key_comp = cmp_int, dup_flag = no_dup, 
       u_int32_t = DB_CREATE, DBTYPE = DB_BTREE);

  ~myDB() { close(); } 

  // open db in transactional environment (should be called after default ctor)
  int open(const std::string&, myEnv&, key_comp = cmp_int, dup_flag = no_dup, DBTYPE = DB_BTREE);

  int open(const std::string&,  key_comp = cmp_int, dup_flag = no_dup, 
	   u_int32_t openFlag = DB_CREATE, DBTYPE = DB_BTREE);

  void init();
  int close();

  Db& getDb() { return *dbp; }
  bool isOpen() { return stat; }
  int32 countRec();

 private:
  Db* dbp;
  std::string filename;
  bool stat;
};

/* functions for myDB key comparision */
int compare_int(Db*, const Dbt*, const Dbt*);       // recommended version
int compare_int_deprc(DB*, const DBT*, const DBT*); // DB and DBT are deprecated
int compare_str2int(DB*, const DBT*, const DBT*);   // DB and DBT are deprecated

int dupsort_int(Db*, const Dbt*, const Dbt*);

#endif
