
// vbthreshcalc.cpp
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Dan Kimberg and expanded by Tom King
// based on algorithms implemented by Keith Worsley
// copyright notice for original Worsley code (not included) reproduced below

/******************************************************************************
* COPYRIGHT:   Copyright 2003 K.J. Worsley                                    *
*              Department of Mathematics and Statistics,                      *
*              McConnell Brain Imaging Center,                                *
*              Montreal Neurological Institute,                               *
*              McGill University, Montreal, Quebec, Canada.                   *
*              keith.worsley@mcgill.ca , www.math.mcgill.ca/keith             *
*                                                                             *
*              Permission to use, copy, modify, and distribute this           *
*              software and its documentation for any purpose and without     *
*              fee is hereby granted, provided that this copyright            *
*              notice appears in all copies. The author and McGill University *
*              make no representations about the suitability of this          *
*              software for any purpose.  It is provided "as is" without      *
*              express or implied warranty.                                   *
******************************************************************************/

#include <map>
#include <fstream>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_cdf.h>
#include <math.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_sf_gamma.h>
#include "vbio.h"
#include "glmutil.h"
#include "gsl/gsl_complex.h"
#include "gsl/gsl_complex_math.h"
#include "statthreshold.h"
#include "vbthreshcalc.hlp.h"

using namespace std;

void vbthreshcalc_help();

int
main(int argc,char *argv[])
{
  threshold v;  
  v.searchVolume = 0;
  v.numVoxels = 0;
  v.fwhm = 0.0;
  v.pValPeak = 0;
  v.clusterThreshold = 0;
  v.pValExtent = 0;
  v.nconj = 0;
  v.nvar = 0;
  v.EC_FILE =  "";
  v.transform = 0;
  
  if (argc == 1) {
    vbthreshcalc_help();
    exit(0);
  }
  arghandler a;
  a.parseArgs(argc, argv);
  tokenlist temp = a.getUnflaggedArgs();
  v.searchVolume =  atol(temp[0].c_str());
  v.numVoxels = atol(temp[1].c_str());
  v.fwhm = atof(temp[2].c_str());
  tokenlist degFree;
  degFree.ParseLine(temp[3].c_str());
  if (degFree.size()==2) {
     if (atof(degFree[1].c_str())) {
        v.df[0] = atof(degFree[0].c_str());
        v.df[1] = atof(degFree[1].c_str());
        if (v.df[1]==0) v.df[1]=FLT_MAX;
     }
     else {
        v.df[1] = atof(degFree[0].c_str());
        v.df[0] = atof(degFree[1].c_str());
     }
  }
  else {
     for (int num=0;num<4;num++)
         v.df[num]=FLT_MAX;
     for (int num=0;num<degFree.size();num++)
         v.df[num]=atof(degFree[num].c_str());
  }
  tokenlist tpValPeak;
  tpValPeak.ParseLine(temp[4].c_str());
  v.pValPeak = gsl_vector_calloc((int)tpValPeak.size());
  for (int num = 0; num < tpValPeak.size(); num++)
      gsl_vector_set(v.pValPeak, num, atof(tpValPeak[num].c_str()));
  v.clusterThreshold = atof(temp[5].c_str());
  tokenlist tpValExtent;
  tpValExtent.ParseLine(temp[6].c_str());
  v.pValExtent = gsl_vector_calloc((int)tpValExtent.size());
  for (int num = 0; num < tpValExtent.size(); num++)
      gsl_vector_set(v.pValExtent, num, atof(tpValExtent[num].c_str()));
  v.nconj = atoi(temp[7].c_str());
  v.nvar = atoi(temp[8].c_str());
  v.EC_FILE = temp[9].c_str();
  v.transform = 0.0; //atof(temp[10].c_str());

/*
cout << "searchVolume: " << v.searchVolume << endl;
cout << "numVoxels: " << v.numVoxels << endl;
cout << "fwhm: " << v.fwhm << endl;
cout << "df" << endl;
for (int i = 0; i < 4; i++)
   cout << "df" << i << ": " << v.df[i] << endl;
cout << "pValPeak: " << endl;
for (int i = 0; i < (int)v.pValPeak->size; i++)
    cout << i << " " << gsl_vector_get(v.pValPeak, i) << endl;
cout << "cluster threshold: " << v.clusterThreshold << endl;
for (int i = 0; i < (int)v.pValExtent->size; i++)
    cout << i << " " << gsl_vector_get(v.pValExtent, i) << endl;
cout << "nconj: " << v.nconj << endl;
cout << "nvar: " << v.nvar << endl;
cout << "EC_FILE: " << v.EC_FILE << endl;
cout << "transform: " << v.transform << endl;
*/ 
  v.peakthreshold = gsl_vector_calloc((int)v.pValPeak->size);
  v.pvalpeak = gsl_vector_calloc((int)v.pValPeak->size);
  v.bonpeakthreshold = gsl_vector_calloc((int)v.pValPeak->size);
  v.bonpvalpeak = gsl_vector_calloc((int)v.pValPeak->size);
  v.clusterthreshold = gsl_vector_calloc(1);
  v.peakthreshold1 = gsl_vector_calloc((int)v.pValPeak->size);
  v.pvalpeak1 = gsl_vector_calloc((int)v.pValPeak->size);
  v.extentthreshold = gsl_vector_calloc((int)v.pValPeak->size);
  v.extentthreshold1 = gsl_vector_calloc((int)v.pValPeak->size);
  v.pvalextent = gsl_vector_calloc((int)v.pValPeak->size);
  v.pvalextent1 = gsl_vector_calloc((int)v.pValPeak->size);

  int err = stat_threshold(v);

  for (int i = 0; i < (int)v.pvalpeak->size; i++)
      if (gsl_vector_get(v.peakthreshold, i) != 0 || gsl_vector_get(v.pvalpeak, i) == 0)
         cout << "random field theory peak threshold#" << setprecision(20) << i+1 << " " << gsl_vector_get(v.peakthreshold, i) << endl;
      else
         cout << "random field theory p value peak#" << setprecision(20) << i+1 << " " << gsl_vector_get(v.pvalpeak, i) << endl;
  for (int i = 0; i < (int)v.bonpvalpeak->size; i++)
      if (gsl_vector_get(v.bonpeakthreshold, i) != 0 || gsl_vector_get(v.pvalpeak, i) == 0)
         cout << "bonferonni peak threshold#" << setprecision(20) << i+1 << " " << gsl_vector_get(v.bonpeakthreshold, i) << endl;
      else
         cout << "bonferonni pvalpeak#" << setprecision(20) << i+1 << " " << gsl_vector_get(v.pvalpeak, i) << endl;
  for (int i = 0; i < (int)v.clusterthreshold->size; i++)
      cout << "clusterthreshold#" << setprecision(20) << i << " " << gsl_vector_get(v.clusterthreshold, i) << endl;
  for (int i = 0; i < (int)v.pvalpeak1->size; i++)
      if (gsl_vector_get(v.peakthreshold1, i) != 0 || gsl_vector_get(v.pvalpeak1, i) == 0)
         cout << "peakthreshold1#" << setprecision(20) << i << " " << gsl_vector_get(v.peakthreshold1, i) << endl;
      else
         cout << "pvalpeak_1#" << setprecision(20) << i << " " << gsl_vector_get(v.pvalpeak1, i) << endl;
  for (int i = 0; i < (int)v.pvalpeak1->size; i++)
      if (gsl_vector_get(v.extentthreshold, i) != 0 || gsl_vector_get(v.pvalextent, i) == 0)
         cout << "extentthreshold#" << setprecision(20) << i << " " << gsl_vector_get(v.extentthreshold, i) << endl;
      else
         cout << "pvalextent#" << setprecision(20) << i << " " << gsl_vector_get(v.pvalextent, i) << endl;
  for (int i = 0; i < (int)v.pvalpeak1->size; i++)
      if (gsl_vector_get(v.extentthreshold1, i) != 0 || gsl_vector_get(v.pvalextent1, i) == 0)
         cout << "extentthreshold1#" << setprecision(20) << i << " " << gsl_vector_get(v.extentthreshold1, i) << endl;
      else
         cout << "pvalextent1#" << setprecision(20) << i << " " << gsl_vector_get(v.pvalextent1, i) << endl;

  string errormsg="an error occurred on line "+strnum(err);
  printf("[E] vbthreshcalc: %s\n",errormsg.c_str());

  if (v.pValPeak) gsl_vector_free(v.pValPeak);
  if (v.pValExtent) gsl_vector_free(v.pValExtent);
  if (v.peakthreshold) gsl_vector_free(v.peakthreshold);
  if (v.pvalpeak) gsl_vector_free(v.pvalpeak);
  if (v.bonpeakthreshold) gsl_vector_free(v.bonpeakthreshold);
  if (v.bonpvalpeak) gsl_vector_free(v.bonpvalpeak);
  if (v.clusterthreshold) gsl_vector_free(v.clusterthreshold);
  if (v.peakthreshold1) gsl_vector_free(v.peakthreshold1);
  if (v.pvalpeak1) gsl_vector_free(v.pvalpeak1);
  if (v.extentthreshold) gsl_vector_free(v.extentthreshold);
  if (v.extentthreshold1) gsl_vector_free(v.extentthreshold1);
  if (v.pvalextent) gsl_vector_free(v.pvalextent);
  if (v.pvalextent1) gsl_vector_free(v.pvalextent1);

  return err; 
}

void
vbthreshcalc_help()
{
  cout << boost::format(myhelp) % vbversion;
}
