/* ==================================================== ======== ======= *
 *
 *  gui.cc : generic interface and callback functions for the VREng GUI
 *  NOTE: this file should be common to all GUI variants
 *
 *  VREng Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef VRENGD

#include "guimisc.h"

#include "global.h"
#include "world.h"
#include "keys.h"
#include "net.h"
#include "wobject.h"
#include "defaults.h"
#include "user.h"

#include "zv.h"		/* Solid */
#include "channel.h"	/* newChannel */
#include "helpers.h"

#include "gui.h"
#include "guiImpl.hh"
#include "widgets.hh"


#define NN(s) ((s) ? (s) : "")

// variable (malheureussement!) globale - initialisee par GuiCreateMainWindow
VRengResources resources;

// variable (heureusement) privee qui contient les donnees de la GUI

//!!!!!!DEVRAIT ETRE STATIC MAIS COMME vnc.cc EST ECRIT N'IMPORTE COMMENT 
//!!!!!!CE FICHIER VA BIDOUILLER DANS CETTE VAR POUR Y FAIRE DIEU SAIT QUOI
// --> te laisse pas faire Philou, casse leur la bobine a ces zozos !!!

//d'autre part c'est la fct principale qui devrait faire: new GUI()
//et stocker ce ptr qq part de maniere safe
GUI gui;


GUI::GUI() {
  sceneInitialized = FALSE;  //NEW!
  readyAndVisible = FALSE;
  cycles = 0;
  appli = NULL;
  guiWidgets = NULL;
  display = NULL;
  appContext = NULL; //TMP: will be removed soon
#ifndef WANT_UBIT
  toplevel = NULL;
  appWidth = appHeight = 0;
#endif
  inputTable[0] = inputTable[1] = NULL;
  postponedKRmask = 0;
  postponedKRcount = 0;

  glwin = None;
  glvisual = NULL;

  current_solid = NULL; // the solid that is currently selected
  gui.vrengInitCB = NULL;
}


void GuiInitAndGetResources(int argc, char *argv[]) {

  /* Parse command line args */
  extern char *optarg;
  extern int optind;
  int c;

  resources.version = VERSION;
  resources.world = NULL;
  resources.multicast = NULL;
  resources.nick = NULL;
  resources.skinf = strdup(DEF_FRONT_GIF);
  resources.skinb = strdup(DEF_BACK_GIF);
  // size of the GL rendering window
  resources.width3D = DEF_WIDTH3D;
  resources.height3D = DEF_HEIGHT3D;

  resources.debug = 0;
  resources.quality = 0;
  resources.maxsimcon = DEF_MAXSIMCON;
  resources.histlength = 32;

  while ((c = getopt(argc, argv, "?hv2d:q:w:c:n:")) != -1) {
    switch (c) {
      case '?':
      case 'h':
        fprintf(stderr, "%s\n", HELPSTRING);
        exit(0);
      case 'v':
        printf("%s\n", VERSION);
        exit(0);
      case 'd':
        debug = atoi(optarg);
        resources.debug = debug;
        break;
      case 'q':
        resources.quality = atoi(optarg);
        break;
      case 'w':
        resources.world = strdup(optarg);
        break;
      case 'c':
        resources.multicast = strdup(optarg);
        break;
      case 'n':
        resources.nick = strdup(optarg);
        break;
      case '2':
        resources.width3D *= 2;
        resources.height3D *= 2;
        break;
    }
  }
  if (optind < argc) {
    fprintf(stderr, "%s\n", HELPSTRING);
    exit(1);
  }

  if (resources.world == NULL)
    resources.world = strdup(DEF_URL_CFG);
  if (resources.multicast == NULL)
    resources.multicast = strdup(DEF_VRE_CHANNEL);
  // nickname
  if (resources.nick == NULL) {
    struct passwd *pwd = getpwuid(getuid());
    resources.nick = strdup(pwd->pw_name);
  }


  // creates the toplevel of the appli and initializes the VREng 'resources'
  gui.createToplevel(argc, argv, GuiWidgets::getFallbackResources());

  // creates the widgets of the GUI and initializes the glwin position
  // NB: the toplevel must have been be created with correct depth and colormap
  gui.guiWidgets = new GuiWidgets(gui);

  /*initializes X vars, Xt TimeOuts and GLX window */
  gui.initX();
}


// prend une fct. en arg. qui sera lancee apres l'ouverture de la fenetre
//
void GuiMainLoop( void (*initCB)(void) ) {
  gui.vrengInitCB = initCB;
  //DAX gui.guiWidgets->addWorld("world", TRUE);   // a defaut de mieux !
  gui.mainLoop();
}


int GuiGetCycles(void) {
  return gui.cycles;
}

void GuiWriteMessage(const char *mode, const char *from, const char *mess) {
  // printf("GuiWriteMessage: [%s] %s> %s\n", mode, (from?from:""), mess);
  gui.guiWidgets->writeMessage(mode, from, mess);
}

void GuiSetBusy(boolean state) {	/* sets the 'busy' cursor */
  printf("GuiSetBusy: state=%d\n", state);
}

void GuiInProgess(int progress){   /* indicates work progress. value from 0 to 100 */
  printf("GuiInProgess: progress=%d\n", progress);
}

/*NOTE: table_no=0 for tab_fd / table_no=1 for tab_manager_fd */
void GuiAddInputTable(int table_count, int *table, int table_no) {
  gui.addInputTable(table_count, table, table_no);
}

void GuiRemoveInputTable(int table_count, int table_no) {
  gui.removeInputTable(table_count, table_no);
}


/* nouvelles fct. qui remplacent memberJoining, memberQuitting, updateMemberWorld, userLogging, userLoggingOut */

void * GuiAddUser(User *user) { 	// when a new user comes in
  if (!user) {
    warning("GuiAddUser: NULL user!");
    return NULL;
  }
  notice("Avatar %s joins %s", NN(user->name.instance_name), NN(user->name.world_name));
  return gui.guiWidgets->addUser(user);
}

void GuiRemoveUser(User *user) {	// when an user quits
  if (!user) {
    warning("GuiRemoveUser: NULL user!");
    return;
  }
  notice("Avatar %s leaves %s", NN(user->name.instance_name), NN(user->name.world_name));
  if (user->ptrgui) {
    gui.guiWidgets->removeUser((GuiUser)user->ptrgui);
    // M.S. : for Ubit at least, removeUser does a delete on
    // the ptrgui structure. Safer to mark it a NULL than to
    // carry an invalid pointer around.
    user->ptrgui = NULL;
  }
}

void GuiUpdateUser(User *user) {
  if (!user) {
    warning("GuiUpdateUser: NULL user!");
    return;
  }
  notice("Avatar %s is in %s", NN(user->name.instance_name), NN(user->name.world_name));
  if (user->ptrgui)
    gui.guiWidgets->updateUser((GuiUser)user->ptrgui, user);
}

/* ==================================================== ======== ======= */

void * GuiAddWorld(struct _World *world, boolean isCurrentWorld)
{
  if (!world) {
    warning("GuiAddWorld: NULL world!");
    return NULL;
  }
  // notice("New world %s", NN(world->name));
  return gui.guiWidgets->addWorld(world, isCurrentWorld);
}

void GuiRemoveWorld(struct _World *world)
{
  if (!world) {
    warning("GuiRemoveWorld: NULL world!");
    return;
  }
  // notice("Remove world %s", NN(world->name));
  if (world->ptrgui)
    gui.guiWidgets->removeWorld(world);
}

void GuiUpdateWorld(struct _World *world, boolean isCurrentWorld)
{
  if (!world) {
    warning("GuiUpdateWorld: NULL world!");
    return;
  }
  // notice("Update world %s", NN(world->name));
  if (world->ptrgui)
    gui.guiWidgets->updateWorld(world, isCurrentWorld);
}



// CALLBACK FUNCTIONS

void GUI::callVrengAction(int spaction) {
  struct timeval t;
  gettimeofday(&t, NULL);  /* get time */
  trace(DBG_GUI, "SpecialAction: action=%d", spaction);
  specialAction(/*solid*/NULL, spaction, NULL, t.tv_sec, t.tv_usec);
}

void GUI::changeVrengKey(int key, boolean ispressed) {
  struct timeval t;
  gettimeofday(&t, NULL);  /* get time */
  //printf("GuiProcessKey: PRESS: ts: %d - tus: %d \n", t.tv_sec, t.tv_usec);
  if (key >= MAXKEYS || key < 0)
    return;
  changeKey(key, ispressed, t.tv_sec, t.tv_usec);
}

static void objectActionCB(int meth) {  //with current solid!
  if (gui.current_solid) {
    struct timeval tv;
    gettimeofday(&tv, NULL);
    trace(DBG_GUI, "Call method: %d of object %p", meth, gui.current_solid);
    specialAction(gui.current_solid, meth, NULL, tv.tv_sec, tv.tv_usec);
  }
}


// returns info about the pointed object but do NOT select it
//
struct _ZVSolid* GUI::getPointedObject(int x, int y, ObjInfo *objinfo)
{ 
  Solid *solid = RenderGetSelection(x, y);

  if (!solid)
    return NULL;

  /* an object was selected */
  char *classname = NULL, *instancename = NULL, *actionnames = NULL;

  trace(DBG_GUI, "Pointed: solid=%p id=%d obj=%p", solid, solid->id, solid->object);
#if 0
  {
    int i, j;
    float *m;

    for (i=0; i<4; i++) {
      for (j=0; j<4; j++)
        printf("[%d,%d]=%.2f ", i, j, solid->posmat.m[i][j]);
      printf("\n");
    }
#if 0
    printf("\n");
    m = getGLMatrix(&(solid->posmat));
    for (i=0; i<4; i++) {
      for (j=0; j<4; j++, m++)
	printf("m[%d][%d]=%.2f ", i, j, *m);
      printf("\n");
    }
    printf("\n");
#endif
  }
#endif

  /* get the object hname or avatar name */
  getObjectHumanName(solid, &classname, &instancename, &actionnames);

  if (classname == NULL)
    return NULL;
  objinfo[0].name = classname;
  if (instancename == NULL)
    instancename = "";
  trace(DBG_GUI, "Pointed: %s:%s", classname, instancename);
  objinfo[1].name = instancename;   // TO BE COMPLETED

  int count = 0;
  if (actionnames) {
    for (count = 0; count < BUTTONSNUMBER && *actionnames; count++) {
      objinfo[count+2].name = actionnames;
      objinfo[count+2].fun  = objectActionCB;
      objinfo[count+2].farg = count;
      actionnames += HNAME_LEN;	// AWFULL !!!
    }
  }
  objinfo[count+2].name = NULL; // NULL terminated
  return solid;
}


// returns info about the pointed object AND selects it
//
struct _ZVSolid* GUI::selectPointedObject(int x, int y, ObjInfo *objinfo)
{
  return (gui.current_solid = getPointedObject(x, y, objinfo));
}


// inform the GUI that a (possibly selected) object was destroyed
//
void /*extern*/selectedObjectDeletion(struct _ZVSolid *solid)
{
  if (solid == gui.current_solid) {
    gui.current_solid = NULL;
    // delete the objectBar and makes it disappear
    gui.guiWidgets->updateObjectInfo(NULL,0);
  }
}


void GUI::setPref(int tool) {		// callback d'un des boutons pref
  trace(DBG_GUI, "Selected tool: %d", tool);
  if (tool & AUDIO_MASK) audiotool = tool;
  if (tool & VIDEO_MASK) videotool = tool;
  if (tool & WHITEBOARD_MASK) whiteboardtool = tool;
  if (tool & HTML_MASK) browsertool = tool;
  if (tool & VRML_MASK) vrmltool = tool;
}

void GUI::setAudio(int on) {	 // callback du bouton audio
  if (on) {
    audioactive = TRUE;
    startaudio(getCurrentChannelName());
  }
  else {
    quitaudio();
    audioactive = FALSE;
  }
}

void GUI::setVideo(int on) { 	// callback du bouton video
  if (on) startvideo(getCurrentChannelName());
  else quitvideo();
}

void GUI::setWhiteboard(int on) {	// callback du bouton whiteboard
  if (on) startwhiteboard(getCurrentChannelName());
  else quitwhiteboard();
}

void GUI::setSlidecast(int on) {	// callback du bouton slidecast
  if (on) startslidecast(getCurrentChannelName());
  else quitslidecast();
}

void GUI::setModeler(int on) {	// callback du bouton modeler
  if (on) startmodeler();
  else quitmodeler();
}

void GUI::setJmrc(int on) {	// callback du bouton jmrc
}

void GUI::quit(int status) {
  QuitVreng(status);
  exit(status);
}

void GUI::back(int) {		// callback du bouton Back
  backWorld();
}

void GUI::forward(int) {	// callback du bouton Forward
  forwardWorld();
}

void GUI::addbookmark(int) {	// callback du bouton AddBookmarks
  FILE *fp;
  char bookmark[URL_LEN + CHAN_LEN + 2];
  char buf[URL_LEN + CHAN_LEN + 2];

  sprintf(bookmark, "%s %s\n", worlds->url, worlds->chan);
  if ((fp = fopen(vrengbookmarks, "r")) != NULL) {
    while (fgets(buf, sizeof(buf), fp)) {
      if (!strcmp(buf, bookmark)) {
        fclose(fp);
        return ;
      }
    }
    fclose(fp);
  }
  if ((fp = fopen(vrengbookmarks, "a")) != NULL) {
    fputs(bookmark, fp);
    fclose(fp);
  }
}

void GUI::home(int) {	// callback du bouton Home
  char chan_home_str[CHAN_LEN];
  sprintf(chan_home_str, "%s/%u/%d", universe.groupinitial, universe.portinitial, getCurrentTtl());
  trace(DBG_IPMC, "Wmgt: goto %s at %s", universe.urlinitial, chan_home_str);
  quitWorld();
  quitChannel(getCurrentChannel());
  newWorld(universe.urlinitial, chan_home_str, TRUE);
  setCurrentChannelName(chan_home_str);	/* join new channel */
  if (audioactive) startaudio(chan_home_str);
}

void GUI::help(int) {		// callback du bouton Help
  system("IFS=' '; netscape -remote 'openURL(http://www.infres.enst.fr/net/vreng/html/)' &");
}

#if NOT_YET
void GUI::pref(int) {		// callback du bouton Pref
  printf("!Not yet available\n");
}

void GUI::edit(int) {		// callback du bouton Edit
  printf("!Not yet available\n");
}

void GUI::stats(int) {		// callback du bouton Stats
  printf("!Not yet available!\n");
}

void GUI::views(int) {		// callback du bouton Views
  printf("!Not yet available!\n");
}
#endif


#endif /* !VRENGD */
