/*
 * Generate a random 32-bit quantity
 *
 * RFC 1889
 */
#include "sysdep.h"
#include "md5.h"		/* from RFC 1321 */


#define MD_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final


unsigned int random32(int);

static u_long md_32(char *string, int length)
{
	MD_CTX context;
	union {
		char	c[16];
		u_long	x[4];
	} digest;
	u_long r;
	int i;

	MDInit(&context);
	MDUpdate(&context, (u_int8 *) string, length);
	MDFinal((unsigned char *)&digest, &context);
	r = 0;
	for (i = 0; i < 3; i++) {
		r ^= digest.x[i];
	}
	return r;
}

/*
 * Return random unsigned 32-bit quantity. Use 'type' argument if you
 * need to generate several different values in close succession.
 */
unsigned int random32(int type)
{
#if HAVE_GETHOSTID
	//DAX extern long gethostid(void);
#endif
	struct {
		int	type;
		struct	timeval tv;
		clock_t	cpu;
#ifdef WIN32
		int  	pid;
#else
		pid_t	pid;
#endif
		u_long	hid;
#ifndef WIN32
		uid_t	uid;
		gid_t	gid;
#endif
#if HAVE_UNAME
		struct	utsname name;
#endif
	} s;

	gettimeofday(&s.tv, 0);
#if HAVE_UNAME
	uname(&s.name);
#endif
	s.type	= type;
	s.cpu	= clock();
#ifdef WIN32
	s.pid	= _getpid();
	s.hid = 0;
#else
	s.pid	= getpid();

 #if HAVE_SYSINFO
  #if 0
      {
      char buf[32];

      /* this use of sysinfo is not portable, and HAVE_SYSINFO
       * makes a weak promise on what's in there 
       */
      sysinfo(SI_HW_SERIAL, buf, sizeof(buf));
      s.hid = atoi(buf);
      }
  #else
	s.hid=0;
  #endif /* 0 */
 #else
#if HAVE_GETHOSTID
	s.hid	= gethostid();
#else
	s.hid	= 1;
#endif
 #endif /* HAVE_SYSINFO */
	s.uid	= getuid();
	s.gid	= getgid();
#endif /* WIN32 */

	return md_32((char *)&s, sizeof(s));
}
