#ifndef CONFIGURATION_MANAGER_H
#define CONFIGURATION_MANAGER_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "Configurable.h"

class SimulationManager;

/** The ConfigurationManager abstract base class.

    The ConfigurationManager abstract base class represents the base
    class from which all configuration managers should be derived
    from.
*/
class ConfigurationManager : virtual public Configurable {
public:
   
  /**@name Public Class Methods of ConfigurationManager */
  //@{
  
  /// Default destructor
  virtual ~ConfigurationManager(){};
  
  //@} // End of Public Class Methods of ConfigurationManager
  
  virtual SimulationManager *getSimulationManager() = 0;

protected:

   /**@name Protected Class Methods of ConfigurationManager */
   //@{

   /// Default constructor
   ConfigurationManager(){};
   
   //@} // End of Protected Class Methods of ConfigurationManager
   
};
#endif
