// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
//
// $Id: TimeWarpConfigurationManager.cpp
//
//---------------------------------------------------------------------------

#include "TimeWarpConfigurationManager.h"
#include "TimeWarpCentralizedEventSetFactory.h"
#include "TimeWarpDecentralizedEventSetFactory.h"
#include "TimeWarpSimulationManagerFactory.h"
#include "SchedulingData.h"
#include "Application.h"
#include "SimulationConfiguration.h"
#include "Spinner.h"
#include <clutils/ConfigurationChoice.h>
#include <clutils/ConfigurationScope.h>

using std::cout;
using std::endl;

TimeWarpConfigurationManager::TimeWarpConfigurationManager( const vector<string> &arguments,
							    Application *initApplication ) :
  mySimulationManager( 0 ),
  myCommandLineArguments( arguments ),
  myEventSetFactory( 0 ),
  myStateFactory( 0 ), 
  myGVTFactory( 0 ), 
  myCommunicationFactory( 0 ),
  mySchedulingFactory( 0 ),
  myOutputFactory( 0 ),
  myApplication( initApplication ){}

TimeWarpConfigurationManager::~TimeWarpConfigurationManager(){
  delete myEventSetFactory;
  delete myStateFactory;
  delete myGVTFactory;
  delete myCommunicationFactory;
  delete mySchedulingFactory;
  delete myOutputFactory;

  // the handles to the eventSetManager, stateManager, GVTManager,
  // CommunicationManager, schedulingManager and the outputManager
  // are deleted by the end user - the TimeWarpSimulationManager.
}

void
TimeWarpConfigurationManager::configure( SimulationConfiguration &configuration ){
  cout << "Initializing simulation...";

  const TimeWarpSimulationManagerFactory *twSimMgrFactory = 
    TimeWarpSimulationManagerFactory::instance();

  mySimulationManager = 
    dynamic_cast<TimeWarpSimulationManager *>(twSimMgrFactory->allocate( configuration,
									 myApplication ) );
  mySimulationManager->configure( configuration );
  
  
//   const ConfigurationChoice *controlManagerChoice = configuration.findChoice("CONTROLMANAGER");
//   if( controlManagerChoice != 0 &&
//       controlManagerChoice->getStringValue() == "ACTIVE" ){
//     abort();
//   }

  Spinner::spinIfRequested( "SpinBeforeSimulationStart",  configuration );
}

SimulationManager *
TimeWarpConfigurationManager::getSimulationManager(){
  return mySimulationManager;
}
