// Returns true if Java is enabled
function webdeveloper_isJavaEnabled()
{
	return Components.classes["@mozilla.org/oji/jvm-mgr;1"].getService(Components.interfaces.nsIJVMManager).JavaEnabled;
}

// Loads the given application with the given URL
function webdeveloper_loadApplicationWithURL(application, url)
{
    // If the application and URL are set
    if(application && url)
    {
        application = new WebDeveloperApplication(application);

        application.launchWithURL(url);
    }
}

// Opens the DOM Inspector
function webdeveloper_openDOMInspector()
{
    // If the DOM Inspector and chrome is available
    if(webdeveloper_isDOMInspectorAvailable() && webdeveloper_isDOMInspectorChromeAvailable())
    {
        // If the open DOM Inspector in dashboard preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.dom.inspector.dashboard", true))
        {
            var domInspector = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_domInspector");

            // If the DOM inspector is already open in the dashboard
            if(webdeveloper_isOpenInDashboard(domInspector))
            {
                webdeveloper_closeInDashboard(domInspector);
            }
            else
            {
                webdeveloper_openInDashboard(domInspector, "chrome://inspector/content/sidebar.xul");
                window.setTimeout(BrowserReload, 1000);
            }
        }
        else
        {
            inspectDOMDocument(webdeveloper_getContentDocument());
        }
    }
    else
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_domInspectorRequired"), "@home.page@documentation/faq/#dom-inspector");
    }
}

// Opens the Java Console
function webdeveloper_openJavaConsole()
{
	// If Java is enabled
	if(webdeveloper_isJavaEnabled()) 
	{
		Components.classes["@mozilla.org/oji/jvm-mgr;1"].getService(Components.interfaces.nsIJVMManager).showJavaConsole();
	}
}

// Updates the tools menu
function webdeveloper_updateToolsMenu(menu, suffix)
{
    var bookmarklet           = null;
    var bookmarkletPreference = null;
    var description           = null;
    var descriptionPreference = null;
    var key                   = null;
    var menuItem              = null;
    var path                  = null;
    var separator             = null;
    var stringBundle          = document.getElementById("webdeveloper-string-bundle");
    var toolPreference        = null;
    var toolsCount            = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
    var toolsSeparator        = menu.getElementsByAttribute("id", "webdeveloper-tools-separator1-" + suffix)[0];
    var url                   = null;

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible tools
	for(var i = 1; i <= toolsCount; i++)
	{
        bookmarklet = "webdeveloper.tool." + i + ".bookmarklet";
        description = "webdeveloper.tool." + i + ".description";
        key         = "webdeveloper.tool." + i + ".key";
        path        = "webdeveloper.tool." + i + ".path";
        separator   = "webdeveloper.tool." + i + ".separator";
        url         = "webdeveloper.tool." + i + ".url";

        // If the separator preference is set
        if(webdeveloper_getBooleanPreference(separator, true))
        {
            menuItem = document.createElement("menuseparator");
            menuItem.setAttribute("class", "webdeveloper-generated-menu");
            menu.insertBefore(menuItem, toolsSeparator);
        }
        else if(webdeveloper_isPreferenceSet(description) && (webdeveloper_isPreferenceSet(bookmarklet) || webdeveloper_isPreferenceSet(path) || webdeveloper_isPreferenceSet(url)))
        {
    	    descriptionPreference = webdeveloper_getStringPreference(description, true);

            // If the description is not blank
            if(descriptionPreference != "")
            {
                menuItem = document.createElement("menuitem");

                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);

                // If the bookmarklet preference is set
                if(webdeveloper_getStringPreference(bookmarklet, true))
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_runBookmarklet('" + encodeURIComponent(webdeveloper_getStringPreference(bookmarklet, true)).replace(new RegExp("'", "gi"), "\\'") + "')");
                }
                else if(webdeveloper_getStringPreference(path, true))
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_loadApplicationWithURL('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "', getBrowser().currentURI.spec)");
                }
                else
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_loadURL('" + webdeveloper_getStringPreference(url, true) + "' + encodeURIComponent(getBrowser().currentURI.spec))");
                }

                // If the key preference is set
                if(webdeveloper_isPreferenceSet(key))
                {
                    menuItem.setAttribute("key", key);
                }

                menu.insertBefore(menuItem, toolsSeparator);
            }
        }
	}

    menuItem = document.getElementById("webdeveloper-dom-inspector-" + suffix);

    // If the menu exists
    if(menuItem)
    {
        // If the DOM Inspector or chrome is not available
        if(!webdeveloper_isDOMInspectorAvailable() || !webdeveloper_isDOMInspectorChromeAvailable())
        {
            menuItem.setAttribute("class", "menuitem-iconic");
        }
        else if(menuItem.hasAttribute("class"))
        {
            menuItem.removeAttribute("class");
        }
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-dom-inspector-" + suffix), "checked", webdeveloper_isOpenInDashboard(stringBundle.getString("webdeveloper_domInspector")));
    webdeveloper_configureElement(document.getElementById("webdeveloper-display-page-validation-" + suffix), "checked", !document.getElementById("webdeveloper-page-validation-toolbar").hidden);
    webdeveloper_configureElement(document.getElementById("webdeveloper-error-console-" + suffix), "checked", webdeveloper_isOpenInDashboard(stringBundle.getString("webdeveloper_errorConsole")));
    webdeveloper_configureElement(document.getElementById("webdeveloper-java-console-" + suffix), "disabled", !webdeveloper_isJavaEnabled());
}

// Validates a local HTML file for accessibility
function webdeveloper_validateLocalAccessibility()
{
    new WebDeveloperValidateAccessibility().validateAccessibility(getBrowser().currentURI);
}

// Validates local CSS
function webdeveloper_validateLocalCSS()
{
    new WebDeveloperValidateCSS().validateCSS(getBrowser().currentURI, webdeveloper_getDocuments(webdeveloper_getContentWindow()));
}

// Validates a local HTML file
function webdeveloper_validateLocalHTML()
{
    new WebDeveloperValidateHTML().validateHTML(getBrowser().currentURI);
}