/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef BOOKMARKSETTINGS_H
#define BOOKMARKSETTINGS_H

#include <QObject>
#include <QList>
#include <QStringList>

class Bookmark;

/**
* Class for loading and modifying bookmarks.
*/
class BookmarkSettings : public QObject
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    BookmarkSettings();

    /**
    * Destructor.
    */
    ~BookmarkSettings();

public:
    /**
    * Return all existing bookmarks.
    */
    const QList<Bookmark>& bookmarks() const { return m_bookmarks; }

    /**
    * Replace the old bookmark with given bookmark.
    */
    void replaceBookmark( const Bookmark& oldBookmark, const Bookmark& newBookmark );

    /**
    * Add a bookmark to the top of the list.
    *
    * The list is limited to twenty most recent entries.
    */
    void addBookmark( const Bookmark& bookmark );

    /**
    * Delete the given bookmark.
    */
    void deleteBookmark( const Bookmark& bookmark );

private:
    int findBookmark( const Bookmark& bookmark ) const;

    void updateAllBookmarks( const QString& uuid, const QString& url );

    void openBookmarks();
    void saveBookmarks();

    QStringList serializeBookmark( const Bookmark& bookmark );
    Bookmark deserializeBookmark( const QStringList& list );

    QString obscure( const QString& text );

private:
    QList<Bookmark> m_bookmarks;
};

#endif
