#!/usr/local/bin/perl
# csw_find.cgi
# Show a list of all packages from CSW

require './software-lib.pl';
&ReadParse();

&header();
print <<EOF;
<script>
function sel(m)
{
window.opener.ifield.value = m;
window.close();
return false;
}
</script>
EOF

# Build the list of all packages
open(PKG, "$pkg_get -a |");
while(<PKG>) {
	s/\r|\n//g;
	s/#.*$//;
	next if (/^\s*WARNING:/);
	if (/^\s*(\S+)\s+(\S+)/) {
		push(@list, [ $1, $2 ]);
		}
	}
close(PKG);
@list = sort { lc($a->[0]) cmp lc($b->[0]) } @list;

# Show them all ..
print "<table width=100% cellpadding=1 cellspacing=1>\n";
print "<tr> <td><b>$text{'csw_package'}</b></td> ",
      "<td><b>$text{'csw_version'}</b></td> </tr>\n";
foreach $p (@list) {
	print "<tr>\n";
	print "<td><a href='' onClick='sel(\"$p->[0]\")'>",
	      "$p->[0]</td>\n";
	print "<td>$p->[1]</td>\n";
	print "</tr>\n";
	}
print "</table>\n";

&ui_print_footer();

