/*
 * AnimationDialog.h
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _ANIMATION_DIALOG_H
#define _ANIMATION_DIALOG_H

#ifndef _DIALOG_H
#include "Dialog.h"
#endif
#include "Scene.h"
#include "Array.h"
#include "swt.h"

class NodeTimeSensor;

#include "swttypedef.h"

class AnimationDialog : public Dialog {
public:
			AnimationDialog(SWND parent, Node* oldNode);
    virtual	       ~AnimationDialog();

    void		drawInterface(SDC dc);
    void                accountYmax();
    NodeTimeSensor     *getTimeSensor()        { return _timeSensor; }
    float               getTimeSensorSeconds() { return _newTimeSensorSeconds; }
    Array<int>         &getEventInFields()     { return _eventInFields; }    
    Array<int>         &getEventInTypes()      { return _eventInTypes; }    
    Array<bool>        &getEventInIsAnimated() { return _eventInIsAnimated; }


protected:
    void		LoadData();
    void		SaveData();
    virtual bool	Validate();
    void		buildInterfaceData(void);
    int                 numEventInNames() { return _eventInNames.size(); }
    
private:
    Node	       *_animationNode;
    NodeTimeSensor     *_timeSensor;
    float               _newTimeSensorSeconds;
    bool		_okFlag;
    Array<SWND>         _buttons;
    Array<MyString>     _eventInNames;
    Array<int>          _eventInFields;
    Array<int>          _eventInTypes;
    Array<bool>         _eventInIsAnimated;
    Array<bool>         _initIsAnimated;
};

#endif
