/*
 * EventIn.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _EVENT_IN_H
#define _EVENT_IN_H

#ifndef _ELEMENT_H
#include "Element.h"
#endif

#ifndef _DUNE_STRING_H
#include "MyString.h"
#endif

class ExposedField;
class Field;

class EventIn : public Element {
public:
		    EventIn(int type, MyString name,
			    int flags = 0, ExposedField *exposedField = NULL);
    virtual	   ~EventIn();
    virtual int	    getElementType() const { return EL_EVENT_IN; } 
    virtual int     write(int filedes, int indent) const;

    int		    getType() const { return _type; }
    const MyString &getName() const { return _name; }

    ExposedField   *getExposedField() const { return _exposedField; }
    int            getField() const { return _field; }
    void           setField(int field) { _field = field; }

    int		    getFlags() const { return _flags; }
    void	    setFlags(int flags) { _flags = flags; }

private:
    int		    _type;
    MyString	    _name;
    ExposedField   *_exposedField;
    int             _field;
    int		    _flags;
};

#endif // _EVENT_IN_H
