#!/bin/sh
#------------------------------------------------------------------------------
#   winesetup
#       This shell script is a simple cover script for the
#   Wine configuration process.  As an added bonus,
#   it will also let the user create KDE or Gnome menu items
#   if the user doesn't have 'em yet.
#  
#   Usage:
#       winesetup [kde | gnome]
#
#   Copyright (c) 2000 by Jeremy White for CodeWeavers
#       
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
#  Establish Color Scheme
#------------------------------------------------------------------------------
COLOR=' -xrm *.Command.background:darkgrey
-xrm *.Command.foreground:black
-xrm *.Text.background:black
-xrm *.Text.foreground:green 
-xrm *.Form.background:grey
-xrm *.Form.foreground:green
-xrm *.foreground:green
-xrm *.background:black'

XMESSAGE="xmessage $COLOR"


#------------------------------------------------------------------------------
#  We're going to do a lot of fancy footwork below.
#    Before we get started, it would be nice to know the argv0,
#    of the actual script we're running (and lets remove at least
#    one level of symlinking).
#------------------------------------------------------------------------------
real_name=`find $0 -type l -printf "%l\n"`
if [ ! $real_name ]; then
    real_name=$0;
fi
argv0_dir=`find $real_name -printf "%h\n"`

if [ -z $argv0_dir ] ; then
    argv0_dir=.
fi

#------------------------------------------------------------------------------
#   Establish whether we want to ask about desktop links or not
#------------------------------------------------------------------------------
ask_kde=0
ask_gnome=0
ask_menu=0

BUTTON='  Just Configure  :0'

if [ -d ~/.kde/share/applnk ] ; then
    if [ ! -d ~/.kde/share/applnk/Wine ] ; then
        ask_kde=1
        ask_menu=1
        # :1 return value is reserved for error status, so we can't us it
        BUTTON="$BUTTON"',  Install KDE :2'
    fi
fi
   
if [ -d ~/.gnome/apps ] ; then
    if [ ! -d ~/.gnome/apps/Wine ] ; then
        # Mandrake kludge.  Mandrake Gnome integration is badly broken.
        #    If we do what is 'normal', we will kill all entries in 
        #    their Mandrake menu.
        uname -a | grep -q mdk
        if [ $? -eq 0 ] ; then
            MESSAGE="
Gnome integration does not work under Mandrake.
If you have removed the Mandrake menu system and are
confident it will work, edit $0 and remove this test.
"
            echo $MESSAGE
            # Try not to be too annoying...
            if [ ! -d ~/.kde/share/applnk/Wine ] ; then
                $XMESSAGE -title "Warning" "$MESSAGE"
            fi
        else
                ask_gnome=1
                ask_menu=1
                BUTTON="$BUTTON"',  Install Gnome :3'
                if [ $ask_kde -eq 1 ] ; then
                    BUTTON="$BUTTON"',  Install Both  :4'
                fi
        fi
    fi
fi


   

#------------------------------------------------------------------------------
#   Should we have a menu?
#------------------------------------------------------------------------------
never_ask_flag=~/.wine_never_ask_about_menus
if [ -f $never_ask_flag ] ; then
    ask_menu=0
fi

if [ $ask_menu -gt 0 ] ; then
    BUTTON="$BUTTON"',  Never Ask Again  :5'
    $XMESSAGE -print -title "Welcome to Wine" -button "$BUTTON" "

                Welcome to Wine

    WineSetup has determined that you have not configured
    either your KDE or Gnome menu entries.  You can
    elect to do so now, or simply proceed on to edit
    your Wine configuration file.

    "
    ask_rc=$?

    if [ $ask_rc -eq 2 -o $ask_rc -eq 4 ] ; then
        mkdir ~/.kde/share/applnk/Wine
        cp /opt/wine/personal/kde/* ~/.kde/share/applnk/Wine/
        cp /opt/wine/personal/kde/.directory ~/.kde/share/applnk/Wine/

        # KDE 1.x kludge.  Wake up KDE, if we can find kpanel running
        type kwmcom >/dev/null 2>/dev/null && \
          ps u -C kpanel >/dev/null 2>/dev/null && \
            kwmcom kpanel:restart

    fi

    if [ $ask_rc -eq 3 -o $ask_rc -eq 4 ] ; then
        mkdir ~/.gnome/apps/Wine
        cp /opt/wine/personal/gnome/* ~/.gnome/apps/Wine/
        cp /opt/wine/personal/gnome/.directory ~/.gnome/apps/Wine/
        cp /opt/wine/personal/gnome/.order ~/.gnome/apps/Wine/
    fi

    if [ $ask_rc -eq 5 ] ; then
        $XMESSAGE -title "Quiet WineSetup" \
        "Wine will now disable the test for KDE and Gnome entries you just saw.

        You can reenable this Window by removing the $never_ask_flag file." -buttons "  Okay  ":0," Cancel ":1
        if [ $? -eq 0 ] ; then
            touch $never_ask_flag
        fi
    fi
fi


#------------------------------------------------------------------------------
#   Time to run the configurator
#------------------------------------------------------------------------------
$argv0_dir/winesetuptk
