/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "ui_netparamsedit.h"
#include "netparams.h"

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>

#include <kiconloader.h>

ui_NetParamsEdit::ui_NetParamsEdit(QWidget* parent, const char* name, bool modal, WFlags fl)
                : netProperties(parent,name, modal,fl)
{
        buttonHelp->hide();
        buttonOk->setIconSet( SmallIconSet("ok") );
        buttonCancel->setIconSet( SmallIconSet("cancel") );
}

ui_NetParamsEdit::~ui_NetParamsEdit()
{}

/*$SPECIALIZATION$*/

/*void ui_NetParamsEdit::setWepEnabled( bool w )
{
	tabSecurity->setShown(w);
}*/

/*void ui_NetParamsEdit::setEssidEnabled( bool e )
{
	boxEssid->setShown(e);
}*/

void ui_NetParamsEdit::setValues( const WANetParams & np )
{
        boxEssid->setShown(np.hiddenEssid);
        essid->setText(np.essid);

        tabNetParams->setTabEnabled( tabSecurity, np.wep);
        if (np.wepMode=="open")
                radioWepOpen->setChecked(1);
        else
                radioWepRestricted->setChecked(1);
        if ( np.wepKey.left(2)=="s:" ) { //ASCII key
                checkWepAscii->setChecked(true);
                wepKey->setText( np.wepKey.right(np.wepKey.length()-2) );
        } else { //HEX key
                checkWepAscii->setChecked(false);
                wepKey->setText( np.wepKey );
        }
        radioDhcp->setChecked( np.dhcp );
        radioManualConfig->setChecked( !np.dhcp );

        ip->setText(np.ip);
        broadcast->setText( np.broadcast );
        netmask->setText( np.netmask );
        gateway->setText( np.gateway );
        domain->setText( np.domain );
        dns1->setText( np.dns1 );
        dns2->setText( np.dns2 );
}

WANetParams ui_NetParamsEdit::readNetParams( WANetParams & np )
{
        if (np.hiddenEssid) {
                np.wasHiddenEssid = true;
                np.essid = essid->text();
        }
        np.dhcp = radioDhcp->isChecked();
        np.ip = ip->text();
        np.broadcast = broadcast->text();
        np.netmask = netmask->text();
        np.gateway = gateway->text();
        np.domain = domain->text();
        np.dns1 = dns1->text();
        np.dns2 = dns2->text();
        if (np.wep) { // WEP authentication needed
                np.wasWep = true;
                if (radioWepOpen->isChecked())
                        np.wepMode = "open";
                else
                        np.wepMode = "restricted";
                np.wepKey = wepKey->text();
                if (checkWepAscii->isChecked())
                        np.wepKey.prepend("s:");
        }
        return np;
}

#include "ui_netparamsedit.moc"

