/*  
 *  Copyright (C) 2000 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/01/23 13:45:27 $
 *  $Author: hafner $
 *  $Revision: 1.8 $
 *  $State: Exp $
 */

#ifndef _THEME_BROWSER_H
#define _THEME_BROWSER_H

#include <gtk/gtk.h>
#include "misc.h"

typedef void (* update_fct) (proplist_t *, gpointer,
			     proplist_t *, const char *);

GtkWidget *
theme_browser (GtkWidget *box, bool_t section);
void
build_theme_list (void);
void
generate_previews (GtkWidget *button, gpointer ptr);
bool_t
load_attributes (const char *filename, const char *path);
void
connect_update_function (proplist_t *key, gpointer ptr, update_fct update);

#ifdef GETSTYLE
void
get_theme_attributes (void);
void
cleanup_themes (void);
#endif /* GETSTYLE */

#endif /* not _THEME_BROWSER_H */
