/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _DICCIONARIO_BASE_H_
#define _DICCIONARIO_BASE_H_

#include <qstring.h>
#include <qstringlist.h>
#include <qglobal.h>

class QConfig;

class DiccionarioBase {

public:
	enum Tipo { Text_dict, Babylon_dict, Dict_dict };

	DiccionarioBase();
	virtual ~DiccionarioBase();

	void setAlias(const QString& nombre) { alias=nombre; };
	QString getAlias() { return alias; };

	void setIdioma1(const QString& idioma) { idioma1=idioma; };
	QString getIdioma1() { return idioma1; };

	void setIdioma2(const QString& idioma) { idioma2=idioma; };
	QString getIdioma2() { return idioma2; };

	virtual QString getFullName();

	void setDiccionario(const QString& fichero) { diccionario=fichero; };
	QString getDiccionario() { return diccionario; };

	void setPersonal(const QString& fichero);
	QString getPersonal() { return personal; };

	void setSeparador(const QString& sep) { separador=sep; };
	QString getSeparador() { return separador; };

	void setFileName(const QString& fichero);
	//QCadena getFileName();

	void setPalabrasCompletas(bool b=true) { palabras_completas=b; };
	bool getPalabrasCompletas() { return palabras_completas; }
	virtual bool canSelectPalabrasCompletas() { return true; };

	void setCaseSensitive(bool b=true) { case_sensitive=b; };
	bool getCaseSensitive() { return case_sensitive; }
	virtual bool canSelectCaseSensitive() { return true; };

	void setInvertirResultados(bool b=true) { busqueda_inversa=b; };
	bool getInvertirResultados() { return busqueda_inversa; }
	virtual bool canSelectInvertirResultados() { return true; };

	void setIgnorarAcentos(bool b=true) { ignora_acentos=b; };
	bool getIgnorarAcentos() { return ignora_acentos; };
	virtual bool canSelectIgnorarAcentos() { return false; };

	void setIconoIdioma1(const QString& fichero) { icono_idioma1=fichero; };
	QString getIconoIdioma1() { return icono_idioma1; };

	void setIconoIdioma2(const QString& fichero) { icono_idioma2=fichero; };
	QString getIconoIdioma2() { return icono_idioma2; };

	//virtual bool busca(const QString& palabra, QStringList & resultado, 
    //                   bool con_formato=false);

	virtual bool busca(const QString& palabra, QString & resultado, 
                       bool con_formato=false);

	virtual bool aprende(const QString& texto_idioma1, const QString& texto_idioma2);
	virtual bool puedeAprender() { return true; };

	virtual QString getBestMatch() { return bestMatch; };
	virtual int getMatches() { return n_matches; };

	bool estaBuscando() { return trabajando; };

	virtual void save();
	virtual void load(const QString& fichero);

	void setDesc(QStringList descripcion) { desc=descripcion; };
	QStringList getDesc() { return desc; };

	virtual QString getGeneralInfo(bool con_formato);
	virtual bool canGetGeneralInfo() { return false; };

	virtual QString getDictionaryInfo(bool con_formato=false);
	virtual bool canGetDictionaryInfo() { return false; };

	void save_desc();
	void load_desc();

	void save_font();
	void load_font();

	virtual bool update();

	//virtual bool isBabyDict() { return false; };
	//virtual bool isDictdDict() { return false; };
	//virtual bool isTextDict() { return false; };

	Tipo getTipo() { return tipo_dict; };

	void setError(QString texto) { error=texto; };
	QString getError() { return error; };

	void setUTF8( bool b ) { utf8=b; };
	bool getUTF8() { return utf8; };

	//La salida se suma al objeto resultado.
	static bool exec_command(QCString orden, QString & resultado);

	static bool html_simple_header;
	static bool no_internal_links;
	static bool html_use_br;
	static QString base_page;
	static QString additional_options;
	static bool no_gui;

#if QT_VERSION >= 300
	static QString font_string;
#endif

	//Datos font secundario
	QString f_family;
	int f_pointSize;
	int f_weight;
	bool f_italic;
	bool f_bold;
	bool f_underline;
	bool f_strikeout;
	int f_charset;

protected:
	void setTipo( Tipo tipo ) { tipo_dict=tipo; };

	QString alias;
	QString idioma1;
	QString idioma2;
	QString diccionario;
	QString personal;
	QString personal_dict;

	QString separador;

	QString icono_idioma1;
	QString icono_idioma2;

	QStringList desc;
	QString bestMatch;
	int n_matches;
	bool utf8;
	//QStrList lista_resultado;

	bool busqueda_inversa;
	bool case_sensitive;
	bool palabras_completas;
	bool ignora_acentos;

	QConfig *conf;

	bool trabajando;
	QString error;

	Tipo tipo_dict;
};


#endif

