
#include "wizard.h"
#include "wizard_page1.h"
#include "wizard_page2.h"

#include "intern.h"
#include <qlabel.h>
#include <qpixmap.h>

//#include "pixmaps/wizard_logo.xpm"


Wizard::Wizard(QWidget * parent=0, const char * name=0, 
               bool modal=FALSE, WFlags f=0 ) 
	: QWizard( parent, name, modal, f )
{
	page1 = new WizardPage1(this, "page1");
	//page1->imagen->setPixmap( QPixmap(wizard_logo_xpm) );
	connect(page1, SIGNAL(valid_file(bool)), this, SLOT(slot_valid_file(bool)));

	page2 = new WizardPage2(this, "page2");

	//page2->resultado_final->setText( "<b>El resultado final va aqu</b>" );

	addPage( page1, _("Step 1") );
	addPage( page2, _("Step 2") );

	setNextEnabled(page1, false);
}

Wizard::~Wizard() {
}

void Wizard::slot_valid_file(bool b) {
	setNextEnabled(page1, b);
	if (b) page2->setFile( page1->getFile() );
}

#include "wizard.moc.cpp"

#include "wizard_page1.cpp"
#include "wizard_page2.cpp"

