/* dirbookmarkeditui.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "dirbookmarkeditui.hh"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/button.h>
#include <aguix/stringgadget.h>
#include <aguix/choosebutton.h>
#include "worker_locale.h"
#include "bookmarkdbentry.hh"

DirBookmarkEditUI::DirBookmarkEditUI( AGUIX &aguix, BookmarkDB &data,
                                      BookmarkDBEntry &entry ) : m_aguix( aguix ),
                                                                 m_data( data ),
                                                                 m_entry( entry )
{
    m_okb = NULL;
    m_name_sg = NULL;
    m_alias_sg = NULL;
    m_useparent_cb = NULL;

    m_win = std::auto_ptr<AWindow>( new AWindow( &m_aguix,
                                                 0, 0,
                                                 400, 400,
                                                 0, catalog.getLocale( 805 ) ) );
    m_win->create();

    AContainer *co1 = m_win->setContainer( new AContainer( m_win.get(), 1, 4 ), true );
    co1->setMaxSpace( 5 );

    AContainer *co1_1 = co1->add( new AContainer( m_win.get(), 2, 1 ), 0, 0 );
    co1_1->setMinSpace( 5 );
    co1_1->setMaxSpace( 5 );
    co1_1->setBorderWidth( 0 );
    co1_1->add( new Text( &m_aguix, 0, 0, catalog.getLocale( 806 ), 1 ),
                0, 0, AContainer::CFIX );
    m_name_sg = (StringGadget*)co1_1->add( new StringGadget(  &m_aguix,
                                                              0, 0, 100,
                                                              m_entry.getName().c_str(), 0 ),
                                           1, 0, AContainer::CINCW );

    AContainer *co1_2 = co1->add( new AContainer( m_win.get(), 2, 1 ), 0, 1 );
    co1_2->setMinSpace( 5 );
    co1_2->setMaxSpace( 5 );
    co1_2->setBorderWidth( 0 );
    co1_2->add( new Text( &m_aguix, 0, 0, catalog.getLocale( 807 ), 1 ),
                0, 0, AContainer::CFIX );
    m_alias_sg = (StringGadget*)co1_2->add( new StringGadget(  &m_aguix,
                                                               0, 0, 100,
                                                               m_entry.getAlias().c_str(), 0 ),
                                            1, 0, AContainer::CINCW );

    AContainer *co1_3 = co1->add( new AContainer( m_win.get(), 1, 1 ), 0, 2 );
    co1_3->setMinSpace( 5 );
    co1_3->setMaxSpace( 5 );
    co1_3->setBorderWidth( 0 );
    m_useparent_cb = (ChooseButton*)co1_3->add( new ChooseButton( &m_aguix,
                                                                  0, 0,
                                                                  m_entry.getUseParent(),
                                                                  catalog.getLocale( 808 ),
                                                                  LABEL_LEFT,
                                                                  1, 0 ),
                                                0, 0, AContainer::CINCWNR );

    AContainer *co1_4 = co1->add( new AContainer( m_win.get(), 2, 1 ), 0, 3 );
    co1_4->setBorderWidth( 0 );
    co1_4->setMinSpace( 5 );
    co1_4->setMaxSpace( -1 );
    m_okb = (Button*)co1_4->add( new Button( &m_aguix,
                                             0,
                                             0,
                                             catalog.getLocale( 11 ),
                                             1,
                                             0,
                                             0 ), 0, 0, AContainer::CFIX );

    m_cancelb = (Button*)co1_4->add( new Button( &m_aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 8 ),
                                                 1,
                                                 0,
                                                 0 ), 1, 0, AContainer::CFIX );

    m_win->contMaximize( true );
    m_win->setDoTabCycling( true );
}

DirBookmarkEditUI::~DirBookmarkEditUI()
{
}

int DirBookmarkEditUI::mainLoop()
{
    m_win->show();
    
    AGMessage *msg;
    int endmode = 0;
    for ( ; endmode == 0; ) {
        msg = m_aguix.WaitMessage( NULL );
        if ( msg != NULL ) {
            switch ( msg->type ) {
              case AG_CLOSEWINDOW:
                  endmode = -1;
                  break;
              case AG_BUTTONCLICKED:
                  if ( msg->button.button == m_okb ) {
                      endmode = 1;
                  } else if ( msg->button.button == m_cancelb ) {
                      endmode = -1;
                  }
                  break;
              case AG_KEYPRESSED:
                  if ( msg->key.key == XK_Escape ) {
                      endmode = -1;
                  }
                  break;
            }
            m_aguix.ReplyMessage( msg );
        }
    }

    if ( endmode == 1 ) {
        BookmarkDBEntry newentry( m_entry );
        newentry.setName( m_name_sg->getText() );
        newentry.setAlias( m_alias_sg->getText() );
        newentry.setUseParent( m_useparent_cb->getState() );
        m_data.updateEntry( m_entry, newentry );
    }

    m_win->hide();
    
    return endmode;
}
