/* createsymlinkop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: createsymlinkop.h,v 1.6 2001/11/03 17:08:01 ralf Exp $ */

#ifndef CREATESYMLINKOP_H
#define CREATESYMLINKOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>

class CreateSymlinkOp:public FunctionProto
{
public:
  CreateSymlinkOp(class Worker*);
  virtual ~CreateSymlinkOp();
  virtual CreateSymlinkOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual int load(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int doconfigure(int mode);
  
  void setSameDir(bool);
  void setLocal(bool);
  void setRequestFlags(bool);
protected:
  static const char *name;
  // Infos to save

  bool same_dir,local,requestflags;
  
  // temp variables
  Lister *startlister,*endlister;
  
  bool tsame_dir,tlocal,trequestflags;
  
  int normalmodecreatesl();
};

#endif
