/* reloadop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: reloadop.cc,v 1.18 2004/12/12 21:46:17 ralf Exp $ */

#include "reloadop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ReloadOp::name="ReloadOp";

ReloadOp::ReloadOp() : FunctionProto()
{
  reloadside=RELOADOP_THISSIDE;
  reset_dirsizes=false;
  keep_filetypes = false;
  hasConfigure = true;
}

ReloadOp::~ReloadOp()
{
}

ReloadOp*
ReloadOp::duplicate() const
{
  ReloadOp *ta=new ReloadOp();
  ta->reloadside=reloadside;
  ta->reset_dirsizes=reset_dirsizes;
  ta->keep_filetypes = keep_filetypes;
  return ta;
}

bool
ReloadOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ReloadOp::getName()
{
  return name;
}

int
ReloadOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodereload();
    }
  } else normalmodereload();
  return 0;
}

bool
ReloadOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  switch(reloadside) {
    case RELOADOP_OTHERSIDE:
      WConfig::configPutPair( fh, "mode", "other" );
      break;
    case RELOADOP_LEFTSIDE:
      WConfig::configPutPair( fh, "mode", "left" );
      break;
    case RELOADOP_RIGHTSIDE:
      WConfig::configPutPair( fh, "mode", "right" );
      break;
    default:
      WConfig::configPutPair( fh, "mode", "current" );
      break;
  }
  WConfig::configPutPairBool( fh, "resetdirsizes", reset_dirsizes );
  WConfig::configPutPairBool( fh, "keepfiletypes", keep_filetypes );
  return true;
}

const char *
ReloadOp::getDescription()
{
  return catalog.getLocaleCom(26);
}

void
ReloadOp::normalmodereload()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  Lister *ll,*lr,*tl;
  
  ll = am->getWorker()->getLister(0);
  lr = am->getWorker()->getLister(1);
  
  tl=NULL;
  switch(reloadside) {
    case RELOADOP_OTHERSIDE:
      if(am->mode==am->AM_MODE_DNDACTION) {
        tl = am->dndmsg->getDestLister();
      } else {
        if(startlister==ll) tl=lr;
        else tl=ll;
      }
      break;
    case RELOADOP_LEFTSIDE:
      tl=ll;
      break;
    case RELOADOP_RIGHTSIDE:
      tl=lr;
      break;
    default:
      if(am->mode==am->AM_MODE_DNDACTION) {
        tl = am->dndmsg->getSourceLister();
      } else tl=startlister;
      break;
  }
  if(tl!=NULL) {
    lm1=tl->getActiveMode();
    if(lm1!=NULL) {
      if(lm1->isType("NormalMode")==true) {
        nm1=(NormalMode*)lm1;
        nm1->update( reset_dirsizes, keep_filetypes );
      }
    }
  }
}

int
ReloadOp::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  ChooseButton *rdscb, *kftcb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(26))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(26));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(339),1));
  x+=ttext->getWidth()+5;
  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(324));
  rcyb->addOption(catalog.getLocale(325));
  rcyb->addOption(catalog.getLocale(326));
  rcyb->addOption(catalog.getLocale(327));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(reloadside) {
    case RELOADOP_OTHERSIDE:
      rcyb->setOption(1);
      break;
    case RELOADOP_LEFTSIDE:
      rcyb->setOption(2);
      break;
    case RELOADOP_RIGHTSIDE:
      rcyb->setOption(3);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  rdscb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(reset_dirsizes==true)?1:0,
                                                 catalog.getLocale(385),LABEL_RIGHT,1,0));
  y+=rdscb->getHeight()+5;
  tw=rdscb->getWidth()+10;
  if(tw>w) w=tw;

  kftcb = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                     x,
                                                     y,
                                                     ( keep_filetypes == true ) ? 1 : 0,
                                                     catalog.getLocale( 434 ),
                                                     LABEL_RIGHT,
                                                     1,
                                                     0 ) );
  y+=kftcb->getHeight()+5;
  tw=kftcb->getWidth()+10;
  if(tw>w) w=tw;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        reloadside=RELOADOP_OTHERSIDE;
        break;
      case 2:
        reloadside=RELOADOP_LEFTSIDE;
        break;
      case 3:
        reloadside=RELOADOP_RIGHTSIDE;
        break;
      default:
        reloadside=RELOADOP_THISSIDE;
        break;
    }
    reset_dirsizes=(rdscb->getState()==1)?true:false;
    keep_filetypes = ( kftcb->getState() == 1 ) ? true : false;
  }
  
  win->close();
  delete win;

  return endmode;
}

void ReloadOp::setReloadside(reload_t nv)
{
  reloadside=nv;
}

void ReloadOp::setResetDirSizes(bool nv)
{
  reset_dirsizes=nv;
}

void ReloadOp::setKeepFiletypes( bool nv )
{
  keep_filetypes = nv;
}

