// $Id: ETNew.cpp,v 1.12 2003/02/09 18:46:53 mat Exp $

#include "ETNew.h"

#include "Application.h"
#include <sstream>

// FIXME: need to replace this by a more "civilised" way to create short
// FIXME: names..
static int m_CurEntityID = 0;

ETNew::ETNew (World *world) : EntityTool (world), m_Entity (NULL)
{}

ETNew::~ETNew()
{
   if (m_Entity) delete m_Entity;
}

/// Apply tool at (x,z)
void
ETNew::Apply3D(Ark::Vector3 newpos, const Ark::Collision &col)
{
   Entity *ent = GetEntity();

   if (!ent)
      return;

   ent->SetPosition (newpos);
   g_Application->PushCommand(CreateCommand());
   m_World->Update();
}

/// Update or reset tool
void
ETNew::Update()
{
   if (m_Entity) 
      delete m_Entity;
  
   m_Entity = NULL;
}

/// Create a command with a correct state.
Command*
ETNew::CreateCommand()
{

   Entity *ent = m_Entity;

   if (ent)
   {
      Command *cmd = new ECNewDelete (m_World, ent, false);
      m_Entity->Unref();
      m_Entity = NULL;
      return cmd;
   }
   else
      return NULL;
}

Entity *
ETNew::GetEntity()
{
   std::cerr << "getentity \n";
   if (m_Entity == NULL)
   {
      std::cerr << " null\n";
      //std::cerr << m_World << std::endl;
      std::ostringstream of;
      std::string mdl = g_Application->GetUI()->SelectModel ("");

      if (mdl == "")
	 return NULL;

      //std::cerr << m_World << std::endl;
      
      of << m_CurEntityID++;
      of.flush();

      m_Entity = new Entity (m_World);
      m_Entity->m_ShortName = of.str();
      m_Entity->SetTemplate ("Scenery", "");
      m_Entity->SetEntry ("model", mdl);
      m_World->Add (m_Entity);
   }

   return m_Entity;
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
ETDelete::ETDelete (World *world) : EntityTool (world), m_Entity (NULL)
{}

ETDelete::~ETDelete ()
{}
      
void
ETDelete::Apply3D (Ark::Vector3 newpos, const Ark::Collision &col)
{
   if (col.GetType() == Ark::Collision::ENTITY)
   {
      m_Entity = static_cast<Entity*>
				(const_cast<Ark::Entity*>(col.m_Entity));
      m_Entity->Ref();

      g_Application->PushCommand(CreateCommand());
      m_World->Update();
   }
   else
      m_Entity = NULL;
}
      
/// Create a command with a correct state.
Command*
ETDelete::CreateCommand()
{
   if (!m_Entity)
      return 0;

   Command *cmd = new ECNewDelete (m_World, m_Entity, true);
   cmd->Execute();
   
   m_Entity->Unref();
   m_Entity = NULL;
   return cmd;
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

ECNewDelete::ECNewDelete(World *world, Entity *entity,
			 bool deletecmd) : 
   m_World (world),
   m_Entity (entity),
   m_Delete (deletecmd)
{
   assert (m_Entity != 0);
   m_Entity->Ref();
}

ECNewDelete::~ECNewDelete()
{
   if (m_Entity)
      m_Entity->Unref();
}

/// Return the command type.
std::string
ECNewDelete::Type() const
{
   if (m_Delete)
      return "Add entity";
   else
      return "Remove entity";
}

/// Execute this command.
void
ECNewDelete::Execute()
{
   if (m_Delete == false)
      m_World->Add (m_Entity);
   else
      m_World->Remove (m_Entity);

   m_World->Update();
}

/// Undo the action done by this command.
void
ECNewDelete::Unexecute()
{
   if (m_Delete == false)
      m_World->Remove (m_Entity);
   else
      m_World->Add (m_Entity);
}
