#ifndef WE_ENTITY_H
#define WE_ENTITY_H

#include <Ark/ArkPath.h>
#include <Ark/ArkEntity.h>
#include <Ark/ArkDataClass.h>
#include "World.h"

enum EntryType
{
   ENTRY_DEF,
   ENTRY_RANGE,
   ENTRY_CLASS,
   ENTRY_BOOL,
   ENTRY_MODEL,
   ENTRY_ENUM
};


class Entity;
class Entry : public Ark::Entry
{
   public:
      Entry(){}

      void Init (Ark::ClassDef *eclass,
		 const Ark::String &name,
		 const Ark::Entry &value);

      bool m_Changed;
      Ark::EntryDef *m_Def;
      Ark::String m_Name;
      
      EntryType m_EType;
      int m_RangeMin, m_RangeMax;
      std::vector<Ark::String> m_EnumMembers;
};

typedef std::map<Ark::String,Entry> EntryList;
typedef std::map<Ark::String,Entry>::iterator EntryLI;


class Entity : public Ark::Entity, public Ark::RefCounter
{
      friend class Entry;
      friend class EntityEditor;

      EntryList m_Entries;
      Ark::ClassDef *m_Class;
      
   public:
      Entity (World *world);
      ~Entity ();

      void Edit ();
      Ark::String ToString () const;

      void SetTemplate(const Ark::String &_class,
		       const Ark::String &_template = "");
      void SetClass(Ark::ClassDef *d);

      Ark::ClassDef *GetClass() {return m_Class;}

      
      // Set/Get Entries.

      // If called from the editor (ie from SetTemplate or SetClass), the
      // following function doesn't change the name, short name, model and
      // position/rotation. This is so we can change the class without
      // losing all the informations on the model.
      void SetEntries(Ark::EntryList &entries, bool in_editor = false);

      Entry *GetEntry (const Ark::String &name)
	 {return &m_Entries[name];}

      void SetEntry(const Ark::String &name, bool value);
      void SetEntry(const Ark::String &name, int value);
      void SetEntry(const Ark::String &name, const Ark::String &value);

  public:
      virtual void Unref ()
      {
         Ref();
	     if (!InUse() && m_World == NULL) delete this;
      }
};

#endif
