// $Id: callbacks.cpp,v 1.20 2003/02/15 21:04:46 mrq Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "../Application.h" 

#include "GLTerrainView.h"
#include "GLModelView.h"
#include "CallbacksFile.h"
#include "CallbacksEdit.h"
#include "CallbacksBrowse.h"
#include "CallbacksGround.h"
#include "CallbacksHeight.h"

// Gtk+ callbacks


void
on_reset_view_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_undo_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    Application::GetApplication()->Undo();
}


void
on_redo_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    Application::GetApplication()->Redo();
}


void
on_Undo_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    Application::GetApplication()->Undo();
}


void
on_Redo_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
    Application::GetApplication()->Redo();
}



void
on_browse_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  BrowseEnabled(1);
}

void
on_set_ground_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GroundEnabled(1);
}

void
on_edit_height_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  HeightEnabled(1);
}

void
on_BrowseRadioButton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gboolean active = gtk_toggle_button_get_active( togglebutton );

  if (active)
  {
    BrowseEnabled(0);
  }
}


void
on_GroundRadioButton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gboolean active = gtk_toggle_button_get_active( togglebutton );

  if (active)
  {
    GroundEnabled(0);
  }
}


void
on_HeightRadioButton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  gboolean active = gtk_toggle_button_get_active( togglebutton );

  if (active)
  {
    HeightEnabled(0);
  }
}

gboolean
on_Properties_Dialog_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


/**********************************************************************
 *     ERROR DIALOG CALLBACKS
 **********************************************************************/

gboolean
on_Error_Dialog_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_ErrorOK_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy(lookup_widget(GTK_WIDGET(button), "Error_Dialog"));
}


/**********************************************************************
 *     BASIC FILE OPERATION - New - CALLBACKS
 **********************************************************************/

void
on_new_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  NewFileDialog();
}

void
on_New_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  NewFileDialog();
}


void
on_PropOK_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* nameEntry = lookup_widget( GTK_WIDGET(button), "PropNameEntry");
  GtkWidget* dirEntry = lookup_widget( GTK_WIDGET(button), "PropDirEntry");
  GtkWidget* widthSpin = lookup_widget( GTK_WIDGET(button), "PropWidthSpin");
  GtkWidget* heightSpin = lookup_widget( GTK_WIDGET(button), "PropHeightSpin");
  
  gchar* name = gtk_entry_get_text( GTK_ENTRY(nameEntry) );
  gchar* dir = gtk_entry_get_text( GTK_ENTRY(dirEntry) );
  gint w = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(widthSpin) );
  gint h = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(heightSpin) );

  NewFile(name, dir, w, h);

  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


void
on_PropCancel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


/**********************************************************************
 *     BASIC FILE OPERATION - Open - CALLBACKS
 **********************************************************************/

void
on_open_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  OpenFileDialog();
}

void
on_Open_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  OpenFileDialog();
}


gboolean
on_OpenDialog_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy( widget );
  return FALSE;
}


void
on_OpenDialogOK_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkFileSelection* FileSel = GTK_FILE_SELECTION( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
  gchar* FileName = gtk_file_selection_get_filename(FileSel);

  std::cerr << FileName << std::endl;

  if (FileName) {
    OpenFile(FileName);
  }
  
  gtk_widget_destroy( GTK_WIDGET(FileSel) );
}


void
on_OpenDialogCancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


/**********************************************************************
 *     BASIC FILE OPERATION - Save / Save as - CALLBACKS
 **********************************************************************/

void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SaveFileDialog();
}

void
on_Save_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{ 
  SaveFileDialog();
}

void
on_save_as_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SaveAsFileDialog();
}


void
on_SaveDialogOK_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkFileSelection* FileSel = GTK_FILE_SELECTION( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
  gchar* FileName = gtk_file_selection_get_filename(FileSel);

  if (FileName) {
    SaveFile(FileName);
  }
  
  gtk_widget_destroy( GTK_WIDGET(FileSel) );
}


void
on_SaveDialogCancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


gboolean
on_SaveDialog_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy( widget );
  return FALSE;
}



/**********************************************************************
 *     QUITTING THE APPLICATION CALLBACKS
 **********************************************************************/

// Closing main window
gboolean
on_MainWindow_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  QuitApplicationDialog();
  return TRUE;
}

// Clicking Quit in File menu
void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  QuitApplicationDialog();
}

// If we kill the quit dialog, we quit without saving
gboolean
on_Quit_Dialog_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_main_quit();
  return FALSE;
}

// Clicking on Discard changes
void
on_QuitDiscardButton_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit();
}

// Clicking on Cancel quitting
void
on_QuitCanceButton_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


/**********************************************************************
 *     MAIN VIEW WIDGET CALLBACKS
 **********************************************************************/

gboolean
on_GLView_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->ButtonPress( int(event->x), int(event->y), event->button, event->state);
}


gboolean
on_GLView_button_release_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->ButtonRelease( int(event->x), int(event->y), event->button, event->state);
}


gboolean
on_GLView_motion_notify_event          (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  int x, y;
  int state;
  
  GLView* view = GLView::GetView( widget );

  if (event->is_hint)
  {
    GdkModifierType s;
    gdk_window_get_pointer(event->window, &x, &y, &s);
    state = static_cast<int>( s );
  }
  else
  {
    x = static_cast<int>( event->x );
    y = static_cast<int>( event->y );
    state = event->state;
  }

  return view->Motion(x, y, state);
}


gboolean
on_GLView_expose_event                 (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  return view->Expose();
}


gboolean
on_GLView_destroy_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GLView* view = GLView::GetView( widget );
  delete view;

  return FALSE;
}


GtkWidget*
MainGLView_create (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
  TerrainView* terrain = Application::GetApplication()->GetTerrain();
  GLTerrainView* view = new GLTerrainView( terrain );
  return GTK_WIDGET( view->GetArea() );
}



/**********************************************************************
 *    GROUND BRUSH CALLBACKS
 **********************************************************************/

void
on_AddBrush_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  AddGroundBrushDialog();
}


gboolean
on_AddBrushDialog_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_destroy( widget );
  return FALSE;
}


void
on_AddBrushCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
}


void
on_AddBrushOK_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkFileSelection* FileSel = GTK_FILE_SELECTION( gtk_widget_get_toplevel(GTK_WIDGET(button)) );
  gchar* FileName = gtk_file_selection_get_filename(FileSel);

  if (FileName) {
    AddGroundFile(FileName);
  }
  
  gtk_widget_destroy( GTK_WIDGET(FileSel) );
}


void
on_Delete_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_BrushList_select_row                (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GroundEnabled(1);
  SelectGround(row);
}


void
on_GBSizeSpin_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gint size = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(editable) );
  UpdateGroundSize(size);
}


void
on_GBTypeOption_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  //GtkWidget* option_menu = lookup_widget (GTK_WIDGET (button), "optionmenu1");
  GtkWidget* menu = GTK_OPTION_MENU( button )->menu;
  GtkWidget* active_item = gtk_menu_get_active( GTK_MENU(menu) );
  int active_index = g_list_index( GTK_MENU_SHELL(menu)->children, active_item);

  UpdateGroundType(active_index);
}


/**********************************************************************
 *    HEIGHT OPERATIONS CALLBACKS
 **********************************************************************/

void
on_TransformList_select_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   if (column == -1)
      return;

   HeightEnabled(1);
   SelectHeightOperation(row);
}


void
on_HBSizeSpin_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gint size = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(editable) );
  UpdateHeightSize(size);
}


void
on_HBStrengthSpin_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gint strength = gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON(editable) );
  UpdateHeightStrength(strength);
}



void
on_ToolsNotebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  // FIXME: this hardcoded parameter for origin is an UGLY HACK.
  switch (page_num)
  {
    case 0: BrowseEnabled (2); break;
    case 1: GroundEnabled (2); break;
    case 2: HeightEnabled (2); break;
  }
}

void
on_EntityModeList_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   SelectEntityMode (row);
}


extern void CreateWorldPropsWindow();

void
on_world_properties_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   CreateWorldPropsWindow();
}

