/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;

public class TableConverter
extends ConverterHelper {
    protected Vector sheetNames = new Vector();

    public TableConverter(OfficeReader ofr, Config config, Converter converter) {
        super(ofr, config, converter);
    }

    public void convertTableContent(Element onode) {
        Element hnode = null;
        if (!onode.hasChildNodes()) {
            return;
        }
        if (!this.config.xhtmlCalcSplit()) {
            hnode = this.nextOutFile();
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            StyleWithProperties style;
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() == 1 && (sNodeName = child.getNodeName()).equals("table:table") && ((style = this.ofr.getTableStyle(Misc.getAttribute(child, "table:style-name"))) == null || !"false".equals(style.getProperty("table:display")))) {
                if (this.config.xhtmlCalcSplit()) {
                    hnode = this.nextOutFile();
                }
                String sName = Misc.getAttribute(child, "table:name");
                this.sheetNames.add(sName);
                Element heading = this.converter.createElement("h2");
                hnode.appendChild(heading);
                heading.setAttribute("id", "tableheading" + (this.sheetNames.size() - 1));
                heading.appendChild(this.converter.createTextNode(sName));
                this.handleTable(child, hnode);
                Element div = this.converter.createElement("div");
                Element shapes = Misc.getChildByTagName(child, "table:shapes");
                if (shapes != null) {
                    Node shape = shapes.getFirstChild();
                    while (shape != null) {
                        if (OfficeReader.isDrawElement(shape)) {
                            this.getDrawCv().handleDrawElement((Element)shape, div, null, 3);
                        }
                        shape = shape.getNextSibling();
                    }
                }
                this.getDrawCv().flushFrames(div);
                if (div.hasChildNodes()) {
                    hnode.appendChild(div);
                }
            }
            ++i;
        }
    }

    private Element nextOutFile() {
        Element hnode = this.converter.nextOutFile();
        String sTitle = this.converter.getMetaData().getTitle();
        if (sTitle != null) {
            Element title = this.converter.createElement("h1");
            hnode.appendChild(title);
            title.appendChild(this.converter.createTextNode(sTitle));
        }
        return hnode;
    }

    public void handleTable(Node onode, Node hnode) {
        int nColCount;
        int nRowCount;
        TableReader tblr = this.ofr.getTableReader((Element)onode);
        Element table = this.converter.createElement("table");
        this.converter.addTarget(table, tblr.getTableName() + "%7Ctable");
        hnode.appendChild(table);
        table.setAttribute("cellspacing", "0");
        boolean bIsSubtable = tblr.isSubTable();
        this.applyTableStyle(tblr.getTableStyleName(), table, bIsSubtable);
        if (this.ofr.isText()) {
            nRowCount = tblr.getRowCount();
            nColCount = tblr.getColCount();
        } else {
            nRowCount = tblr.getMaxRowCount();
            nColCount = tblr.getMaxColCount();
        }
        boolean bFirstRowColSpan = false;
        int nCol = 0;
        while (nCol < nColCount) {
            String sColSpan;
            Node cell = tblr.getCell(0, nCol);
            if (cell != null && "table:table-cell".equals(cell.getNodeName()) && Misc.getPosInteger(sColSpan = Misc.getAttribute(cell, "table:number-columns-spanned"), 1) > 1) {
                bFirstRowColSpan = true;
            }
            ++nCol;
        }
        if (!this.config.xhtmlIgnoreTableDimensions()) {
            Element col;
            if (tblr.getRelTableWidth() != null) {
                int nCol2 = 0;
                while (nCol2 < nColCount) {
                    col = this.converter.createElement("col");
                    table.appendChild(col);
                    col.setAttribute("style", "width:" + tblr.getRelColumnWidth(nCol2));
                    ++nCol2;
                }
            } else if (bFirstRowColSpan) {
                int nCol3 = 0;
                while (nCol3 < nColCount) {
                    col = this.converter.createElement("col");
                    table.appendChild(col);
                    col.setAttribute("style", "width:" + this.getTableSc().colScale(tblr.getColumnWidth(nCol3)));
                    ++nCol3;
                }
            }
        }
        Element thead = this.converter.createElement("thead");
        Element tbody = this.converter.createElement("tbody");
        Element tgroup = thead;
        if (tblr.getRow(nRowCount - 1).isHeader()) {
            tgroup = tbody;
        }
        int nRow = 0;
        while (nRow < nRowCount) {
            if (!tblr.getRow(nRow).isHeader()) {
                tgroup = tbody;
            }
            Element tr = this.converter.createElement("tr");
            tgroup.appendChild(tr);
            this.applyRowStyle(tblr.getRow(nRow).getStyleName(), tr);
            int nCol4 = 0;
            while (nCol4 < nColCount) {
                Node cell = tblr.getCell(nRow, nCol4);
                if (cell != null && "table:table-cell".equals(cell.getNodeName())) {
                    String sColSpan;
                    Element td = this.converter.createElement("td");
                    tr.appendChild(td);
                    int nRowSpan = Misc.getPosInteger(Misc.getAttribute(cell, "table:number-rows-spanned"), 1);
                    if (nRowSpan > 1) {
                        td.setAttribute("rowspan", Integer.toString(nRowSpan));
                    }
                    if (Misc.getPosInteger(sColSpan = Misc.getAttribute(cell, "table:number-columns-spanned"), 1) > 1) {
                        td.setAttribute("colspan", sColSpan);
                    }
                    if (!this.isEmptyCell(cell)) {
                        this.getTextCv().traverseBlockText(cell, td);
                    } else {
                        Element par = this.converter.createElement("p");
                        td.appendChild(par);
                        par.setAttribute("style", "margin:0;font-size:1px");
                        par.appendChild(this.converter.createTextNode("\u00a0"));
                    }
                    Element subTable = Misc.getChildByTagName(cell, "table:sub-table");
                    String sTotalWidth = null;
                    if (Misc.getPosInteger(sColSpan, 1) == 1) {
                        sTotalWidth = tblr.getCellWidth(nRow, nCol4);
                    }
                    String sValueType = this.ofr.isOpenDocument() ? Misc.getAttribute(cell, "office:value-type") : Misc.getAttribute(cell, "table:value-type");
                    this.applyCellStyle(tblr.getCellStyleName(nRow, nCol4), sTotalWidth, sValueType, td, subTable != null);
                } else if ("table:covered-table-cell".equals(cell.getNodeName())) {
                    // empty if block
                }
                ++nCol4;
            }
            ++nRow;
        }
        if (thead.hasChildNodes()) {
            table.appendChild(thead);
        }
        table.appendChild(tbody);
    }

    private boolean isEmptyCell(Node cell) {
        if (!cell.hasChildNodes()) {
            return true;
        }
        if (OfficeReader.isSingleParagraph(cell)) {
            Element par = Misc.getChildByTagName(cell, "text:p");
            return par == null || !par.hasChildNodes();
        }
        return false;
    }

    private void applyTableStyle(String sStyleName, Element table, boolean bIsSubTable) {
        StyleWithProperties style;
        StyleInfo info = new StyleInfo();
        this.getTableSc().applyStyle(sStyleName, info);
        if (!this.config.xhtmlIgnoreTableDimensions() && (style = this.ofr.getTableStyle(sStyleName)) != null) {
            String sWidth = style.getProperty("style:rel-width");
            if (sWidth != null) {
                info.props.addValue("width", sWidth);
            } else {
                sWidth = style.getProperty("style:width");
                if (sWidth != null) {
                    info.props.addValue("width", this.getTableSc().colScale(sWidth));
                }
            }
        }
        info.props.addValue("border-collapse", "separate");
        info.props.addValue("border-spacing", "0");
        info.props.addValue("table-layout", "fixed");
        if (this.ofr.isSpreadsheet()) {
            info.props.addValue("white-space", "nowrap");
        }
        if (bIsSubTable) {
            info.props.addValue("width", "100%");
            info.props.addValue("margin", "0");
        }
        this.applyStyle(info, table);
    }

    private void applyRowStyle(String sStyleName, Element row) {
        String s;
        StyleWithProperties style;
        StyleInfo info = new StyleInfo();
        this.getRowSc().applyStyle(sStyleName, info);
        if (!this.config.xhtmlIgnoreTableDimensions() && (style = this.ofr.getRowStyle(sStyleName)) != null && (s = style.getAbsoluteProperty("style:row-height")) != null) {
            info.props.addValue("height", this.getRowSc().scale(s));
        }
        this.applyStyle(info, row);
    }

    private void applyCellStyle(String sStyleName, String sTotalWidth, String sValueType, Element cell, boolean bIsSubTable) {
        StyleInfo info = new StyleInfo();
        this.getCellSc().applyStyle(sStyleName, info);
        StyleWithProperties style = this.ofr.getCellStyle(sStyleName);
        if (style != null) {
            if (!this.config.xhtmlIgnoreTableDimensions()) {
                String sEdge = "0";
                String s = style.getProperty("fo:padding-left");
                if (s != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(s));
                }
                if ((s = style.getProperty("fo:padding-right")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(s));
                }
                if ((s = style.getProperty("fo:padding")) != null) {
                    sEdge = Misc.add(sEdge, Misc.multiply("200%", this.getTableSc().colScale(s)));
                }
                if ((s = style.getProperty("fo:border-left")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(this.borderWidth(s)));
                }
                if ((s = style.getProperty("fo:border-right")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(this.borderWidth(s)));
                }
                if ((s = style.getProperty("fo:border")) != null) {
                    sEdge = Misc.add(sEdge, Misc.multiply("200%", this.getTableSc().colScale(this.borderWidth(s))));
                }
                if (sTotalWidth != null) {
                    info.props.addValue("width", Misc.sub(this.getTableSc().colScale(sTotalWidth), sEdge));
                }
            }
            if (this.ofr.isSpreadsheet() && !"fix".equals(style.getProperty("style:text-align-source"))) {
                info.props.addValue("text-align", sValueType == null || "string".equals(sValueType) ? "left" : "right");
            }
        }
        if (!cell.hasChildNodes()) {
            cell.appendChild(this.converter.createTextNode("\u00a0"));
        }
        if (bIsSubTable) {
            info.props.addValue("vertical-align", "top");
            info.props.addValue("padding", "0");
        }
        this.applyStyle(info, cell);
    }

    /*
     * Unable to fully structure code
     */
    private String borderWidth(String sBorder) {
        if (sBorder == null || sBorder.equals("none")) {
            return "0";
        }
        in = new SimpleInputBuffer(sBorder);
        ** GOTO lbl13
        {
            in.getChar();
            do {
                if (in.peekChar() == ' ') continue block0;
                if ('0' <= in.peekChar() && in.peekChar() <= '9') {
                    return in.getNumber() + in.getIdentifier();
                }
                while (in.peekChar() != ' ' && in.peekChar() != '\u0000') {
                }
lbl13:
                // 2 sources

            } while (in.peekChar() != '\u0000');
        }
        return "0";
    }
}

