# taken from http://www.cmake.org/Wiki/CMakeMacroLibtoolFile
# modified to add VERSION and SOVERSION

MACRO(CREATE_LIBTOOL_FILE _target _install_DIR)
  GET_TARGET_PROPERTY(_target_location ${_target} LOCATION)
  GET_TARGET_PROPERTY(_target_version ${_target} VERSION)
  GET_TARGET_PROPERTY(_target_soversion ${_target} SOVERSION)
  GET_FILENAME_COMPONENT(_laname ${_target_location} NAME_WE)
  GET_FILENAME_COMPONENT(_soname ${_target_location} NAME)
  SET(_laname_abs "${CMAKE_CURRENT_BINARY_DIR}/${_laname}.la")
#  SET(_laname "${_install_DIR}/${_laname}.la")
  FILE(WRITE ${_laname_abs} "# ${_laname}.la - a libtool library file\n")
  FILE(APPEND ${_laname_abs} "# Generated by cmake - GNU libtool 1.5.22\n")
  FILE(APPEND ${_laname_abs} "# The name that we can dlopen(3).\n")
  FILE(APPEND ${_laname_abs} "dlname='${_soname}.${_target_soversion}'\n\n")
  FILE(APPEND ${_laname_abs} "# Names of this library.\n")
  FILE(APPEND ${_laname_abs} "library_names='${_soname}.${_target_version} ${_soname}.${_target_soversion} ${_soname}'\n\n")
  FILE(APPEND ${_laname_abs} "# The name of the static archive.\n")
  FILE(APPEND ${_laname_abs} "old_library=''\n\n")
  FILE(APPEND ${_laname_abs} "# Libraries that this one depends upon.\n")
  FILE(APPEND ${_laname_abs} "dependency_libs=''\n\n")
  FILE(APPEND ${_laname_abs} "# Version information.\ncurrent=0\nage=0\nrevision=0\n\n")
  FILE(APPEND ${_laname_abs} "# Is this an already installed library?\ninstalled=yes\n\n")
  FILE(APPEND ${_laname_abs} "# Should we warn about portability when linking against -modules?\nshouldnotlink=yes\n\n")
  FILE(APPEND ${_laname_abs} "# Files to dlopen/dlpreopen\ndlopen=''\ndlpreopen=''\n\n")
  FILE(APPEND ${_laname_abs} "# Directory that this library needs to be installed in:\n")
  FILE(APPEND ${_laname_abs} "libdir='${CMAKE_INSTALL_PREFIX}${_install_DIR}'\n")
  INSTALL_FILES(${_install_DIR} FILES ${_laname_abs})
ENDMACRO(CREATE_LIBTOOL_FILE)
