/*
 * $Id: track_gui.c,v 1.13 2001/05/01 14:33:46 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <Xm/XmAll.h>

#include "main.h"
#include "xastir.h"
#include "db.h"
#include "main.h"
#include "lang.h"
#include "popup.h"



Widget track_station_dialog = (Widget)NULL;
Widget track_station_data = (Widget)NULL;

static xastir_mutex track_station_dialog_lock;

/* track values */
Widget track_case_data, track_match_data;

int track_station_on;           /* used for tracking stations */
int track_case;                 /* used for tracking stations */
int track_match;                /* used for tracking stations */
char tracking_station_call[30]; /* Tracking station callsign */



void track_gui_init(void)
{
    init_critical_section( &track_station_dialog_lock );
}



/**** Track STATION ******/

void track_station_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);

begin_critical_section(&track_station_dialog_lock, "track_gui.c:track_station_destroy_shell" );

    XtDestroyWidget(shell);
    track_station_dialog = (Widget)NULL;

end_critical_section(&track_station_dialog_lock, "track_gui.c:track_station_destroy_shell" );

}



void Track_station_clear(Widget w, XtPointer clientData, XtPointer callData) {
    /* clear station */
    track_station_on=0;
    track_station_data=NULL;
    strcpy(tracking_station_call,"");
    track_station_destroy_shell(w, clientData, callData);
    display_zoom_status();
}



void Track_station_now(Widget w, XtPointer clientData, XtPointer callData) {
    char temp[MAX_CALL+1];
    char temp2[200];

    /* find station and go there */
    strcpy(temp,XmTextFieldGetString(track_station_data));
    (void)remove_trailing_spaces(temp);
    strcpy(tracking_station_call,temp);
    track_case  = (int)XmToggleButtonGetState(track_case_data);
    track_match = (int)XmToggleButtonGetState(track_match_data);
    track_station_on = locate_station(da, temp, track_case, track_match, 0);
    if (track_station_on != 1) {
        sprintf(temp2,langcode("POPEM00002"),temp);
        popup_message(langcode("POPEM00003"),temp2);
    }
    track_station_destroy_shell(w, clientData, callData);
    display_zoom_status();
}



void Track_station( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget pane, my_form, button_ok, button_cancel, button_clear, call, sep;
    Atom delw;

    if (!track_station_dialog) {

begin_critical_section(&track_station_dialog_lock, "track_gui.c:Track_station" );

        track_station_dialog = XtVaCreatePopupShell(langcode("WPUPTSP001"),xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, track_station_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 3,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

        call = XtVaCreateManagedWidget(langcode("WPUPTSP002"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        track_station_data = XtVaCreateManagedWidget("track locate data", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 15,
                                      XmNwidth, ((15*7)+2),
                                      XmNmaxLength, 15,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_FORM,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, call,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        track_case_data  = XtVaCreateManagedWidget(langcode("WPUPTSP003"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, call,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        track_match_data  = XtVaCreateManagedWidget(langcode("WPUPTSP004"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, call,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget,track_case_data,
                                      XmNrightOffset ,20,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,my_form,
                                      XmNorientation, XmHORIZONTAL,
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget,track_case_data,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNbackground, colors[0xff],
                                      NULL);

        button_ok = XtVaCreateManagedWidget(langcode("WPUPTSP005"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset, 5,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 1,
                                      XmNbackground, colors[0xff],
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        button_clear = XtVaCreateManagedWidget(langcode("WPUPTSP006"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 1,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 2,
                                      XmNbackground, colors[0xff],
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 3,
                                      XmNrightOffset, 5,
                                      XmNbackground, colors[0xff],
                                      XmNnavigationType, XmTAB_GROUP,
                                      XmNtraversalOn, TRUE,
                                      NULL);

        XtAddCallback(button_ok, XmNactivateCallback, Track_station_now, track_station_dialog);
        XtAddCallback(button_cancel, XmNactivateCallback, track_station_destroy_shell, track_station_dialog);
        XtAddCallback(button_clear, XmNactivateCallback, Track_station_clear, track_station_dialog);

        XmToggleButtonSetState(track_case_data,FALSE,FALSE);
        XmToggleButtonSetState(track_match_data,TRUE,FALSE);

        pos_dialog(track_station_dialog);

        delw = XmInternAtom(XtDisplay(track_station_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(track_station_dialog, delw, track_station_destroy_shell, (XtPointer)track_station_dialog);

        if (track_station_on==1)
            XmTextFieldSetString(track_station_data,tracking_station_call);

        XtManageChild(my_form);
        XtManageChild(pane);

end_critical_section(&track_station_dialog_lock, "track_gui.c:Track_station" );

        XtPopup(track_station_dialog,XtGrabNone);
        fix_dialog_size(track_station_dialog);
    } else
        (void)XRaiseWindow(XtDisplay(track_station_dialog), XtWindow(track_station_dialog));
}

