/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardPINV.cpp
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#include <stdio.h>

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#include <qmessagebox.h>

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#include "xcardPINV.h"

#ifdef MSC_TARGET_WIN32
#define snprintf _snprintf
#endif

#define Inherited xcardPINVData

static MSCUChar8 idStateMain = 0;

xcardPINV::xcardPINV
(
        MSCLPTokenConnection pConn,
	QListViewItem *pinSelected,
	int pinNum,
	bool unblockPIN,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{

  //MSCUChar8 bytesCap[4];
  MSCULong32 capLength;
  MSCLong32 rv;

  isUnBlock          = unblockPIN;
  pConnect           = pConn;
  pinNumber          = pinNum;
  currentPINSelected = pinSelected;

  if (isUnBlock == TRUE) {
    g_pinVerifyTitle1->setText("Unblock PIN");
  } 
  g_pinEntryBox1->setEchoMode(QLineEdit::Password);
  g_pinNumberBox1->setValue(pinNumber);

  rv = MSCGetCapabilities(pConn, MSC_TAG_CAPABLE_ID_STATE, 
			  (MSCPUChar8)&idStateMain, &capLength);

  if ( rv != MSC_SUCCESS ) {
    idStateMain = 0;
  }
  
}

xcardPINV::~xcardPINV()
{
}

void xcardPINV::XCVerifyPINCancelled() {
  hide();
}

void xcardPINV::XCVerifyPINClicked() {

  QString pinValue;
  QString pinNumText;
  MSCULong32 pinLength;
  MSCUChar8 pinValueBytes[100];
  char errorString[200];
  MSCULong32 pinNum;
  bool isOK;
  MSCLong32 rv;

  rv = 0;

  pinValue = g_pinEntryBox1->text();

  do {

    if ( pinValue.isEmpty() ) {
      break;
    } else {
      pinLength = pinValue.length();
      pinNumText = g_pinNumberBox1->text();
      
      pinNum = pinNumText.toULong(&isOK, 10);
      memcpy(pinValueBytes, pinValue.latin1(), pinLength);
      
      if ( pinNumText.isNull() ) {
	break;
      }

      if (isUnBlock == TRUE) {
	rv = MSCUnblockPIN( pConnect, pinNumber, pinValueBytes,
			    pinLength );
      } else {
	rv = MSCVerifyPIN( pConnect, pinNumber, pinValueBytes,
			   pinLength );
      }

      if ( rv == MSC_SUCCESS && isUnBlock == FALSE) {
	hide();
	if ( idStateMain ) {
	  currentPINSelected->setText(1, "Verified");
	}
	return;
      } else if ( rv == MSC_SUCCESS && isUnBlock == TRUE ) {
	hide();
	QMessageBox::information( 0, "XCard II",
				  QString("Unblock Successful"));
	if ( idStateMain ) {
	  currentPINSelected->setText(1, "UnVerified");
	}

	return;
      } else if (rv == MSC_IDENTITY_BLOCKED) {
	if ( idStateMain ) {
	  currentPINSelected->setText(1, "Blocked");
	}
	break;
      } else {
	break;
      }
    }

  } while (0);

  if (rv != 0) {
    snprintf(errorString, sizeof(errorString), "Invalid PIN/Unblock\nCode: %s",
	     msc_error(rv));
    QMessageBox::critical( 0, "XCard II", errorString);
  } else {
    QMessageBox::critical( 0, "XCard II",
			   QString("Invalid PIN/Unblock Entry "));
  }
}
