#ifndef xproxy_h
#define xproxy_h

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <signal.h>
#include <zlib.h>

#include "globals.h"
#include "socket.h"
#include "request.h"
#include "parse.h"
#include "base64.h"

#include "storage.h"

#define OS_CODE  0x03  /* assume Unix */

void prepareRequest(Request *request);

void prepareResponse(Request *request);

void prepareMessage(Request *request, const char *status, char *description);

bool processClientRequest(Request *request);

bool processServerResponse(Request *request);

bool sendHTTPMessage(Request *request, MessageType messageType);

unsigned long convLong(uLong x);

#endif xproxy_h
