/*
 * Character definition
 *
 * Copyright (c) 1995
 *      ONO Kouichi             onono@fuka.info.waseda.ac.jp
 * All rights reserved.
 */

#ifndef _CHARDEF_H_
#define _CHARDEF_H_

#define CHAR_NULL       '\000'
#define CHAR_SPACE      ' '
#define CHAR_TAB        '\t'
#define CHAR_NEWLINE    '\n'
#define CHAR_SHARP      '#'
#define CHAR_PERIOD     '.'
#define CHAR_COMMA      ','
#define CHAR_SLASH      '/'
#define CHAR_HYPHEN     '-'
#define CHAR_ASTERISK   '*'
#define CHAR_EQUAL      '='
#define CHAR_COLON      ':'
#define CHAR_PERCENT    '%'
#define CHAR_OPEN_ANGLE_BRACKET         '<'
#define CHAR_CLOSE_ANGLE_BRACKET        '>'

#define ISWHITESPACE(c) ((c==CHAR_SPACE) || (c==CHAR_TAB) || (c==CHAR_NEWLINE))
#define ISENDOFLINE(c)  ((c==CHAR_NEWLINE) || (c==CHAR_NULL))

#endif  /* _CHARDEF_H_ */
