/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASTBlock;
import bsh.ASTFormalParameters;
import bsh.ASTReturnType;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import java.util.Vector;

public class ASTMethodDeclaration
extends SimpleNode {
    public String name;
    public Vector argVector = new Vector();
    private ASTFormalParameters params;
    private ASTBlock block;
    Object returnType;

    ASTMethodDeclaration(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        if (this.block == null) {
            if (this.jjtGetNumChildren() == 3) {
                this.returnType = ((ASTReturnType)this.jjtGetChild(0)).getReturnType(nameSpace, interpreter);
                this.params = (ASTFormalParameters)this.jjtGetChild(1);
                this.block = (ASTBlock)this.jjtGetChild(2);
            } else {
                this.params = (ASTFormalParameters)this.jjtGetChild(0);
                this.block = (ASTBlock)this.jjtGetChild(1);
            }
            this.params.eval(nameSpace, interpreter);
        }
        nameSpace.setMethod(this.name, this);
        return Primitive.VOID;
    }

    public Object invokeDeclaredMethod(NameSpace nameSpace, Interpreter interpreter, Object[] objectArray) throws EvalError {
        if (interpreter == null) {
            System.err.println("Warning: method call with null interpreter... fix me!");
        }
        if (this.params.numArgs != objectArray.length) {
            try {
                Name name = new Name(nameSpace, "bsh.help." + this.name);
                String string = (String)name.toObject(interpreter);
                interpreter.println(string);
                return Primitive.VOID;
            }
            catch (Exception exception) {
                throw new EvalError("Wrong number of arguments for local method: " + this.name, this);
            }
        }
        NameSpace nameSpace2 = new NameSpace(nameSpace, "Method NameSpace: " + this.name, interpreter);
        int n = 0;
        while (n < this.params.numArgs) {
            if (this.params.argTypes[n] != null) {
                try {
                    objectArray[n] = NameSpace.checkAssignableFrom(objectArray[n], this.params.argTypes[n]);
                }
                catch (EvalError evalError) {
                    throw new EvalError("Incorrect argument type for parameter: " + this.params.argNames[n] + " in method: " + this.name + ": " + evalError.getMessage(), this);
                }
                nameSpace2.setTypedVariable(this.params.argNames[n], this.params.argTypes[n], objectArray[n], false);
            } else {
                if (objectArray[n] == Primitive.VOID) {
                    throw new EvalError("Attempt to pass void parameter: " + this.params.argNames[n] + " to method: " + this.name, this);
                }
                nameSpace2.setVariable(this.params.argNames[n], objectArray[n]);
            }
            ++n;
        }
        Object object = this.block.eval(nameSpace2, interpreter);
        if (object instanceof ReturnControl) {
            ReturnControl returnControl = (ReturnControl)object;
            if (returnControl.kind == 40) {
                object = ((ReturnControl)object).value;
            } else {
                throw new EvalError("continue or break in method body", this);
            }
        }
        if (this.returnType != null) {
            if (this.returnType == Primitive.VOID) {
                return this.returnType;
            }
            try {
                object = NameSpace.checkAssignableFrom(object, (Class)this.returnType);
            }
            catch (EvalError evalError) {
                throw new EvalError("Incorrect type returned from method: " + this.name + evalError.getMessage(), this);
            }
        }
        return object;
    }

    public String toString() {
        return "MethodDeclaration: " + this.name;
    }
}

