#ifndef DIRPANEL_H
#define DIRPANEL_H
#include "DirList.h"
#include "Properties.h"


class DirPanel : public FXVerticalFrame
{
    FXDECLARE(DirPanel)
    friend class XFileExplorer;
	friend class FilePanel;
protected:
    FXIcon	*attricon;
    FXIcon 	*archicon;
    FXIcon	*newfoldericon;
    FXIcon	*delicon;
	FXIcon	*copyicon;
	FXIcon	*cuticon;
	FXIcon	*pasteicon;
	FXIcon	*mapicon;
	FXIcon	*unmapicon;
	FXIcon	*xtermicon;
	FXIcon	*symlinkicon;
	FXIcon	*renameicon;
	FXIcon	*moveicon;
	FXIcon	*exptreeicon;
	FXIcon	*expfoldericon;
	FXIcon	*colltreeicon;
	FXIcon	*collfoldericon;
	DirList	*list;
	FXPacker *statusbar;
    FXLabel	*status;

public:
DirPanel(FXComposite *p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
    DirPanel()
    {}
    virtual void create();
    ~DirPanel();
    enum {
        ID_DIR_PANEL=FXVerticalFrame::ID_LAST,
		ID_EXPANDDIR,
		ID_EXPANDTREE,
		ID_TOGGLE_HIDDEN,
		ID_COLLAPSEDIR,
		ID_COLLAPSETREE,
		ID_PROPERTIES,
		ID_ARCHIVE,
		ID_DIR_COPY,
		ID_DIR_MOVE,
		ID_DIR_RENAME,
		ID_DIR_SLINK,
		ID_DIR_DELETE,
		ID_NEW_DIR,
		ID_XTERM,
		ID_COPY_CLP,
		ID_CUT_CLP,
		ID_PASTE_CLP,
        ID_TOGGLE_TREE,
		ID_STATUS,
#if defined(linux)
        ID_MOUNT,
        ID_UMOUNT,
#endif
        ID_LAST,
    	};
	long exploreUp(DirItem *item, const DirItem *rootitem, const FXint task);
	long exploreDown(DirItem *item, const DirItem *rootitem, const FXint task);
public:
	long onCmdToggleHidden(FXObject*,FXSelector,void*);
	long onUpdToggleHidden(FXObject* sender,FXSelector,void*);
	long onPopupMenu(FXObject*,FXSelector,void*);
	long onExpandDir(FXObject*,FXSelector,void*);
	long onExpandTree(FXObject*,FXSelector,void*);
	long onCollapseDir(FXObject*,FXSelector,void*);
	long onCollapseTree(FXObject*,FXSelector,void*);
	long onCmdProperties(FXObject*,FXSelector,void*);
	long onCmdAddToArch(FXObject*,FXSelector,void*);
	long onCmdDirMan(FXObject*,FXSelector,void*);
	long onCmdDirDel(FXObject*,FXSelector,void*);
	long onCmdNewDir(FXObject*,FXSelector,void*);
	long onCmdXTerm(FXObject*,FXSelector,void*);
	long onCmdClp(FXObject*,FXSelector,void*);
	long onCmdPaste(FXObject*,FXSelector,void*);
	long onUpdPaste(FXObject* o,FXSelector,void*);
	long onCmdDirectory(FXObject*,FXSelector,void* ptr);
	long onCmdToggleTree(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdToggleTree(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdStatus(FXObject* sender,FXSelector,void*);
	long onExpand(FXObject*,FXSelector,void* ptr);
#if defined(linux)
	long onCmdMount(FXObject*,FXSelector sel,void*);
#endif
};
#endif
