#ifndef XFM_MIME_H
#define XFM_MIME_H

struct mime_filetype;
struct mime_action {
	struct mime_action *next;
	char *view,*compose,*edit,*print,*drop;
	char *test;
	char *nameprefix; const char *namesuffix;
	char *notes,*description,*x11bitmap;
	int priority;
	bool testOK,editOK,viewOK;
	bool needsterminal,copiosoutput;
	/* for verbose output */
	struct mime_filetype *type;
};

struct mime_filetype {
	const char *subtypename;
	char *fulltypename;
	struct mime_filetype *fallback;
	struct mime_action *actions;
	struct filetype_data *data;
	/* from mime.types? */
	bool official;
	bool iconfailed;
};

/* create filetype if not found, returns NULL if OutOfMemory */
struct mime_filetype *mime_get_filetype(const char *identifier);

int mime_init(void);
typedef void initfunc(struct mime_filetype *);
int mime_parse_types(const char *filename, initfunc);
int mime_parse_mailcap(const char *filename);

typedef bool mime_action_func(const struct mime_action *,const char *,const char *,const char *);

enum mime_start_type { MIME_START_ANY, MIME_START_EDIT, MIME_START_VIEW };

bool mime_best_action(struct mime_filetype *mime_type,const char *directory,const char *filename,enum mime_start_type how,
		mime_action_func *start, bool echo);
#endif
