#include <xfmconfig.h>

/* to get asprintf */
#define _GNU_SOURCE 1
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include "global.h"

#include "mime.h"

static char *filename = NULL;

static void showtype(struct mime_action *type) {
	printf("view: %s\n",type->view);
	if( !type->testOK ) {
		printf("test failed, not using this one\n");
	}
	if( type->compose != NULL ) {
		printf("compose: %s\n",type->compose);
	}
	if( type->edit != NULL ) {
		printf("edit: %s\n",type->edit);
	}
	if( type->print != NULL ) {
		printf("print: %s\n",type->print);
	}
	if( type->description != NULL ) {
		printf("description: %s\n",type->description);
	}
	if( type->test != NULL ) {
		printf("test: %s\n",type->test);
	}
	if( type->notes != NULL ) {
		printf("notes: %s\n",type->notes);
	}
	if( type->x11bitmap != NULL ) {
		printf("x11bitmap: %s\n",type->x11bitmap);
	}
	if( type->needsterminal ) {
		printf("needsterminal\n");
	}
	if( type->copiosoutput ) {
		printf("copiosoutput\n");
	}
}

static bool show_action(const struct mime_action *type,const char *command,UNUSED(const char *a),UNUSED(const char *b)) {
	printf("action to execute: %s\n", command);
	if( type->test != NULL ) {
		printf("successfull test was: %s\n",type->test);
	}
	if( type->needsterminal ) {
		printf("needsterminal\n");
	}
	if( type->copiosoutput ) {
		printf("copiosoutput\n");
	}
	return true;
}


int main(int argc,char *argv[]) {
	char *buffer;

	mime_init();
	if( asprintf(&buffer,"%s/.xfm/xfm_mailcap",getenv("HOME")) >= 0 && buffer != NULL ) {
		if( mime_parse_mailcap(buffer) == 0 )
			mime_parse_mailcap(XFM_CONFDIR "/xfm_mailcap");
		free(buffer);
	} else {
		mime_parse_mailcap(XFM_CONFDIR "/xfm_mailcap");
	}

	if( argc < 2 ) {
		fprintf(stderr,"%s: too few arguments\n",argv[0]);
		return EXIT_FAILURE;
	}
	if( argc > 4 ) {
		fprintf(stderr,"%s: too many arguments\n",argv[0]);
		return EXIT_FAILURE;
	}
	if( argc == 4 )
		filename = argv[3];

	if( strncmp(argv[1],"--h",2) == 0 || 
	    strncmp(argv[1],"-h",2) == 0 || 
	    strcmp(argv[1],"-?") == 0 ) {
		puts(
"xfmmailcap: show what mailcap information xfm would get for a given type");
		puts(
"Syntax: xfmmailcap <mime-type> [(default|all|view|edit) [<filename>]]");
		return EXIT_SUCCESS;
	}
	if( argc == 2 || strcmp(argv[2],"default") == 0 ) {
		struct mime_filetype *type;
		bool found;

		type = mime_get_filetype(argv[1]);
		if( type == NULL )
			abort();
// enum mime_start_type { MIME_START_ANY, MIME_START_EDIT, MIME_START_VIEW };

		found = mime_best_action(type, "dummy", "dummy", MIME_START_ANY, show_action, true);
		if( !found ) {
			fprintf(stderr,"%s: Could not find any mailcap entry for '%s'\n",argv[0],argv[1]);
			return EXIT_FAILURE;
		}
	} else if( strcmp(argv[2],"edit") == 0 ) {
		struct mime_filetype *type;
		bool found;

		type = mime_get_filetype(argv[1]);
		if( type == NULL )
			abort();
// enum mime_start_type { MIME_START_ANY, MIME_START_EDIT, MIME_START_VIEW };

		found = mime_best_action(type, "dummy", "dummy", MIME_START_ANY, show_action, true);
		if( !found ) {
			fprintf(stderr,"%s: Could not find any mailcap entry for '%s'\n",argv[0],argv[1]);
			return EXIT_FAILURE;
		}
	} else if( strcmp(argv[2],"view") == 0 ) {
		struct mime_filetype *type;
		bool found;

		type = mime_get_filetype(argv[1]);
		if( type == NULL )
			abort();
// enum mime_start_type { MIME_START_ANY, MIME_START_EDIT, MIME_START_VIEW };

		found = mime_best_action(type, "dummy", "dummy", MIME_START_ANY, show_action, true);
		if( !found ) {
			fprintf(stderr,"%s: Could not find any mailcap entry for '%s'\n",argv[0],argv[1]);
			return EXIT_FAILURE;
		}
	} else if( strcmp(argv[2],"all") == 0 ) {
		struct mime_filetype *type;
		struct mime_action *action;

		type = mime_get_filetype(argv[1]);
		if( type == NULL ) {
			abort();
		}
		while( type != NULL ) {
			if( type->actions == NULL ) {
				fprintf(stderr,"Could not find any specific mailcap entry for '%s'\n",type->fulltypename);
				return EXIT_FAILURE;
			}
			for( action = type->actions ; action != NULL; action = action->next ) {
				showtype(action);
				if( action->next != NULL ) {
					printf("\nalternate:\n");
				}
			}
			type = type->fallback;
			if( type != NULL ) {
				fprintf(stderr, "\nfallback type is %s:\n",type->fulltypename);
				
			}
		}
	} else {
		fprintf(stderr,"%s: unknown command '%s'!\n",argv[0],argv[2]);
		return EXIT_FAILURE;

	}
	return EXIT_SUCCESS;
}
