//   This program is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//   You should have received a copy of the GNU General Public License
//   along with this program.  If not, see <http://www.gnu.org/licenses/>
//
//
// @author : pascal.fautrero@ac-versailles.fr


/*
 *
 * @constructor init specific hooks
 */
function hooks() {
    "use strict";
}
/*
 * @param array layers
 * @param iaScene mainScene
 */
hooks.prototype.beforeMainConstructor = function(mainScene, layers) {

};

/*
 * @param iaScene mainScene
 * @param array layers
 */
hooks.prototype.afterMainConstructor = function(mainScene, layers) {

    // some stuff to manage popin windows

    var button_click = function() {
        var target = $(this).data("target");
        if ($("#response_" + target).is(":hidden")) {
            if ($(this).data("password")) {
                $("#form_" + target).toggle();
                $("#form_" + target + " input[type=text]").val("");
                $("#form_" + target + " input[type=text]").focus();
            }
            else {
                $("#response_" + target).toggle();
            }
        }
        else {
            if ($(this).data("password")) {
                $("#response_" + target).html($("#response_" + target).data("encrypted_content"));
            }
            $("#response_" + target).toggle();
        }

    };
    var unlock_input = function(e) {
        e.preventDefault();
        var entered_password = $(this).parent().children("input[type=text]").val();
        var sha1Digest= new createJs(true);
        sha1Digest.update(entered_password.encode());
        var hash = sha1Digest.digest();
        if (hash == $(this).data("password")) {
            var target = $(this).data("target");
            var encrypted_content = $("#response_" + target).html();
            $("#response_" + target).data("encrypted_content", encrypted_content);
            $("#response_" + target).html(XORCipher.decode(entered_password, encrypted_content).decode());
            $("#response_" + target).show();
            $("#form_" + target).hide();
            $(".button").off("click");
            $(".button").on("click", button_click);
            $(".unlock input[type=submit]").off("click");
            $(".unlock input[type=submit]").on("click", unlock_input);
        }
    };
    $(".button").on("click", button_click);
    $(".unlock input[type=submit]").on("click", unlock_input);

    mainScene.score = $("#message_success").data("score");
    mainScene.score2 = $("#message_success2").data("score");

    $(".overlay").hide();

    $(".infos").on("click", function(){
        $("#rights").show();
        $("#popup").show();
        $("#popup_intro").hide();
    });
    $("#popup_close").on("click", function(){
        $("#rights").hide();
    });

    $("#popup_toggle").on("click", function(){
        $("#message_success_content").toggle();

        var strSource = $(this).attr('src')
        if (strSource.indexOf('hide.png') !== -1) {
            strSource = strSource.replace('hide.png', 'show.png')
        }
        else {
            strSource = strSource.replace('show.png', 'hide.png')    
        }
        $(this).attr('src', strSource)

    });

    $("#popup_toggle2").on("click", function(){
        $("#message_success_content2").toggle();

        var strSource = $(this).attr('src')
        if (strSource.indexOf('hide.png') !== -1) {
            strSource.replace('hide.png', 'show.png')
        }
        else {
            strSource.replace('show.png', 'hide.png')
        }
        $(this).attr('src', strSource)


    });


};
/*
 *
 *
 */
hooks.prototype.afterIaObjectConstructor = function(iaScene, idText, detail, iaObject) {


};
/*
 *
 *
 */
hooks.prototype.afterIaObjectZoom = function(iaScene, idText, iaObject) {

};

/*
 *
 *
 */
hooks.prototype.afterIaObjectFocus = function(iaScene, idText, iaObject, kineticElement) {
    var viewportHeight = $(window).height();
    $('#' + idText + " audio").each(function(){
        if ($(this).data("state") === "autostart") {
            $(this)[0].play();
        }
    });

    //var options = $('#' + idText).data("options");
    var options = kineticElement.getXiaParent().options;
    if (typeof(options) != "undefined") {
        if (options.indexOf("score2") != -1) {
            iaScene.currentScore2 += 1;
        }
        else if (options.indexOf("disable-score") == -1) {
            iaScene.currentScore += 1;
        }
    }
    if ((iaScene.score2 == iaScene.currentScore2) && (iaScene.score2 != 0)) {
        iaScene.currentScore = -1;
        $("#content").show();
        $("#message_success2").show();
        var general_border = $("#message_success2").css("border-top-width").substr(0,$("#message_success").css("border-top-width").length - 2);
        var general_offset = $("#message_success2").offset();
        var content_offset = $("#content").offset();
        $("#message_success2").css({'max-height':(viewportHeight - general_offset.top - content_offset.top - 2 * general_border)});
    }
    if ((iaScene.score == iaScene.currentScore) && (iaScene.score != 0)) {
        $("#content").show();
        $("#message_success").show();
        var general_border = $("#message_success").css("border-top-width").substr(0,$("#message_success").css("border-top-width").length - 2);
        var general_offset = $("#message_success").offset();
        var content_offset = $("#content").offset();
        $("#message_success").css({'max-height':(viewportHeight - general_offset.top - content_offset.top - 2 * general_border)});
    }

    if ((iaScene.score != 0) || (iaScene.score2 != 0)) {
        for (var i in iaObject.xiaDetail) {
            iaObject.xiaDetail[i].click = "off";
        }
    }

};
